#include "stdafx.h"
#include <windows.h>

/* transpose given xyz cube to yzx or zxy cube */

void TposeYZ( unsigned char *a1, unsigned char *a2, int *nx, int *ny, int *nz )
{
	//    xyz -> yzx : view is in x-direction
	int ix, iy, iz, in, iout;

	for(ix=0; ix< *nx; ix++) {
	for(iz=0; iz< *nz; iz++) {    in   =      *ny * (iz + *nz * ix);
	for(iy=0; iy< *ny; iy += 4) { iout = ix + *nx * (iy + *ny * iz);
		a2[iy   + in] = a1[iout        ];
		a2[iy+1 + in] = a1[iout + *nx    ];
		a2[iy+2 + in] = a1[iout + *nx * 2];
		a2[iy+3 + in] = a1[iout + *nx * 3];
	}}}
	return;
}

void TposeXZ( unsigned char *a1, unsigned char *a2, int *nx, int *ny, int *nz )
{
	//    xyz -> xzy : view is in y-direction
	int ix, iy, iz, in0, in1, in2, in3, iout0, iout1, iout2, iout3;

	for(iz=0; iz< *nz; iz++) {
	for(iy=0; iy< *ny; iy += 4) {

		in0   = *nx * (iz + *nz *  iy   );
		in1   = *nx * (iz + *nz * (iy+1));
		in2   = *nx * (iz + *nz * (iy+2));
		in3   = *nx * (iz + *nz * (iy+3));

		iout0 = *nx * (iy   + *ny * iz);
		iout1 = *nx * (iy+1 + *ny * iz);
		iout2 = *nx * (iy+2 + *ny * iz);
		iout3 = *nx * (iy+3 + *ny * iz);

		for(ix=0; ix< *nx; ix++) {
			a2[ix  + in0] = a1[ix + iout0];
			a2[ix  + in1] = a1[ix + iout1];
			a2[ix  + in2] = a1[ix + iout2];
			a2[ix  + in3] = a1[ix + iout3];
		}
	}}
	return;
}