////////////////////////////////////////////////////////////////////////////////
//
// Authors:  David H. Porter
//           Sarah Anderson
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  Sarah Anderson & David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/
struct Renderparams {
  float opacity;			/* opacity scaling, 1.0 is a good default */
  char cmapname[100];
  char amapname[100];

  int  nx,ny,nz;			/* input brick size */
  char bobname[100];		/* input brick pathname */
  char hvname[100];			/* input Hierarchical Volume pathname */

  int isectx,isecty;		/* section of whole image */
  int nsectx,nsecty;		/* Number of such subdivisions */
  int width,height;			/* produced image dimensions */
  int hpos, vpos;			/* ul corner of X window */

  int moviemode;			/* 0 for singleframe image files (old behavior) */
							/* In this case, imagename must be defined  */
							/* >0 diskmovie frame number.  */
							/* <0 -sharedmemory frame number. */

  int movieframes;			/* Total number of frames which will be generated */

  char imagename[100];		/* either image or movie must be nonblank.. */	
  char moviename[100];		/* if movie, we add to the end */

							/* viewing parameters, all relative to a
							 canonical -1:+1 coordinate, where the
					         X-dimension of the brick defines -1:+1 */
  float fovangle;			/* field of view, in the y direction */ 
  float eyeX,eyeY,eyeZ;
  float centerX,centerY,centerZ;
  float upX,upY,upZ;
  float eyedirX, eyedirY, eyedirZ;
  int   viewdefined[4];     /* flag for eye/center/up/eyedir defined */

  int   ifauxclip[6];		/* flag for enabled auxiliary clipping planes */
  float auxclip[6][4];		/* plane eqn Ax + By + Cz + D = 0 for each  */

  float my_near, my_far;
  float softdistance;
  float nplanes;			/* number of planes rendered per voxel at the
								far clipping distance */
  float maxplanes;			/* max number of planes rendered per voxel */
  int   boxcolor;			/* or -1 if no outline */
  int   saveslabs;			/* nonzero to save disk data to memory for reuse */
  int movieframe;
  int nfpk;					/* number of movie frames per key frame */
  int ntpf;					/* = 0 or 1: number of cdumps per movie frame */
  float nrpk;				/* number of rotations per key frame */

  int icoltolerance;		/* max color level error allowed with no scan down  */
  float angletolerance;		/* max angle allowed with no scan down              */
  float vrtolerance;		/* dx_brick > farclip * vrtolerance => no scan down */
};
