// hvr_work.h: interface for the Chvr_work class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HVR_WORK_H__BA5C7EB2_9719_11D4_AB18_00D0680005C4__INCLUDED_)
#define AFX_HVR_WORK_H__BA5C7EB2_9719_11D4_AB18_00D0680005C4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class Chvr_work  
{
public:
	void SetLUT(char *sAmap, char *sCmap);
	void ZoomEyePoint(int delx, int dely, int iMouseMode);
	void RestorKey(struct Renderparams *SKey);
	void SaveKey(struct Renderparams *SKey);
	void StopRendering();
	void SetRenderQuality(int iPixErr, float fAngleError, float fSizeError);
	void IncrementEyePoint(int delx, int dely, int iMouseMode);
	void CopyHvrInputs(void);
	void SetDefaultView(void);
	void SetDefaultFrustum(void);
	void SetFrustum(float *center, float *up, float *normal, int iWidth, int iHeight, float fWidth);
	void Set_HVname(char* cHVnew);
	void SetDoRender();
	bool DoRender();
	void SetClearColor(float f_red, float f_grn, float f_blu);
	void init(void);
	void StartUp();
	Chvr_work();
	virtual ~Chvr_work();
	void ClearIt(void);
	void draw_scene();

private:
	int m_iStopRendering;
	struct HvrInput {    // This structure contains all of the input needed for the hvr code

		int iNewHV;				// (1/0) = (Is/Is Not) new HVfile
		char sHVname[100];

		int iNewFrustum;		// (1/0) = (Is/Is Not) new frustum
		int iWidth;				// Pixel resolution of panel in horizontal
		int iHeight;			// Pixel resolution of panel in vertical
		float fPanCent[3];
		float fPanNorm[3];
		float fPanUp[3];
		float fHalfWidth;		// Half horizontal width of panel in object space
		float fHalfHeight;		// Half vertical height of panel in object space
		float fFovAngle;		// field of view, in the vertical direction
		float fAspectRatio;		// horizontal to vertical aspect ratio (=iHeight/iWidth=fHalfHeight/fHalfWidth)

		int iNewLUT;			// (1/0) = (Is/Is Not) new color/alpha Look Up Table
		char sCmapname[100];	// Name of color LUT file
		char sAmapname[100];	// Name of alpha LUT file

		int iNewView;			// (1/0) = (Is/Is Not) new view parameters
		float fEye[3];			// position of eye in object space
		float fCent[3];			// position of center of view in object space
		float fUp[3];			// up vector in opject space
		float fNearClip;		// distance to near clipping plane in object spece
		float fFarrClip;		// distance fo far clipping plane in object space
	};
	HvrInput m_ShvrIn;			// GUI writes input here
	HvrInput m_ShvrUse;			// Rendering code uses ShvrUse, after copying info from ShvrIn
	int m_iRender;
	float m_flClearRGB[3];
	float frgba[256][4];
	float opacity;		/* opacity scaling, 1.0 is a good default */

	int  Nx,Ny,Nz;	    /* Full brick size */
	int moviemode;      /* 0 for singleframe image files (old behavior) */
                        /* In this case, imagename must be defined  */
                        /* >0 diskmovie frame number.  */
                        /* <0 -sharedmemory frame number. */

                        /* viewing parameters, all relative to a
                           canonical -1:+1 coordinate, where the
                           X-dimension of the brick defines -1:+1 */
  int   viewdefined[4];     /* flag for eye/center/up/eyedir defined */

  int   ifauxclip[6];    /* flag for enabled auxiliary clipping planes */
  float auxclip[6][4];   /* plane eqn Ax + By + Cz + D = 0 for each  */

  float softdistance;
  float nplanes;	/* number of planes rendered per voxel at the
			           far clipping distance */
  float maxplanes;	/* max number of planes rendered per voxel */
  int   boxcolor;	/* or -1 if no outline */

  int   tolerance;		/* max color level error allowed with no scan down  */
  float angtol;			/* max angle allowed with no scan down              */
  float viewres;		/* dx_brick > farclip * vrtolerance => no scan down */



// ====================================================================================
// Rendering variables

#define NPMAX 100			/* Maximum number of pannels */

GLuint texname[256];		/* GL 2D textures */
char *rgbpannel[NPMAX];		/* RGB pannels */
int pannels_initted;		/* malloc rgppannels only once */
int ipcur;					/* current pannel loaded into rgbpannel */
int isubcur;				/* current sub-brick loaded into bobsub */
int ireload;				/* flag to reload brick in 3dtex code   */
int npannel;				/* number of pannels (in PW_CONFIGURATION) */
GLfloat Aspect;				/* Output image aspect ratio = horizontal/vertical */
float Pid180;				/* Radian to degree conversion factor */
};

#endif // !defined(AFX_HVR_WORK_H__BA5C7EB2_9719_11D4_AB18_00D0680005C4__INCLUDED_)
