// hvr_work.cpp: implementation of the Chvr_work class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#include <sys/timeb.h>
// #include <GL/gl3dlabsext.h>
#include "C:\include\GL\gl3dlabsext.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <math.h>

#include "C:\include\GL\glut.h"
// #include "mui.h"

#include "renderparams.h"
//  lude "hvr_mfc.h"
#include "hvr_work.h"

//  ine DHP_TEX GL_COLOR_INDEX8_EXT
#define DHP_TEX GL_TEXTURE_2D

static unsigned char bobsubX[256*256*256];
static unsigned char bobsubY[256*256*256];
static unsigned char bobsubZ[256*256*256];

static    HDC hDC;					/* device context */
static    HGLRC hRC;				/* opengl context */
static    HWND  hWnd;				/* window */
static    MSG   msg;				/* message */

typedef void (APIENTRY *PFNGLCOLORTABLEPROC)
	(GLenum target, GLenum internalformat, GLsizei width,
	GLenum format, GLenum type, const GLvoid *data );
PFNGLCOLORTABLEPROC glColorTableEXT;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Chvr_work::Chvr_work()
{
	int i, j;
    void  setstr(char*, char*);

	isubcur = -1;         /* current sub-brick loaded into bobsub */
	ireload = 1;          /* flag to reload brick in 3dtex code   */
	Pid180 = (3.141592654/180.);
	m_flClearRGB[0] = 0.;
	m_flClearRGB[1] = 0.;
	m_flClearRGB[2] = 0.;
	m_iRender = 0;
	m_ShvrIn.iNewHV      = 1;
	m_ShvrIn.iNewLUT     = 1;
	m_ShvrIn.iNewView    = 1;
	m_ShvrIn.iNewFrustum = 1;
	m_iStopRendering = 0;

	SetDefaultFrustum();
	SetDefaultView(); 

//	setstr(m_ShvrIn.sHVname, "E:\\dhp/src/hvr_mfc2/test_pattern.hv");
	setstr(m_ShvrIn.sCmapname, "default");
	setstr(m_ShvrIn.sAmapname, "default");

//	setstr(m_ShvrIn.sHVname,   "W:\\ApricotA/data/v72dT/v72dT0400.hv");
//	setstr(m_ShvrIn.sCmapname, "W:\\ApricotA/data/lut/Cbar_v72dT");
//	setstr(m_ShvrIn.sAmapname, "W:\\ApricotA/data/lut/Abar_v72dT");

//	setstr(m_ShvrIn.sHVname,   "C:\\dhp/data/v72dT0400.hv");
//	setstr(m_ShvrIn.sCmapname, "C:\\dhp/data/Cbar_v72dT");
//	setstr(m_ShvrIn.sAmapname, "C:\\dhp/data/Abar_v72dT");

//	setstr(hvname, "C:\\dhp/data/v72dT0400.hv");
//	setstr(m_ShvrIn.sCmapname, "W:\\ApricotA/data/v72dT/Cbar_dT");
//	setstr(m_ShvrIn.sAmapname, "W:\\ApricotA/data/v72dT/Abar_dT");

	for(i=0; i<256; i++) { for(j=0; j<4; j++) { frgba[i][j] = (float)i; }}

	tolerance = 6;		/* max color level error allowed with no scan down  */
	angtol    = 0.0;	/* max angle allowed with no scan down              */
	viewres   = 0.1;	/* dx_brick > farclip * vrtolerance => no scan down */
	nplanes   = 1;
	opacity   = 1.0;
	pannels_initted = 0;
	softdistance = 0.;
}

Chvr_work::~Chvr_work()
{

}

void Chvr_work::ClearIt(void)
{
	float x;
	m_iRender = 0;
	x               = m_flClearRGB[0];
	m_flClearRGB[0] = m_flClearRGB[1];
	m_flClearRGB[1] = m_flClearRGB[2];
	m_flClearRGB[2] =               x;
	glClearColor(m_flClearRGB[0], m_flClearRGB[1], m_flClearRGB[2], 1.0);
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glFlush();
}

LPVOID pParam;
static int iOpenGL_WindowIsOpenned = 0;

void OpenAWindow(void)
{
	// Only do the body of this function ONCE per instance of the host program
	if(iOpenGL_WindowIsOpenned == 1) return;
	iOpenGL_WindowIsOpenned = 1;

	Chvr_work* my_work = (Chvr_work*)pParam;

	my_work->init();

	while(TRUE) {
		if(my_work->DoRender()) { my_work->draw_scene(); }
		else                    { SleepEx(10, FALSE); }
	}
}

void Chvr_work::StartUp()
{
    int depth = 0, width, height;
	BYTE  colortype;
	DWORD buffertype;
	char s[4096];
	HWND CreateOpenGLWindow(char* title, int x, int y, int width, int height, 
		   BYTE type, DWORD flags, int depth);

/************************************************************
 *  Here's how to create an OpenGL window using wgl         *
 ************************************************************/
	*s = '\0';
	strcat(s,"HVR - INTERACTIVE");
	colortype = PFD_TYPE_RGBA;
	buffertype = PFD_DOUBLEBUFFER;
//	buffertype = 0;
	depth = 24;
	/*
	width = m_ShvrIn.iWidth;
	height = m_ShvrIn.iHeight;
	*/
	width = 512;
	height = 512;

    hWnd = CreateOpenGLWindow(s, 0, 0, width, height, colortype, buffertype, depth);
    if (hWnd == NULL) { exit(1); }
	hDC = GetDC(hWnd);
	hRC = wglCreateContext(hDC);
	wglMakeCurrent(hDC, hRC);

	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
	init();
/*
	int argc;
	char *argv[100];
    pParam = this;
    CopyHvrInputs();
	argc = 2;
	argv[0] = "hvr";
	argv[1] = "tri";
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_RGB | GLUT_SINGLE);
	glutCreateWindow("hvr GOOP GLUT");
	glutReshapeWindow(m_ShvrUse.iWidth, m_ShvrUse.iHeight);
	glutDisplayFunc(OpenAWindow);
	glutMainLoop();
*/
}

//DEL int Chvr_work::SetNx(int nx_set)
//DEL {
//DEL 	width = nx_set;
//DEL 	return width;
//DEL }

//DEL int Chvr_work::SetNy(int ny_set)
//DEL {
//DEL 	height = ny_set;
//DEL 	return height;
//DEL }



/* ================================================================
   Round to next power of two.
 */

static int 
roundup( int n ) {
  int i, k;
  i = 2;  k = 1;
  while ( i < n ) { i<<=1; ++k; }
  return (1<<k);
}

void Chvr_work::draw_scene()
{
    float eye[3], up[3], torq[3];
    int i, j, k, nslices, ntiles, ididread;
    int isub, jsub, ixoff, iyoff, izoff;
    int nxsub, nysub, nzsub, nr, iprint;
    int nxsb2, nysb2, nzsb2;
    int isoutside_n, isoutside_f, isoutside_t;
    int isoutside_b, isoutside_l, isoutside_r;

    float facXtoN;
    float subvolsiz[3], subminpos[3], fulminpos[3], submaxpos[3];
    float alpha, alpha0, fac, dsfar, dsnear;
    float xx, yy, zz, axx, ayy, azz, dz;
	int   idir, ids0, idsd;
	float dxv, xxv, dyv, yyv, zzv;
    float dsmax, dsmin;
    float edgedist, edgemin, edgemax;
    float ss,ds,sfinish,hdistfac,vdistfac;
    float eyepos[3],cubesz[3];
	static char old_cmap[1024] = "none", old_amap[1024] = "default";
    static char old_hvname[1024] = "none";

    GLfloat  dx,dy;
    GLdouble dleft,dright,dbottom,dtop, dnearclip,dfarclip;
    GLdouble dxsect, dysect;

/* frustum stuff */
    void crossprod(float vec1[3], float vec2[3], float vec3[3]);
/* frustum stuff */


/* subtile stuff */
    float fminx,fminy,fminz,distmax, tile_dist[2048];
    int ippp, iccc, nccc, nlist, list_tiles[2048], tile_did[2048];
    int inode, ilist, nlistnew, need_check, list_new[2048];
    float delxmin;
    float distmin, delxtol, delxsize;
/* subtile stuff */

/* subtile io stuff */
      static char *seps = " ,;\t\n";
      static int nsub, node0;
      static long tile_off64t[2048];
      static int tile_nrep[2048];
      static int tile_nxsub[2048], tile_nysub[2048], tile_nzsub[2048];
      static int tile_ixoff[2048], tile_iyoff[2048], tile_izoff[2048];
      static int tile_parent[2048];
      static int tile_maxerr[2048];
      static int ncPath;
      static char tile_file[2048][64], tile_path[64], tile_full[100];
      static char line[256];
      static int tile_children[2048][32];
	  FILE *fpp;
/* subtile io stuff */

/* IO stuff */
    int nbytes, nbin;
	FILE *fdd;
    long offset64t;
/* IO stuff */

/* multiple pannel stuff */
    int   ip;
    float d, dhorz, dvert, pcn, pan_cenmagi[NPMAX];
    float pan_eye[NPMAX][3],pan_up[NPMAX][3],pan_center[NPMAX][3];
    float pan_lookat[NPMAX][3],pan_torq[NPMAX][3],pan_dlef[NPMAX];
    float pan_drit[NPMAX],pan_dbot[NPMAX],pan_dtop[NPMAX];
    float pan_lefpar[NPMAX][3],pan_ritpar[NPMAX][3],pan_toppar[NPMAX][3];
    float pan_botpar[NPMAX][3],pan_lef_o[NPMAX][3],pan_rit_o[NPMAX][3];
    float pan_top_o[NPMAX][3], pan_bot_o[NPMAX][3];
/* multiple pannel stuff */

/* slice stuff */
    int islicesize, islice, isliceoff;
    float xx0, xx1, yy0, yy1;
/* slice stuff */

/* prototyping functions */
    int match( char *token, char *word, int tokenlength );
    float dotproduct( const float*, const float* );
	void vnormalize( float v[3] );
    int   strdif(char*, char*);
    void  setstr(char*, char*);
    int readCmap( char *clrname, char *alpname, float ftable[256][4] );
	void TposeYZ( unsigned char *a1, unsigned char *a2, int *nx, int *ny, int *nz );
	void TposeXZ( unsigned char *a1, unsigned char *a2, int *nx, int *ny, int *nz );
/* prototyping functions */

	// Copy from GUI input struct to hvr use struct
	// Set all iNew flags to the status of NOT new.
    CopyHvrInputs();

    iprint = 1;

    if(strdif(old_hvname, m_ShvrUse.sHVname) == 1) {
      setstr(old_hvname, m_ShvrUse.sHVname);
      fpp = fopen(m_ShvrUse.sHVname, "r");
//	  MessageBox(hWnd, m_ShvrUse.sHVname, NULL, MB_OK);
	  if(fpp == NULL) {
		  MessageBox(hWnd, "Can NOT open HV file", "LALA", MB_OK);
//		  fpp = fopen("error.txt", "w");
//		  fprintf(fpp, "Pointer to hv file %s is NULL\n", m_ShvrUse.sHVname);
//		  fclose(fpp);
		  exit(0);
	  }
      nsub = 0;
      node0 = -1;
      while (node0 < 0) {
        i = match(fgets(line,200,fpp), "end", 3);
        strncpy(tile_file[nsub], strtok( line,seps ), 64);
        tile_off64t[nsub] = (long)atoi( strtok(NULL,seps) );
        tile_nrep[nsub]   = atoi( strtok(NULL,seps) );
        tile_nxsub[nsub]  = atoi( strtok(NULL,seps) );
        tile_nysub[nsub]  = atoi( strtok(NULL,seps) );
        tile_nzsub[nsub]  = atoi( strtok(NULL,seps) );
        tile_ixoff[nsub]  = atoi( strtok(NULL,seps) );
        tile_iyoff[nsub]  = atoi( strtok(NULL,seps) );
        tile_izoff[nsub]  = atoi( strtok(NULL,seps) );
        tile_parent[nsub] = atoi( strtok(NULL,seps) );
        tile_maxerr[nsub] = atoi( strtok(NULL,seps) );
        if(tile_parent[nsub] < 0) { node0 = nsub; }

        nsub++;
      }
      fclose(fpp);
	  isubcur = -1;         /* current sub-brick loaded into bobsub */
    }

    ncPath = 0;
    for(i=0; i<100; i++) { if(m_ShvrUse.sHVname[i] == '/') { ncPath = i+1; }}
    for(i=0; i<ncPath; i++) { tile_path[i] = m_ShvrUse.sHVname[i]; }
    tile_path[ncPath] = '\0';

    nbytes = m_ShvrUse.iHeight * m_ShvrUse.iWidth * 3;

    if(pannels_initted == 0) {
      for(ip=0; ip<npannel; ip++) { rgbpannel[ip]  = (char*)malloc(nbytes); }
      pannels_initted = 1;
    }

    for(ip=0; ip<npannel; ip++) {
      for(k=0; k<nbytes; k++) { rgbpannel[ip][k] = 0; }
    }
    ipcur = -1;

   /************************************************************************
    *  Generate horizontal, vertical, and alpha scalings                   *
    ************************************************************************/
    vdistfac = tan(0.5*Pid180 * m_ShvrUse.fFovAngle);
	hdistfac = vdistfac / m_ShvrUse.fAspectRatio;
    alpha0 = opacity * 128.0;

    dnearclip = m_ShvrUse.fNearClip;
    dfarclip  = m_ShvrUse.fFarrClip;
    dx = hdistfac * dnearclip;
    dy = vdistfac * dnearclip;

    /* Check for rendering only a section of the final image */

    dxsect = 2.0 * dx;
	dysect = 2.0 * dy;

   /************************************************************************
    * Right handed ONB  which power-wall frame is attached to :            *
    * (eye[], up[], torq[])                                                *
    ************************************************************************/
    for(i=0; i<3; i++) {
		eye[i]    = m_ShvrUse.fCent[i] - m_ShvrUse.fEye[i];	/* direction eye looks in */
		up[i]     = m_ShvrUse.fUp[i];
		eyepos[i] = m_ShvrUse.fEye[i];
	}
    vnormalize(eye);

    /* Insist that up is normal to eye */
    d = dotproduct(eye,up);
    for (i=0; i<3; ++i) { up[i] = up[i]- eye[i]*d; }
    vnormalize( up );

    /* Construct the cross vector 'torque' */
    torq[0] = eye[1]*up[2] - eye[2]*up[1];
    torq[1] = eye[2]*up[0] - eye[0]*up[2];
    torq[2] = eye[0]*up[1] - eye[1]*up[0];
/*
	fpp = fopen("rend_ONB.out", "w");
	fprintf(fpp, "NEW ONE\n");
    fprintf(fpp, "eye  = %f %f %f\n", eye[0], eye[1], eye[2]);
    fprintf(fpp, "up   = %f %f %f\n", up[0],  up[1],  up[2]);
    fprintf(fpp, "torq = %f %f %f\n", torq[0],torq[1],torq[2]);
      for(ip=0; ip<npannel; ip++) {
		fprintf(fpp, "ip = %d\n", ip);
        fprintf(fpp, "pw_normal= %f %f %f\n",
                pw_normal[ip][0],pw_normal[ip][1],pw_normal[ip][2]);
        fprintf(fpp, "pw_up    = %f %f %f\n",
                pw_up[ip][0],pw_up[ip][1],pw_up[ip][2]);
        fprintf(fpp, "pw_center= %f %f %f\n",
                pw_center[ip][0],pw_center[ip][1],pw_center[ip][2]);
      }

	fclose(fpp);
*/
    for(ip=0; ip<npannel; ip++) {
      for(i=0; i<3; i++) {
        pan_eye[ip][i]    = m_ShvrUse.fPanNorm[0] * torq[i] + 
                            m_ShvrUse.fPanNorm[1] *  eye[i] +
                            m_ShvrUse.fPanNorm[2] *   up[i];

        pan_up[ip][i]     = m_ShvrUse.fPanUp[0] * torq[i] + 
                            m_ShvrUse.fPanUp[1] *  eye[i] +
                            m_ShvrUse.fPanUp[2] *   up[i];

        pan_center[ip][i] = m_ShvrUse.fPanCent[0] * torq[i] + 
                            m_ShvrUse.fPanCent[1] *  eye[i] +
                            m_ShvrUse.fPanCent[2] *   up[i];

        pan_lookat[ip][i] = eyepos[i] + pan_eye[ip][i];
      }

      vnormalize(pan_eye[ip]);
      vnormalize(pan_up[ip]);
      crossprod(pan_eye[ip], pan_up[ip], pan_torq[ip]);
      vnormalize(pan_torq[ip]);


     /***************************************************************
      * pan_center is position of the center (relative to the eye) of the pannel
      *   to be used in generating horizontal and vertical offset of
      *   pannel window
      * pan_lookat is a point in the direction normal to the pannel
      *   to be used in glLookAt
      * NOTE: the pannel must be centered on the normal to the eyeposition
      *       for pan_center & pan_lookat to be the same
      * NOTE: pan_center is NOT normalized
      *       ss * pan_dlef ... are shifts on a plane at a distance ss
      *       pan_cenmagi[ip] is the correction factor.
      ***************************************************************/
      pan_cenmagi[ip] = 1. / dotproduct(pan_eye[ip], pan_center[ip]);
      dhorz = dotproduct(pan_center[ip], pan_torq[ip]);
      dvert = dotproduct(pan_center[ip], pan_up[ip]);

      pcn = 1. / pan_cenmagi[ip];
      pan_dlef[ip] = (dhorz - m_ShvrUse.fHalfWidth ) * pan_cenmagi[ip];
      pan_drit[ip] = (dhorz + m_ShvrUse.fHalfWidth ) * pan_cenmagi[ip];
      pan_dbot[ip] = (dvert - m_ShvrUse.fHalfHeight) * pan_cenmagi[ip];
      pan_dtop[ip] = (dvert + m_ShvrUse.fHalfHeight) * pan_cenmagi[ip];
/*
	  fpp = fopen("rend_ONB.out", "a+");
	  fprintf(fpp, "ip = %d\n", ip);
	  fprintf(fpp, "Pid180= %f, fovangle=%f Aspect=%f\n", Pid180, m_ShvrUse.fFovAngle, m_ShvrUse.fAspectRatio);
	  fprintf(fpp, "pan_drit= %f, dhorz=%f\n", pan_drit[ip], dhorz);
	  fprintf(fpp, "half_width= %f, pan_cenmagi[ip]=%f\n", m_ShvrUse.fHalfWidth, pan_cenmagi[ip]);
	  fprintf(fpp, "pan_up     = %f %f %f\n",pan_up[ip][0],pan_up[ip][1],pan_up[ip][2]);
	  fprintf(fpp, "pan_torq   = %f %f %f\n",pan_torq[ip][0],pan_torq[ip][1],pan_torq[ip][2]);
	  fprintf(fpp, "pan_center = %f %f %f\n",pan_center[ip][0],pan_center[ip][1],pan_center[ip][2]);
	  fclose(fpp);
*/
    }

    /* modelview aspect for the entire mesh is based on X size. */
	Nx = tile_nrep[node0] * tile_nxsub[node0];
	Ny = tile_nrep[node0] * tile_nysub[node0];
	Nz = tile_nrep[node0] * tile_nzsub[node0];
    cubesz[0]= 1.0;
    cubesz[1]= (float)Ny/Nx;
    cubesz[2]= (float)Nz/Nx;

    for(ip=0; ip<npannel; ip++) {
     /************************************************************************
      * Generate outward orthogonal surface vectors for 4 planes of the      *
      * viewing frustum.  They do not need to be normalized.                 *
      * These are used below to determine if a tile is OUTSIDE the frustum   *
      * Power wall change:  In principle, need to do these 4 planes for each *
      * pannel of a power wall.  In practice, it is actually easiest to, in  *
      * fact, do each of the pannels individuallys.  The condition on which  *
      * a tile is read in is simply that any part of the tile is in any one  *
      * of the pannels viewing frustum.                                      * 
      ************************************************************************/
      for(i=0; i<3; i++) {
        pan_lefpar[ip][i] = pan_eye[ip][i] + pan_dlef[ip]*pan_torq[ip][i];
        pan_ritpar[ip][i] = pan_eye[ip][i] + pan_drit[ip]*pan_torq[ip][i];
        pan_toppar[ip][i] = pan_eye[ip][i] + pan_dtop[ip]*pan_up[ip][i];
        pan_botpar[ip][i] = pan_eye[ip][i] + pan_dbot[ip]*pan_up[ip][i];
      }
                                            /* outward orthogonal vector at */
      crossprod(pan_up[ip],     pan_lefpar[ip], pan_lef_o[ip]); /*     left */
      crossprod(pan_ritpar[ip], pan_up[ip],     pan_rit_o[ip]); /*    right */ 
      crossprod(pan_torq[ip],   pan_toppar[ip], pan_top_o[ip]); /*      top */
      crossprod(pan_botpar[ip], pan_torq[ip],   pan_bot_o[ip]); /*   bottom */
/*
	  fpp = fopen("rend_ONB.out", "a+");
	  fprintf(fpp, "ip = %d\n", ip);
	  fprintf(fpp, "pan_ritpar= %f %f %f\n", pan_ritpar[ip][0],pan_ritpar[ip][1],pan_ritpar[ip][2]);
	  fprintf(fpp, "pan_up    = %f %f %f\n", pan_up[ip][0],pan_up[ip][1],pan_up[ip][2]);
	  fprintf(fpp, "pan_rit_o = %f %f %f\n", pan_rit_o[ip][0],pan_rit_o[ip][1],pan_rit_o[ip][2]);
	  fclose(fpp);
*/
    }

    if(iprint == -1) { exit(0); }

/***************************************************************************
 * INPUT: color map information                                            *
 ***************************************************************************/
    if(strdif(m_ShvrUse.sCmapname, old_cmap) == 1) {
      setstr(old_cmap, m_ShvrUse.sCmapname);
      if(strdif(m_ShvrUse.sCmapname, "default") == 1) {
		  ididread = readCmap( m_ShvrUse.sCmapname, m_ShvrUse.sAmapname, frgba );
		  if(ididread < 0) {
				MessageBox(hWnd, "Can NOT open alpha/color maps", "LALA", MB_OK);
				exit(0);
		  }
	  }
      glColorTableEXT(DHP_TEX, GL_RGBA,256,GL_RGBA, GL_FLOAT,frgba);
    }
//	readCmap( cmapname, amapname, frgba );
//	fpp = fopen("colors.out", "w");
//	for(i=0; i<256; i++) { fprintf(fpp, "red[%3d] = %3d\n", i, (int)(256.*frgba[i][0])); }
//	fclose(fpp);
//	glColorTableEXT(DHP_TEX, GL_RGBA,256,GL_RGBA,
//                    GL_FLOAT,frgba);

//  glColorTableEXT(GL_TEXTURE_3D_EXT, GL_RGBA,256,GL_RGBA,
//                  GL_FLOAT,frgba);

//	glColorTableSGI(GL_TEXTURE_COLOR_TABLE_SGI, GL_RGBA,256,GL_RGBA,
//                  GL_FLOAT,frgba);


    /* This clear is as late as possible */
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

/***************************************************************************
 * INPUT: tile information                                                 *
 ***************************************************************************/
    for(i=0; i<nsub; i++) { tile_children[i][0] = -1; }
    for(i=0; i<nsub; i++) { 
      ippp = tile_parent[i];
      nccc = 0;
      while(tile_children[ippp][nccc] >= 0) { nccc++; }
      tile_children[ippp][nccc  ] =  i;
      tile_children[ippp][nccc+1] = -1;
    }
    printf("tile_children lists generated\n");
/*
    i = 0;
    while(tile_children[node0][i] >= 0) {
      iccc = tile_children[node0][i];
      printf("child of node0 = %d    maxerr = %d\n", iccc, tile_maxerr[iccc]);
      i++;
    }
*/

/*****************************************************************************
 * GENERATE: distance**2 to each tile (rendering is done farthest to nearest *
 *           under each node                                                 *
 *****************************************************************************/
    fminx = -1.                          - eyepos[0];
    fminy = -1. * (float)Ny / (float)Nx  - eyepos[1];
    fminz = -1. * (float)Nz / (float)Nx  - eyepos[2];
    for(i=0; i<nsub; i++) {
      nr = tile_nrep[i];
      xx = fminx + (float)(nr*(2*tile_ixoff[i]+tile_nxsub[i]))/(float)Nx;
      yy = fminy + (float)(nr*(2*tile_iyoff[i]+tile_nysub[i]))/(float)Nx;
      zz = fminz + (float)(nr*(2*tile_izoff[i]+tile_nzsub[i]))/(float)Nx;
      tile_dist[i] = xx*xx + yy*yy + zz*zz;
      tile_did[i] = 0;
    }

/*****************************************************************************
 * GENERATE: ordered list of tiles                                           *
 *****************************************************************************/
    delxmin = 0.;
    if(viewres > 0.) { delxmin = m_ShvrUse.fFarrClip * viewres; }

    nlist = 1;
    list_tiles[0] = node0;
    need_check = 1;

    while(need_check == 1) {
      nlistnew = 0;
      need_check = 0;
      for(ilist = 0; ilist<nlist; ilist++) {
        inode = list_tiles[ilist];

        distmin = sqrt(tile_dist[inode]);

        delxtol  = distmin * angtol;
        delxsize =  (float)tile_nrep[inode] / ((float)Nx/2);

        if(tile_maxerr[inode] <= tolerance || delxsize < delxtol
                                           || delxsize < delxmin) {
          list_new[nlistnew] = inode;
          nlistnew++;
        } else {
          need_check = 1;
          nccc = 0;
          while(tile_children[inode][nccc] >= 0) { nccc++; }
          isub = 1;
          while(isub >= 0) {
            distmax = -10000000.;
            isub = -1;
            for(iccc = 0; iccc < nccc; iccc++) {
              i = tile_children[inode][iccc];
              if(tile_did[i] == 0) {
                if(distmax < tile_dist[i]) { isub=i; distmax = tile_dist[i]; }
              }
            }
            if(isub >= 0) {
              list_new[nlistnew] = isub;
              nlistnew++;
              tile_did[isub] = 1;
            }
          }
        }
      }
      for(i=0; i<nlistnew; i++) { list_tiles[i] = list_new[i]; }
      nlist = nlistnew;
    }
    
/*****************************************************************************
 *  RENDER: loop over tiles in this list                                     *
 *****************************************************************************/
    ntiles  = 0;
    nslices = 0;
//	fpp = fopen("render_loop.out", "w");
//	fprintf(fpp, "NEW ONE starting loop: nlist = %d\n", nlist);
//	fclose(fpp);
    for(jsub=0; jsub<nlist; jsub++) {
		if(m_iStopRendering == 1) {
			m_iStopRendering = 0;
			return;
		}
      isub = list_tiles[jsub];
//	  fpp = fopen("render_loop.out", "a+");
//    fprintf(fpp, "jsub=%4d    isub=%4d\n", jsub, isub);
//	  fclose(fpp);

      nr = tile_nrep[isub];
      nxsub = tile_nxsub[isub];
      nysub = tile_nysub[isub];
      nzsub = tile_nzsub[isub];
      ixoff = tile_ixoff[isub];
      iyoff = tile_iyoff[isub];
      izoff = tile_izoff[isub];
      offset64t = tile_off64t[isub];
      nbytes    = nxsub * nysub * nzsub;

/***************************************************************************
 *    hvr: subroutine "subvolrend" starts here                             *
 *    INPUTS: ixoff, iyoff, izoff, nxsub, nysub, nzsub, Nx, Ny, Nz         *
 *                                                                         *
 *    ixoff = x-offset of subvolume from left/min-edge of full volume      *
 *    iyoff = y-offset of subvolume from left/min-edge of full volume      *
 *    izoff = z-offset of subvolume from left/min-edge of full volume      *
 *    nxsub = x-dim size of sub-volume (not nec. power of 2, but <= 256)   *
 *    nysub = y-dim size of sub-volume (not nec. power of 2, but <= 256)   *
 *    nzsub = z-dim size of sub-volume (not nec. power of 2, but <= 256)   *
 *    Nx    = x-dim of full volume (not nec. power of 2, unlimitted size)  *
 *    Ny    = y-dim of full volume (not nec. power of 2, unlimitted size)  *
 *    Nz    = z-dim of full volume (not nec. power of 2, unlimitted size)  *
 *                                                                         *
 *    NOTE: ALL INPUTS ARE IN ZONES (int); ALL ZONES ARE CUBES             *
 ***************************************************************************/

/***************************************************************************
 *    CALCULATE: size and position of subvolume (in modelview space)       *
 *    CONVENTIONS: 1) x-dim always goes from (-1, 1);                      *
 *                 2) all zones are cubes                                  *
 *    ==>  y-dim goes from (-Ny/Nx, +Ny/Nx)                                *
 *    ==>  z-dim goes from (-Nz/Nx, +Nz/Nx)                                *
 *                                                                         *
 *    fulminpos[3] = xyz coordinates of min-vertex of full volume          *
 *    subminpos[3] = xyz coordinates of min-vertex of sub volume           *
 *    subvolsiz[3] = xyz size of subvolume                                 *
 *    subtexsiz[3] = xyz size of power of 2 texture subvolume in which     *
 *                   input subvolume is imbedded                           *
 *                                                                         *
 *                                                                         *
 *    +------------------------+ -  +Ny/Nx                                 *
 *    |                        | ^                                         *
 *    |                        | |                                         *
 *    |                        | |                                         *
 *    |    |<--- A --->|       | |     A = subtexsiz[0] = 2**n always      *
 *    |                        | |     B = subtexsiz[1] = 2**n always      *
 *    |    +-----------+ -     | |     C = subvolsiz[0]                    *
 *    |    |           | ^     | |     D = subvolsiz[1]                    *
 *    |    +-------+   | |     |       E = subminpos[0]                    *
 *    |    |   C   |   |       | Ny    F = subminpos[1]                    *
 *    |    |       |   | B     |       G = fulminpos[0] = -1 always        *
 *    |    |      D|   |       | |     H = fulminpos[1] = -Ny/Nx always    *
 *    |    |       |   | |     | |                                         *
 *    |    |       |   | v     | |                                         *
 *    |    +-------+---+ -     | |                                         *
 *    |  (E,F)                 | |                                         *
 *    |                        | |                                         *
 *    |                        | v                                         *
 *    +------------------------+ -  -Ny/Nx                                 *
 *  (G,H)                                                                  *
 *    |<--------- Nx --------->|                                           *
 *   -1                       +1                                           *
 *                                                                         *
 ***************************************************************************/
      fulminpos[0] = -1.;
      fulminpos[1] = -1. * (float)Ny / (float)Nx;
      fulminpos[2] = -1. * (float)Nz / (float)Nx;

      facXtoN = 2.0 / (float)Nx;

      subminpos[0] = fulminpos[0] + (float)(ixoff*nr) * facXtoN;
      subminpos[1] = fulminpos[1] + (float)(iyoff*nr) * facXtoN;
      subminpos[2] = fulminpos[2] + (float)(izoff*nr) * facXtoN;
  
      subvolsiz[0] = (float)(nxsub*nr) * facXtoN;
      subvolsiz[1] = (float)(nysub*nr) * facXtoN;
      subvolsiz[2] = (float)(nzsub*nr) * facXtoN;

      for(i=0; i<3; i++) { submaxpos[i] = subminpos[i] + subvolsiz[i]; }

      nxsb2 = 2;   while(nxsb2 < nxsub) { nxsb2 *= 2; }
      nysb2 = 2;   while(nysb2 < nysub) { nysb2 *= 2; }
      nzsb2 = 2;   while(nzsb2 < nzsub) { nzsb2 *= 2; }

     /*********************************************************************
      * START of ip loop -- LOOP over pannels                             *
      *********************************************************************/
//	  fpp = fopen("render_loop.out", "a+");
//	  fprintf(fpp, "npannel = %d\n", npannel);
//	  fclose(fpp);
      for(ip=0; ip < npannel; ip++) {

     /*********************************************************************
      * Derive min and max distances for edges of each tile               *
      * As a byproduct, determine if tile is OUTSIDE the viewing frustum  *
      * A tile is OUTSIDE of a convex faceted volume if all 8 vertices    *
      * of the tile are on the outer side of any one plane tangent to     *
      * a facet of that volume.  Viewing frustums are convex.             *
      *********************************************************************/
      edgemin = 10000000.;
      edgemax = 0.;
      isoutside_n = 1;  /* near   */
      isoutside_f = 1;  /* far    */
      isoutside_t = 1;  /* top    */
      isoutside_b = 1;  /* bottom */
      isoutside_l = 1;  /* left   */
      isoutside_r = 1;  /* right  */
      for(i=0; i<2; i++) { xx = subminpos[0]+(float)i*subvolsiz[0]-eyepos[0];
      for(j=0; j<2; j++) { yy = subminpos[1]+(float)j*subvolsiz[1]-eyepos[1];
      for(k=0; k<2; k++) { zz = subminpos[2]+(float)k*subvolsiz[2]-eyepos[2];
        edgedist = (xx*pan_eye[ip][0]+yy*pan_eye[ip][1]+zz*pan_eye[ip][2]);
//		fpp = fopen("render_loop.out", "a+");
//	    fprintf(fpp, "xx=%f   yy=%f   zz=%f  edgedist=%f\n", xx, yy, zz, edgedist);
//		fclose(fpp);
        if(edgemin > edgedist) { edgemin = edgedist; }
        if(edgemax < edgedist) { edgemax = edgedist; }

        if(edgedist > m_ShvrUse.fNearClip - softdistance   ) { isoutside_n = 0; }
        if(edgedist < m_ShvrUse.fFarrClip + softdistance   ) { isoutside_f = 0; }
        if(xx*pan_top_o[ip][0]+yy*pan_top_o[ip][1]
                              +zz*pan_top_o[ip][2] < 0. ) { isoutside_t = 0; }
		if(xx*pan_bot_o[ip][0]+yy*pan_bot_o[ip][1]
                              +zz*pan_bot_o[ip][2] < 0. ) { isoutside_b = 0; }
        if(xx*pan_lef_o[ip][0]+yy*pan_lef_o[ip][1]
                              +zz*pan_lef_o[ip][2] < 0. ) { isoutside_l = 0; }
        if(xx*pan_rit_o[ip][0]+yy*pan_rit_o[ip][1]
                              +zz*pan_rit_o[ip][2] < 0. ) { isoutside_r = 0; }
      }}}
/*
fprintf(fpp, "ip=%d  pan_top_o= %f %f %f\n", ip, pan_top_o[ip][0], pan_top_o[ip][1], pan_top_o[ip][2]);
fprintf(fpp, "ip=%d  pan_bot_o= %f %f %f\n", ip, pan_bot_o[ip][0], pan_bot_o[ip][1], pan_bot_o[ip][2]);
fprintf(fpp, "ip=%d  pan_lef_o= %f %f %f\n", ip, pan_lef_o[ip][0], pan_lef_o[ip][1], pan_lef_o[ip][2]);
fprintf(fpp, "ip=%d  pan_rit_o= %f %f %f\n", ip, pan_rit_o[ip][0], pan_rit_o[ip][1], pan_rit_o[ip][2]);
	  fprintf(fpp, "isoutside_n=%d  isoutside_f=%d  isoutside_t=%d\n",
		            isoutside_n,    isoutside_f,    isoutside_t        );
	  fprintf(fpp, "isoutside_b=%d  isoutside_l=%d  isoutside_r=%d\n",
		            isoutside_b,    isoutside_l,    isoutside_r        );
*/

/******************************************************************************
 *    SKIP this tile if it is outside viewing frustum                         *
 *    this is end of jsub (tile) loop if tile is outside                      *
 ******************************************************************************/
      if(   isoutside_n == 1 || isoutside_f == 1 || isoutside_t == 1
         || isoutside_b == 1 || isoutside_l == 1 || isoutside_r == 1 ) {

//		fpp = fopen("render_loop.out", "a+");
//		fprintf(fpp,"tile is outside viewing frustum -- skip it\n");
//		fclose(fpp);

      } else {

     /************************************************************
      * Read in subtile isub using DIRECT IO (if not already in) *
      ************************************************************/
//	  fpp = fopen("render_loop.out", "a+");
//	  fprintf(fpp, "isubcur = %d\n", isubcur);
//	  fclose(fpp);
      if(isubcur != isub) {
        ntiles++;

        sprintf(tile_full, "%s%s\0", tile_path, tile_file[isub]);
//		fpp = fopen("render_loop.out", "a+");
//        fprintf(fpp, "openning tile: %s\n", tile_full);
//		fclose(fpp);
        fdd = fopen(tile_full, "r");
        if(fdd == NULL) { 
			MessageBox(hWnd, "Can NOT open tile file", "LALA", MB_OK);
			fpp = fopen("hvr_mfc.err", "w");
			fprintf(fpp, "isub = %d    nsub = %d\n", isub, nsub);
			fprintf(fpp, "could not open tile: %s, exitting\n", tile_full);
			fclose(fpp);
			exit(0);
		}
        nbin = fread(bobsubZ, sizeof(char)*nbytes, 1, fdd);
        fclose(fdd);
        TposeYZ( bobsubZ, bobsubX, &nxsub, &nysub, &nzsub );
        TposeXZ( bobsubZ, bobsubY, &nxsub, &nysub, &nzsub );

        isubcur = isub;
        ireload = 1;
      }
/*****************************************************************************
 * BEGIN multiple pannel stuff                                               *
 *****************************************************************************/
      if(ip != ipcur) {

       /****************************************************
        *  set up frustum for pannel ip                    *
        ****************************************************/
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();

        dleft   = dnearclip * pan_dlef[ip];
        dright  = dnearclip * pan_drit[ip];
        dbottom = dnearclip * pan_dbot[ip];
        dtop    = dnearclip * pan_dtop[ip];
        glFrustum( dleft, dright, dbottom, dtop, dnearclip, dfarclip );
        gluLookAt(m_ShvrIn.fEye[0], m_ShvrIn.fEye[1], m_ShvrIn.fEye[2],
                  pan_lookat[ip][0], pan_lookat[ip][1], pan_lookat[ip][2],
                  pan_up[ip][0],     pan_up[ip][1],     pan_up[ip][2]);

       /*************************************************************
        *  swap out old pannel (if nec.) and swap in new pannel ip  *
        *************************************************************/
        glMatrixMode(GL_TEXTURE);
        glDisable(DHP_TEX);
        glDisable(GL_BLEND);
        if(ipcur > -1) {
			glReadPixels(0,0,m_ShvrUse.iWidth,m_ShvrUse.iHeight,
				GL_RGB,GL_UNSIGNED_BYTE,rgbpannel[ipcur]);
        }

        glDrawPixels(m_ShvrUse.iWidth, m_ShvrUse.iHeight,
			GL_RGB,GL_UNSIGNED_BYTE,rgbpannel[ip]);
        ipcur = ip;
        glEnable(GL_BLEND);
        glEnable(DHP_TEX);
	  }
/*****************************************************************************
 * END   multiple pannel stuff                                               *
 *****************************************************************************/

     /***********************************************************************
      *  SET scale and offset of texture memory for subvolume               *
      *  ASSUMES glLoadIdentity sets limits of                              *
      *          --> subtexture <--  to (0,1)x(0,1)x(0,1)                   *
      *          which get mapped to                                        *
      *          (subminpos[i], subminpos[i]+subvolsiz[i])x for(i=0,1,2)    *
      ***********************************************************************/

      while ( glGetError() != GL_NO_ERROR ) ;

/**************************************************************************
 *    ALL this stuff with ds (below) is TOXIC WASTE                       *
 **************************************************************************/
/**************************************************************************
 *    For 'soft' clipping planes, ramp opacity up to full over the
 *    range <dsoft>.
 *
 *    Scale dsfar so that at the far clipping plane, ds is approx.
 *    'nplanes' zones.  This increases at the near clipping plane
 *    in proportion to the apparent perspective size increase of a zone.
 **************************************************************************/
      dsmax = m_ShvrUse.fFarrClip + softdistance;
      dsfar = dsmax * tan( 0.5 * m_ShvrUse.fFovAngle * Pid180 ) 
       * (2. * cubesz[0] / ( (float)Nx * nplanes ) );
      dsnear = dsfar *
        ((m_ShvrUse.fNearClip-softdistance) / (m_ShvrUse.fFarrClip + softdistance));
      ds      =  dsfar;
      ss      =  m_ShvrUse.fFarrClip + softdistance;
      sfinish =  m_ShvrUse.fNearClip - softdistance;
      dsmin = 2. * cubesz[0] / (maxplanes * (float)Nx);
      if(sfinish < dsmin) { sfinish = dsmin; }
      fac = (ss-m_ShvrUse.fNearClip) / (m_ShvrUse.fFarrClip - m_ShvrUse.fNearClip + 2.0*softdistance);
      ds = fac*dsfar + (1.-fac)*dsnear;
      ds = ss / ((float)Nx * nplanes);
      if(ds < dsmin) { ds = dsmin; }
/**************************************************************************
 *    the only things that SHOULD survive from the ds TOXIC WASTE (above) *
 *    is dsmin and something about turning on soft clipping planes        * 
 **************************************************************************/
      ds = 2. / ( (float)Nx * nplanes );
      if(viewres > 0.) { ds = delxmin / nplanes; }

     /*********************************************************************
      *    THIS IS WHERE ALL ALPHA BLENDING IS DONE                       *
      *********************************************************************/
//		fpp = fopen("render_loop.out", "a+");
//		fprintf(fpp, "Before rendering\n");
//		fclose(fpp);

	 /************************************************************************
      * Calculate vector from eye to brick for correct rendering orientation *
      ************************************************************************/
	  xx = subminpos[0] + 0.5*subvolsiz[0] - eyepos[0];
      yy = subminpos[1] + 0.5*subvolsiz[1] - eyepos[1];
      zz = subminpos[2] + 0.5*subvolsiz[2] - eyepos[2];
	  if(xx > 0.) { axx = xx; } else { axx = -xx; }
	  if(yy > 0.) { ayy = yy; } else { ayy = -yy; }
	  if(zz > 0.) { azz = zz; } else { azz = -zz; }
	  idir = 2;                                     // view along z-direction (default)
	  if(ayy > axx  &&  ayy > azz) { idir = 1; }    // view along y-direction
	  if(axx > ayy  &&  axx > azz) { idir = 0; }    // view along x-direction

	  glBindTexture(DHP_TEX, texname[1]);
      xx0 = 0.;
      xx1 = 1.;
      yy0 = 0.;
      yy1 = 1.;
//	  dxv = subvolsiz[0]/nxsub;


	 /**************************************************************
	  * Rendering direction is along X-axis                        *
	  **************************************************************/
	  if(idir == 0) {
		if(iprint == 1) { printf("idir is 0\n"); }
		if(xx < 0.)	{ ids0 =       0; idsd =  1; }
		else		{ ids0 = nxsub-1; idsd = -1; }

	    islicesize = nzsub*nysub;
		dxv = subvolsiz[0]/nxsub;
        alpha = alpha0 * ((float)sqrt(axx*axx+ayy+ayy+azz*azz)/(axx)) * (dxv/(2.*cubesz[0]));
        glColor4f(1.0, 1.0, 1.0, alpha);
		for(islice = 0;  islice<nxsub;  islice++) {
		  isliceoff = islicesize*(ids0 + idsd*islice);
		  glTexImage2D(DHP_TEX, 0, GL_COLOR_INDEX8_EXT,
			nysb2,nzsb2,0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE,
			&bobsubX[isliceoff]);

		  xxv = subminpos[0] + dxv * (0.5 + (float)(ids0 + idsd*islice));
		  glBegin(GL_QUADS);
            glTexCoord2f(xx0, yy0);    glVertex3f(xxv, subminpos[1], subminpos[2]);
            glTexCoord2f(xx0, yy1);    glVertex3f(xxv, subminpos[1], submaxpos[2]);
            glTexCoord2f(xx1, yy1);    glVertex3f(xxv, submaxpos[1], submaxpos[2]);
			glTexCoord2f(xx1, yy0);    glVertex3f(xxv, submaxpos[1], subminpos[2]);
          glEnd();
		  nslices++;
		}
	  }

	 /**************************************************************
	  * Rendering direction is along Y-axis                        *
	  **************************************************************/
	  if(idir == 1) {
		if(iprint == 1) { printf("idir is 1\n"); }
		if(yy < 0.)	{ ids0 =       0; idsd =  1; }
		else		{ ids0 = nysub-1; idsd = -1; }

	    islicesize = nxsub*nzsub;
		dyv = subvolsiz[1]/nysub;
        alpha = alpha0 * ((float)sqrt(axx*axx+ayy+ayy+azz*azz)/(ayy)) * (dyv/(2.*cubesz[0]));
        glColor4f(1.0, 1.0, 1.0, alpha);
		for(islice = 0;  islice<nysub;  islice++) {
		  isliceoff = islicesize*(ids0 + idsd*islice);
		  glTexImage2D(DHP_TEX, 0, GL_COLOR_INDEX8_EXT,
			nxsb2,nzsb2,0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE,
			&bobsubY[isliceoff]);

		  yyv = subminpos[1] + dyv * (0.5 + (float)(ids0 + idsd*islice));
		  glBegin(GL_QUADS);
            glTexCoord2f(xx0, yy0);    glVertex3f(subminpos[0], yyv, subminpos[2]);
            glTexCoord2f(xx0, yy1);    glVertex3f(subminpos[0], yyv, submaxpos[2]);
            glTexCoord2f(xx1, yy1);    glVertex3f(submaxpos[0], yyv, submaxpos[2]);
			glTexCoord2f(xx1, yy0);    glVertex3f(submaxpos[0], yyv, subminpos[2]);
          glEnd();
		  nslices++;
		}
	  }

	 /**************************************************************
	  * Rendering direction is along Z-axis                        *
	  **************************************************************/
	  if(idir == 2) {
		if(iprint == 1) { printf("idir is 2\n"); }
		if(zz < 0.)	{ ids0 =       0; idsd =  1; }
		else		{ ids0 = nzsub-1; idsd = -1; }

	    islicesize = nxsub*nysub;
		dz = subvolsiz[2]/(float)nzsub;
        alpha = alpha0 * ((float)sqrt(axx*axx+ayy+ayy+azz*azz)/(azz)) * (dz/(2.*cubesz[0]));
        glColor4f(1.0, 1.0, 1.0, alpha);
		for(islice = 0;  islice<nzsub;  islice++) {
		  isliceoff = islicesize*(ids0 + idsd*islice);
		  glTexImage2D(DHP_TEX, 0, GL_COLOR_INDEX8_EXT,
			nxsb2,nysb2,0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE,
			&bobsubZ[isliceoff]);

		  zzv = subminpos[2] + dz * (0.5 + (float)(ids0 + idsd*islice));
		  glBegin(GL_QUADS);
            glTexCoord2f(xx0, yy0);    glVertex3f(subminpos[0], subminpos[1], zzv);
            glTexCoord2f(xx0, yy1);    glVertex3f(subminpos[0], submaxpos[1], zzv);
            glTexCoord2f(xx1, yy1);    glVertex3f(submaxpos[0], submaxpos[1], zzv);
			glTexCoord2f(xx1, yy0);    glVertex3f(submaxpos[0], subminpos[1], zzv);
          glEnd();
		  nslices++;
		}
	  }

/*
      dz = subvolsiz[2]/nzsub;
      for(islice=0; islice<nzsub; islice++) {
		isliceoff = islicesize*islice;
		glTexImage2D(DHP_TEX, 0, GL_COLOR_INDEX8_EXT,
			nxsb2,nysb2,0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE,
			&bobsubZ[isliceoff]);

		zz = subminpos[2] + dz * (0.5 + (float)islice);
		glBegin(GL_QUADS);
            glTexCoord2f(xx0, yy0); glVertex3f(subminpos[0], subminpos[1], zz);
            glTexCoord2f(xx0, yy1); glVertex3f(subminpos[0], submaxpos[1], zz);
            glTexCoord2f(xx1, yy1); glVertex3f(submaxpos[0], submaxpos[1], zz);
            glTexCoord2f(xx1, yy0); glVertex3f(submaxpos[0], subminpos[1], zz);
        glEnd();
        nslices++;
      }
*/



	  glFlush();
//		fpp = fopen("render_loop.out", "a+");
//		fprintf(fpp, "After rendering\n");
//		fclose(fpp);

      }           /* end of isoutside = 0 case: tile is inside frustum */

    }             /* end of ip loop (loop over pannels)                 */
    }             /* end of jsub loop                                   */
	SwapBuffers(hDC);
	m_iRender = 0;        // will stop rendering upon return

	return;
}

void crossprod(float vec1[3], float vec2[3], float vec3[3]) {
    vec3[0] = vec1[1] * vec2[2]  -  vec1[2] * vec2[1];
    vec3[1] = vec1[2] * vec2[0]  -  vec1[0] * vec2[2];
    vec3[2] = vec1[0] * vec2[1]  -  vec1[1] * vec2[0];
}

/***************************************************************************
 *  The integer function strdif(str1, str2) takes two string arguments.    *
 *  If the strings are identical (ending in '\0') strdif returns 0.        *
 *  If there are any differences, strdif returns 1.                        *
 ***************************************************************************/
int strdif(char* str1, char* str2)
{
    int i, idiff;
    i = 0;
    while(str1[i] == str2[i] && str1[i] != '\0') { i++; }
    idiff = 1;
    if(str1[i] == str2[i]) { idiff = 0; }
    return(idiff);
}
void setstr(char* str1, char* str2)
{
    int i;
    i = 0;
    while(str2[i] != '\0') { str1[i] = str2[i]; i++; }
    str1[i] = '\0';
}


void Chvr_work::init()
{
  int i;

    glClearColor(0.0, 0.0, 0.0, 1.0);

    glEnable(GL_TEXTURE_2D);
    glEnable(GL_COLOR_INDEX8_EXT);
    glEnable(GL_BLEND);

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_DITHER);
    glDisable(GL_FOG);
    glDisable(GL_LIGHTING);
    glDisable(GL_STENCIL_TEST);
    glDisable(GL_TEXTURE_1D);
    glDisable(GL_LOGIC_OP);

    /*    glBlendFunc(GL_SRC_ALPHA, GL_ONE); */
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

    /* Similar to defining a 2D texture, but note the setting of the */
    /* wrap parameter for the R coordinate.  Also, for 3D textures   */
    /* you probably won't need mipmaps, hence the linear min filter. */

    /* glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST ); */
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glColorTableEXT = (PFNGLCOLORTABLEPROC) wglGetProcAddress("glColorTableEXT");

    glGenTextures(256, texname);
    for(i=0; i<256; i++) {
        glBindTexture(DHP_TEX, texname[i]);
        glTexParameteri(DHP_TEX, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
        glTexParameteri(DHP_TEX, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
        glTexParameteri(DHP_TEX, GL_TEXTURE_WRAP_S, GL_REPEAT);
        glTexParameteri(DHP_TEX, GL_TEXTURE_WRAP_T, GL_REPEAT);
    }
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glFlush();
	SwapBuffers(hDC);
}

//DEL int Chvr_work::GetWidth()
//DEL {
//DEL 	return width;
//DEL }

//DEL int Chvr_work::GetHeight()
//DEL {
//DEL 	return height;
//DEL }

void Chvr_work::SetClearColor(float f_red, float f_grn, float f_blu)
{
	m_flClearRGB[0] = f_red;
	m_flClearRGB[1] = f_grn;
	m_flClearRGB[2] = f_blu;
}

bool Chvr_work::DoRender()
{
	bool bRet;
	bRet = FALSE;
	if(m_iRender == 1) bRet = TRUE;
	return bRet;

}

void Chvr_work::SetDoRender()
{
	m_iRender = 1;
	draw_scene();
	m_iStopRendering = 0;
}



























#if 0

/*****************************************************************************
 * hvr - Hierarchical Volume Rendering via 3D sub textures for large volumes 
 * compile: cc -o hvr main.c hvr.c seaio.c utils.c -lGLU -lGL -lX11 -lm
 *
 * Changes:
 * 14-sep-00 hvrs rev 0: render in 2d-texture slices
 * 21-sep-99 hvr rev  3: bug fix: multiple, non-planar pannels now seamless
 * 09-jul-99 hvr rev  3: multiple, non-planar pannel functional
 * 01-jul-99 hvr rev  2: multiple, non-planar pannel implementation-started
 * 08-jun-99 hvr rev  1: true hierarchy implemented
 * 07-jun-99 hvr rev  0: nrep implemented
 * 29-apr-99 tvr rev  0: multiple pannels implemented for efficient reuse of
 *                       sub-tiles for PowerWall rendering (see ipcur ...)
 * 17-jan-99 tvr rev -1: fixed bugs in edges of tiles and hdistfac,vdistfac
 * 16-jan-99 tvr rev -1: skip subtiles outside of viewing frustum
 * 15-jan-99 tvr rev -1: Implement general subtiling on a 1 level hierarchy
 * 17-dec-98 Sub-quad rendering for 2k-cubes (workaround for rollover at 1k)
 * 01-apr-98 Huge changes by dhp w/clip plane restrictions and
 *             calculation of plane spacing and alpha calculations
 * 13-mar-98 Tiny fix to multiple panel aspect ratio (panel vs. whole)
 * 15-nov-97 Improvements in concatenated movie and shmem movies
 * 20-oct-97 Generalized quadrant rendering
 * 15-sep-97 Added quadrant rendering
 * 23-sep-97 Removed multiple of slabsize restriction for z-dim (?)
 *
 * Dave Porter
 * Sarah Anderson
 * LCS&E
 *****************************************************************************/

#include <GL/glx.h>
#include <GL/glu.h>
#include <X11/keysym.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/file.h>
#include <math.h>
#include <assert.h>

/*
 in clude <aio.h>
 in clude <sys/sem.h>
 in clude <ulocks.h>
 in clude <task.h>
 in clude <sys/time.h>
*/

#include "renderparams.h"

#include "seaio.h"

#define MAX(a,b) ((a)>(b)?(a):(b))

/* Offscreen rendering */
#undef INVISIBLE

#define NPMAX 100       /* Maximum number of pannels */

/*================================================================
 Globals
 */
static int Nx, Ny, Nz;    /* These globals contain the brick overall size */

static unsigned char *bobsub;					// XXXXXXXXXXXXXXXXXXXXif0
static unsigned char *myslice;
static GLuint texname[256];
static int ido3dtex=1;

static char *rgbpannel[NPMAX];   /* RGB pannels */
static int pannels_initted=0;    /* valloc rgppannels only once */
static int ipcur;                /* current pannel loaded into rgbpannel */
static int isubcur = -1;         /* current sub-brick loaded into bobsub */
static int ireload =  0;         /* flag to reload brick in 3dtex code   */
static int npannel=0;            /* number of pannels (in PW_CONFIGURATION) */

static GLfloat Aspect;	/* Output image aspect ratio, h:v */
/*
static float Pid180 = (3.141592654/180.);
*/

/* ================================================================
   Round to next power of two.
 */

static int 
roundup( int n ) {
  int i, k;
  i = 2;  k = 1;
  while ( i < n ) { i<<=1; ++k; }
  return (1<<k);
}

/****************************************************************************
 *                  initialize static clipping planes.                      *
 ****************************************************************************/
void initclip( float cubesz[3], struct Renderparams *rp )
{
    int i,j;
    float d,dyx;

    static GLdouble eqnxm[4] = { 1.,  0.,  0.0, 1.0 };  /* clip x< -1.0 */
    static GLdouble eqnxp[4] = {-1.,  0.,  0.0, 1.0 };  /* clip x>  1.0 */
    static GLdouble eqnym[4] = { 0.,  1.0,  0., 1.0 };  /* clip y< -1.0 */

    static GLdouble eqnyp[4] = { 0., -1.0,  0., 1.0 };  /* clip y>  1.0 */
    static GLdouble eqnzm[4] = { 0.,  0.,  1.0, 1.0 };  /* clip z< -1.0 */
    static GLdouble eqnzp[4] = { 0.,  0., -1.0, 1.0 };  /* clip z>  1.0 */

  /* Set xy clip to remove 1/2 outer zone so that linear interpolation
     looks nicer in the case that subtexture loads sit inside undefined
     area of the whole texure memory */

    d = 0.75 / (float)rp->nx;
    eqnxm[3] = (1.0 - d);
    eqnxp[3] = (1.0 - d);
    dyx = (float)rp->ny / (float)rp->nx;
    d = 1.0 / (float)rp->ny;
    eqnym[3] = dyx - d;
    eqnyp[3] = dyx - d;

    eqnxm[3] /= cubesz[0];
    eqnxp[3] /= cubesz[0];
    eqnym[3] /= cubesz[1];
    eqnyp[3] /= cubesz[1];

    glClipPlane( GL_CLIP_PLANE0, eqnym );
    glEnable(GL_CLIP_PLANE0);

    glClipPlane( GL_CLIP_PLANE1, eqnyp );
    glEnable(GL_CLIP_PLANE1);

    glClipPlane( GL_CLIP_PLANE2, eqnxm );
    glEnable(GL_CLIP_PLANE2);

    glClipPlane( GL_CLIP_PLANE3, eqnxp );
    glEnable(GL_CLIP_PLANE3);

    glClipPlane( GL_CLIP_PLANE4, eqnzm );
    glEnable(GL_CLIP_PLANE4);

    glClipPlane( GL_CLIP_PLANE5, eqnzp );
    glEnable(GL_CLIP_PLANE5);
}

static void
init( struct Renderparams *rp ) {

  GLenum ierr;
  int i, j, nxsub, nysub, nzsub;
  GLsizei texx, texy, texz;
  GLfloat aspect, nerclip, farclip;

    glClearColor(0.0, 0.0, 0.0, 1.0);

    if(ido3dtex == 1) { glEnable(GL_TEXTURE_3D_EXT); }  // XXXXXXXXif0
    else              { glEnable(GL_TEXTURE_2D);     }
    glEnable(GL_TEXTURE_COLOR_TABLE_SGI);
    glEnable(GL_BLEND);

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_DITHER);
    glDisable(GL_FOG);
    glDisable(GL_LIGHTING);
    glDisable(GL_STENCIL_TEST);
    glDisable(GL_TEXTURE_1D);
    glDisable(GL_LOGIC_OP);

    /*    glBlendFunc(GL_SRC_ALPHA, GL_ONE); */
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

    /* Similar to defining a 2D texture, but note the setting of the */
    /* wrap parameter for the R coordinate.  Also, for 3D textures   */
    /* you probably won't need mipmaps, hence the linear min filter. */

    /* glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST ); */
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

   
    if(ido3dtex == 1) {

/* linear interpolation */
    glTexParameteri(GL_TEXTURE_3D_EXT, GL_TEXTURE_MIN_FILTER, GL_LINEAR);   // XXXXXXXif0
    glTexParameteri(GL_TEXTURE_3D_EXT, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

/* piecewize constant (NEEDED TO AVOID RENDERING ARTIFACTS AT EDGES OF TILES)
    glTexParameteri(GL_TEXTURE_3D_EXT, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_3D_EXT, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
 */

   glTexParameteri(GL_TEXTURE_3D_EXT, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE_SGIS);
   glTexParameteri(GL_TEXTURE_3D_EXT, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE_SGIS);
   glTexParameteri(GL_TEXTURE_3D_EXT, GL_TEXTURE_WRAP_R_EXT, GL_CLAMP_TO_EDGE_SGIS);

    ierr = glGetError();
    if ( ierr == GL_TEXTURE_TOO_LARGE_EXT ) 
      { perror("Texture too large"); exit(1); }

    } else {                        /* or if ido3dtex != 1 */
printf("============================================================\n");      // XXXXXXXXXXXXXif0
printf("============================================================\n");
printf("============================================================\n");
printf("============================================================\n");
printf("========      generating a set of 2D textures        =======\n");
printf("============================================================\n");
printf("============================================================\n");
printf("============================================================\n");
printf("============================================================\n");
      glGenTextures(256, texname);
      for(i=0; i<256; i++) {
        glBindTexture(GL_TEXTURE_2D, texname[i]);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
      }
    }

    bobsub = valloc(256*256*256);
    for(i=0; i<256*256*256; i++) { bobsub[i] = 0; }
    myslice = valloc(256*256);

}

static void
draw_scene( struct Renderparams *rp ) {
    float eye[3], up[3], torq[3];
    float t1[3],t2[3];
    GLenum ierr;
    int i, j, k, nzslab, ix, iy, iz, ic, size, edge, nslices, ntiles;
    int isz, isy, isx, hx, lx, hy, ly, hz, lz, lastz;
    int isub, jsub, ixoff, iyoff, izoff, inoff, outoff;
    int nxsub, nysub, nzsub, nr, iprint;
    int nxsb2, nysb2, nzsb2;
    int isoutside_n, isoutside_f, isoutside_t;
    int isoutside_b, isoutside_l, isoutside_r;

    float scalex, scaley, scalez, facXtoN;
    float subvolsiz[3], subminpos[3], fulminpos[3], submaxpos[3];
    float subfrcx, suboffx, subfrcy, suboffy;
    float alpha, alpha0, dsoftNear, dsoftFar, fac, dsfar, dsnear;
    float sx, sy, zx, zy, xx, yy, zz, dz;
    float cdirX, cdirY, cdirZ, z0, z1, z2, delzslab;
    float zmax, dsmax, dsmin;
    float cubex, cubey, cubez, edgedist, edgemin, edgemax;
    float zminvis, zmaxvis;
    float ss,ds,sfinish,hdistfac,vdistfac,hdist[4],vdist[4];
    float mvert[4][3],tvert[4][3];
    float eyepos[3],cubesz[3];
    float frgba[256][4];		   /* color table */
    static char old_cmap[1024] = "none", old_amap[1024] = "none";       // ***************************if0
    static char old_hvname[1024] = "none";

    GLdouble eyeposX,eyeposY,eyeposZ, centerX,centerY,centerZ, upX,upY,upZ;
    static GLdouble eqnxm[4] = { 1.,  0.,  0.0, 1.0 };  /* clip x< -1.0 */
    static GLdouble eqnxp[4] = {-1.,  0.,  0.0, 1.0 };  /* clip x>  1.0 */
    static GLdouble eqnym[4] = { 0.,  1.0,  0., 1.0 };  /* clip y< -1.0 */
    static GLdouble eqnyp[4] = { 0., -1.0,  0., 1.0 };  /* clip y>  1.0 */
    static GLdouble eqnzm[4] = { 0.,  0.,  1.0, 1.0 };  /* clip z< -1.0 */
    static GLdouble eqnzp[4] = { 0.,  0., -1.0, 1.0 };  /* clip z>  1.0 */
    GLfloat aspect, nerclip, farclip, dx,dy;
    GLdouble dleft,dright,dbottom,dtop, dnearclip,dfarclip;
    GLdouble dxsect, dysect;

/* debug stuff */
    int idebug;
/* debug stuff */

/* frustum stuff */
    float lefpar[3],ritpar[3],toppar[3],botpar[3];
    float lef_o[3], rit_o[3], top_o[3], bot_o[3];
    float ss1, ss2, x1[3], x2[3];
    void crossprod(float vec1[3], float vec2[3], float vec3[3]);
/* frustum stuff */


/* subtile stuff */
    float fminx,fminy,fminz,distmax, tile_dist[2048], epsil, dxe, sizescale;
    int ippp, iccc, nccc, nlist, list_tiles[2048], tile_did[2048];
    int tolerance, inode, ilist, nlistnew, need_check, list_new[2048];
    float angtol, viewres, delxmin;
    float distmin, delxtol, delxsize;
/* subtile stuff */

/* subtile io stuff */
      static char *seps = " ,;\t\n";
      static int nsub, node0;
      static off64_t tile_off64t[2048];
      static int tile_nrep[2048];
      static int tile_nxsub[2048], tile_nysub[2048], tile_nzsub[2048];
      static int tile_ixoff[2048], tile_iyoff[2048], tile_izoff[2048];
      static int tile_parent[2048];
      static int tile_maxerr[2048];
      int ncPath;
      FILE *fpp;
      char tile_file[2048][64], tile_path[64], tile_full[100];
      char line[256];
      int tile_children[2048][32];
 /* subtile io stuff */

/* Dio stuff */
    int fdd, nbytes, idio, nbin;
    off64_t n64, offset64t;
    struct dioattr Dio;
/* Dio stuff */

/* multiple pannel stuff */
/*
    static float pnormal[NPMAX][3],pup[NPMAX][3],pcenter[NPMAX][3];
    static float ph1[NPMAX], ph2[NPMAX], pv1[NPMAX], pv2[NPMAX];
    float paneye[NPMAX][3], panup[NPMAX][3], pantorq[NPMAX][3];
*/
    static float pw_normal[NPMAX][3],pw_up[NPMAX][3],pw_center[NPMAX][3];
    static float half_width[NPMAX],half_height[NPMAX];
    char *rgb1;
    int ip, isectx0, isecty0;
    float d, dhorz, dvert, pcn, pan_cenmagi[NPMAX];
    float pan_eye[NPMAX][3],pan_up[NPMAX][3],pan_center[NPMAX][3];
    float pan_lookat[NPMAX][3],pan_torq[NPMAX][3],pan_dlef[NPMAX];
    float pan_drit[NPMAX],pan_dbot[NPMAX],pan_dtop[NPMAX];
    float pan_lefpar[NPMAX][3],pan_ritpar[NPMAX][3],pan_toppar[NPMAX][3];
    float pan_botpar[NPMAX][3],pan_lef_o[NPMAX][3],pan_rit_o[NPMAX][3];
    float pan_top_o[NPMAX][3], pan_bot_o[NPMAX][3];
/* multiple pannel stuff */

/* slice stuff */
    int islicesize, islice, isliceoff, ij;
    float xx0, xx1, yy0, yy1;
/* slice stuff */

/* prototyping functions */
    int match( char *token, char *word, int tokenlength );
    float dotproduct( const float*, const float* );
    int   strdif(char*, char*);
    void  setstr(char*, char*);
    void readCmap( char *clrname, char *alpname, float ftable[256][4] );
/* prototyping functions */

    iprint = 1;

   /* per panel apsect ratio */
    Aspect = ((GLfloat)rp->width) / ((GLfloat)rp->height);

/*****************************************************************************
 *                        READ IN PANNEL INFO HERE                           *
 *---------------------------------------------------------------------------*
 * read in of configuration file goes here : configuration file gives rules  *
 * for generating [center? and (horiz, vert) offsets]                        *
 * for each pannel for each pannel given center?, eye?, up? from above       *
 *---------------------------------------------------------------------------*
 *              torq    eye     up                                           *
 *            i    0      1      2                                           *
 *  pw_normal[i]   0.     1.     0.    <-- typical example of central pannel *
 *      pw_up[i]   0.     0.     1.    <-- typical example of central pannel *
 *                                                                           *
 *---------------------------------------------------------------------------*
 * Example PW_CONFIGURATION for single pannel (1280x1024 per pannel)         *
 *       0. 1. 0.  0. 0. 1.  0. 1. 0.  0.625 0.5                             *
 *---------------------------------------------------------------------------*
 * Example PW_CONFIGURATION for flat 4 pannel (1600x1200 per pannel)         *
 *       0. 1. 0.  0. 0. 1.  -0.6667 1.0 -0.5  0.6667 0.5                    *
 *       0. 1. 0.  0. 0. 1.   0.6667 1.0 -0.5  0.6667 0.5                    *
 *       0. 1. 0.  0. 0. 1.  -0.6667 1.0  0.5  0.6667 0.5                    *
 *       0. 1. 0.  0. 0. 1.   0.6667 1.0  0.5  0.6667 0.5                    *
 *****************************************************************************/
    if(npannel == 0) {
      ip = 0;
      fpp = fopen("PW_CONFIGURATION", "r");               // XXXXXXXXXXXXXXXXXif0
      if(fpp > 0) {
        while ( fgets(line,256,fpp) != NULL ) {
          pw_normal[ip][0] = atof( strtok(line,seps) );
          pw_normal[ip][1] = atof( strtok(NULL,seps) );
          pw_normal[ip][2] = atof( strtok(NULL,seps) );
          pw_up[ip][0]     = atof( strtok(NULL,seps) );
          pw_up[ip][1]     = atof( strtok(NULL,seps) );
          pw_up[ip][2]     = atof( strtok(NULL,seps) );
          pw_center[ip][0] = atof( strtok(NULL,seps) );
          pw_center[ip][1] = atof( strtok(NULL,seps) );
          pw_center[ip][2] = atof( strtok(NULL,seps) );
          half_width[ip]   = atof( strtok(NULL,seps) ); /* fovangle & Aspect */
          half_height[ip]  = atof( strtok(NULL,seps) ); /* are ignored       */
          ip++;
        }
        fclose(fpp);
        npannel = ip;
      } else {
          pw_normal[0][0] = 0.;    /* default single pannel settings */
          pw_normal[0][1] = 1.;
          pw_normal[0][2] = 0.;
          pw_up[0][0]     = 0.;
          pw_up[0][1]     = 0.;
          pw_up[0][2]     = 1.;
          pw_center[0][0] = 0.;
          pw_center[0][1] = 1.;
          pw_center[0][2] = 0.;
          half_width[0]   = tan( Pid180* rp->fovangle * Aspect * 0.5 );
          half_height[0]  = tan( Pid180* rp->fovangle          * 0.5 );
          npannel = 1;
       }
    }
    if(iprint > 1) {
      printf("npannel = %d\n", npannel);
	        for(ip=0; ip<npannel; ip++) {
        printf("pw_normal= %f %f %f\n",
                pw_normal[ip][0],pw_normal[ip][1],pw_normal[ip][2]);
        printf("pw_up= %f %f %f\n",
                pw_up[ip][0],pw_up[ip][1],pw_up[ip][2]);
        printf("pw_center= %f %f %f\n",
                pw_center[ip][0],pw_center[ip][1],pw_center[ip][2]);
      }
    }

    if(strdif(old_hvname, rp->hvname) == 1) {                 // **************************if0
      setstr(old_hvname, rp->hvname);
      fpp = fopen(rp->hvname, "r");
      nsub = 0;
      node0 = -1;
      while (node0 < 0) {
        i = match(fgets(line,200,fpp), "end", 3);
        strncpy(tile_file[nsub], strtok( line,seps ), 64);
        tile_off64t[nsub] = (off64_t)atoi( strtok(NULL,seps) );
        tile_nrep[nsub]   = atoi( strtok(NULL,seps) );
        tile_nxsub[nsub]  = atoi( strtok(NULL,seps) );
        tile_nysub[nsub]  = atoi( strtok(NULL,seps) );
        tile_nzsub[nsub]  = atoi( strtok(NULL,seps) );
        tile_ixoff[nsub]  = atoi( strtok(NULL,seps) );
        tile_iyoff[nsub]  = atoi( strtok(NULL,seps) );
        tile_izoff[nsub]  = atoi( strtok(NULL,seps) );
        tile_parent[nsub] = atoi( strtok(NULL,seps) );
        tile_maxerr[nsub] = atoi( strtok(NULL,seps) );
        if(tile_parent[nsub] < 0) { node0 = nsub; }
/*
        printf("nsub = %d   maxerr=%d  file = %s\n",
                nsub,  tile_maxerr[nsub], tile_file[nsub]);
*/
        nsub++;
      }
      fclose(fpp);
    }

    ncPath = 0;
    for(i=0; i<100; i++) { if(rp->hvname[i] == '/') { ncPath = i+1; }}
    for(i=0; i<ncPath; i++) { tile_path[i] = rp->hvname[i]; }
    tile_path[ncPath] = '\0';

    nbytes = rp->height * rp->width * 3;

    if(pannels_initted == 0) {
      for(ip=0; ip<npannel; ip++) { rgbpannel[ip]  = (char*)valloc(nbytes); }
      pannels_initted = 1;
    }

    for(ip=0; ip<npannel; ip++) {
      for(k=0; k<nbytes; k++) { rgbpannel[ip][k] = 0; }
    }
    ipcur = -1;

    rgb1 = (char*)valloc(nbytes);
    for(i=0; i < rp->height * rp->width; i++) {
      rgb1[3*i  ] = 0;
      rgb1[3*i+1] = 255;
      rgb1[3*i+2] = 0;
    }

    nerclip = rp->near - rp->softdistance;
    farclip = rp->far + rp->softdistance;

    dnearclip = nerclip;
    dfarclip = farclip;
    dx = tan( Pid180* rp->fovangle * Aspect * 0.5 ) * dnearclip;
    dy = tan( Pid180* rp->fovangle          * 0.5 ) * dnearclip;

    /* Check for rendering only a section of the final image */

    dxsect = 2.0 * dx;
    dysect = 2.0 * dy;

    eyeposX = rp->eyeX;         /* eyeposXYZ = position of eye */
    eyeposY = rp->eyeY;
    eyeposZ = rp->eyeZ;
    upX = rp->upX;              /* upXYZ = direction of up */
    upY = rp->upY;
    upZ = rp->upZ;
    centerX = rp->centerX;	/* centerXYZ = position eye looks at */
    centerY = rp->centerY;
    centerZ = rp->centerZ;

   /************************************************************************
    * Right handed ONB  which power-wall frame is attached to :            *
    * (eye[], up[], torq[])                                                *
    ************************************************************************/
    eye[0] = centerX - eyeposX;             /* direction eye looks in */
    eye[1] = centerY - eyeposY;
    eye[2] = centerZ - eyeposZ;
    vnormalize(eye);

    up[0] = upX;    eyepos[0] = eyeposX;
    up[1] = upY;    eyepos[1] = eyeposY;
    up[2] = upZ;    eyepos[2] = eyeposZ;

    /* Insist that up is normal to eye */
    d = dotproduct(eye,up);
    for (i=0; i<3; ++i) { up[i] = up[i]- eye[i]*d; }
    vnormalize( up );

    /* Construct the cross vector 'torque' */
    torq[0] = eye[1]*up[2] - eye[2]*up[1];
    torq[1] = eye[2]*up[0] - eye[0]*up[2];
    torq[2] = eye[0]*up[1] - eye[1]*up[0];

    if(iprint > 1) {
      printf("eye = %f %f %f\n", eye[0],eye[1],eye[2]);
      printf("up = %f %f %f\n", up[0],up[1],up[2]);
      printf("torq = %f %f %f\n", torq[0],torq[1],torq[2]);
    }

    for(ip=0; ip<npannel; ip++) {
      for(i=0; i<3; i++) {
        pan_eye[ip][i]    = pw_normal[ip][0] * torq[i] + 
                            pw_normal[ip][1] *  eye[i] +
                            pw_normal[ip][2] *   up[i];

        pan_up[ip][i]     = pw_up[ip][0] * torq[i] + 
                            pw_up[ip][1] *  eye[i] +
                            pw_up[ip][2] *   up[i];

        pan_center[ip][i] = pw_center[ip][0] * torq[i] + 
                            pw_center[ip][1] *  eye[i] +
                            pw_center[ip][2] *   up[i];

        pan_lookat[ip][i] = eyepos[i] + pan_eye[ip][i];
      }

      vnormalize(pan_eye[ip]);
      vnormalize(pan_up[ip]);
      crossprod(pan_eye[ip], pan_up[ip], pan_torq[ip]);
      vnormalize(pan_torq[ip]);


     /***************************************************************
      * pan_center is position of the center (relative to the eye) of the pannel
      *   to be used in generating horizontal and vertical offset of
      *   pannel window
      * pan_lookat is a point in the direction normal to the pannel
      *   to be used in glLookAt
      * NOTE: the pannel must be centered on the normal to the eyeposition
      *       for pan_center & pan_lookat to be the same
      * NOTE: pan_center is NOT normalized
      *       ss * pan_dlef ... are shifts on a plane at a distance ss
      *       pan_cenmagi[ip] is the correction factor.
      ***************************************************************/
      pan_cenmagi[ip] = 1. / dotproduct(pan_eye[ip], pan_center[ip]);
      dhorz = dotproduct(pan_center[ip], pan_torq[ip]);
      dvert = dotproduct(pan_center[ip], pan_up[ip]);

      pcn = 1. / pan_cenmagi[ip];

      pan_dlef[ip] = (dhorz - half_width[ip] ) * pan_cenmagi[ip];
      pan_drit[ip] = (dhorz + half_width[ip] ) * pan_cenmagi[ip];
      pan_dbot[ip] = (dvert - half_height[ip]) * pan_cenmagi[ip];
      pan_dtop[ip] = (dvert + half_height[ip]) * pan_cenmagi[ip];

      if(iprint > 1) {
        printf("ip = %d\n", ip);
        printf("pan_eyeXYZ = %f %f %f\n",
                pan_eye[ip][0],pan_eye[ip][1],pan_eye[ip][2]);
        printf("pan_upXYZ = %f %f %f\n",
                pan_up[ip][0],pan_up[ip][1],pan_up[ip][2]);
        printf("pan_centerXYZ = %f %f %f\n",
                pan_center[ip][0],pan_center[ip][1],pan_center[ip][2]);
        printf("pan_lookatXYZ = %f %f %f\n",
                pan_lookat[ip][0],pan_lookat[ip][1],pan_lookat[ip][2]);
        printf("pan_torqXYZ = %f %f %f\n",
                pan_torq[ip][0],pan_torq[ip][1],pan_torq[ip][2]);
        printf("half_width=%f  half_height=%f\n",
                half_width[ip],half_height[ip]);
        printf("pan_dlef=%f  pan_drit=%f\n", pan_dlef[ip],pan_drit[ip]);
        printf("pan_dbot=%f  pan_dtop=%f\n", pan_dbot[ip],pan_dtop[ip]);
        printf("dhorz = %f    dvert = %f\n", dhorz, dvert);
      }

    }

    /* modelview aspect for the entire mesh is based on X size. */
    cubesz[0]= 1.0;
    cubesz[1]= (float)Ny/Nx;
    cubesz[2]= (float)Nz/Nx;

    if(ido3dtex == 1) { initclip( cubesz, rp ); }

   /************************************************************************
    *  Get horizontal, vertical, and alpha scalings                        *
    ************************************************************************/
    hdistfac = ftan(0.5*Pid180 * rp->fovangle*Aspect);
    vdistfac = ftan(0.5*Pid180 * rp->fovangle);
    alpha0 = rp->opacity * 128.0;

    for(ip=0; ip<npannel; ip++) {
     /************************************************************************
      * Generate outward orthogonal surface vectors for 4 planes of the      *
      * viewing frustum.  They do not need to be normalized.                 *
      * These are used below to determine if a tile is OUTSIDE the frustum   *
      * Power wall change:  In principle, need to do these 4 planes for each *
      * pannel of a power wall.  In practice, it is actually easiest to, in  *
      * fact, do each of the pannels individuallys.  The condition on which  *
      * a tile is read in is simply that any part of the tile is in any one  *
      * of the pannels viewing frustum.                                      * 
      ************************************************************************/
      for(i=0; i<3; i++) {
        pan_lefpar[ip][i] = pan_eye[ip][i] + pan_dlef[ip]*pan_torq[ip][i];
        pan_ritpar[ip][i] = pan_eye[ip][i] + pan_drit[ip]*pan_torq[ip][i];
        pan_toppar[ip][i] = pan_eye[ip][i] + pan_dtop[ip]*pan_up[ip][i];
        pan_botpar[ip][i] = pan_eye[ip][i] + pan_dbot[ip]*pan_up[ip][i];
      }

      if(iprint == -1) {
        printf(" \n");
        printf("ip=%2d   pan_lefpar: %f %f %f\n",
         ip, pan_lefpar[ip][0], pan_lefpar[ip][1], pan_lefpar[ip][2]);
        printf("ip=%2d   pan_ritpar: %f %f %f\n",
         ip, pan_ritpar[ip][0], pan_ritpar[ip][1], pan_ritpar[ip][2]);
        printf("ip=%2d   pan_toppar: %f %f %f\n",
         ip, pan_toppar[ip][0], pan_toppar[ip][1], pan_toppar[ip][2]);
        printf("ip=%2d   pan_botpar: %f %f %f\n",
         ip, pan_botpar[ip][0], pan_botpar[ip][1], pan_botpar[ip][2]);
        printf("ip=%2d   pan_eye   : %f %f %f\n",
         ip, pan_eye[ip][0], pan_eye[ip][1], pan_eye[ip][2]);
        printf("ip=%2d   pan_center: %f %f %f\n",
         ip, pan_center[ip][0], pan_center[ip][1], pan_center[ip][2]);
        printf("ip=%2d   pan_up    : %f %f %f\n",
         ip, pan_up[ip][0], pan_up[ip][1], pan_up[ip][2]);
        printf("ip=%2d   pan_torq  : %f %f %f\n",
         ip, pan_torq[ip][0], pan_torq[ip][1], pan_torq[ip][2]);
        printf("pan_dtop = %f   pan_dbot = %f   pan_cenmagi[ip] = %f\n",
         pan_dtop[ip], pan_dbot[ip], pan_cenmagi[ip]);
      }

                                            /* outward orthogonal vector at */
      crossprod(pan_up[ip],     pan_lefpar[ip], pan_lef_o[ip]); /*     left */
      crossprod(pan_ritpar[ip], pan_up[ip],     pan_rit_o[ip]); /*    right */ 
      crossprod(pan_torq[ip],   pan_toppar[ip], pan_top_o[ip]); /*      top */
      crossprod(pan_botpar[ip], pan_torq[ip],   pan_bot_o[ip]); /*   bottom */

    }

    if(iprint == -1) { exit(0); }

/***************************************************************************
 * INPUT: color map information                                            *
 ***************************************************************************/
    if(strdif(rp->cmapname, old_cmap) == 1) {
      printf("DOING NEW COLOR MAP   DOING NEW COLOR MAP   DOING NEW COLOR MAP");
      setstr(old_cmap, rp->cmapname);
      readCmap( rp->cmapname, rp->amapname, frgba );
      glColorTableSGI(GL_TEXTURE_COLOR_TABLE_SGI, GL_RGBA,256,GL_RGBA,
                      GL_FLOAT,frgba);
    }

    /* This clear is as late as possible */
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

/***************************************************************************
 * INPUT: tile information                                                 *
 ***************************************************************************/
    printf("nodes info read in: node0 = %d\n", node0);

    for(i=0; i<nsub; i++) { tile_children[i][0] = -1; }
    for(i=0; i<nsub; i++) { 
      ippp = tile_parent[i];
      nccc = 0;
      while(tile_children[ippp][nccc] >= 0) { nccc++; }
      tile_children[ippp][nccc  ] =  i;
      tile_children[ippp][nccc+1] = -1;
    }
    printf("tile_children lists generated\n");
/*
    i = 0;
    while(tile_children[node0][i] >= 0) {
      iccc = tile_children[node0][i];
      printf("child of node0 = %d    maxerr = %d\n", iccc, tile_maxerr[iccc]);
      i++;
    }
*/

/*****************************************************************************
 * GENERATE: distance**2 to each tile (rendering is done farthest to nearest *
 *           under each node                                                 *
 *****************************************************************************/
    fminx = -1.                          - eyepos[0];
    fminy = -1. * (float)Ny / (float)Nx  - eyepos[1];
    fminz = -1. * (float)Nz / (float)Nx  - eyepos[2];
    for(i=0; i<nsub; i++) {
      nr = tile_nrep[i];
      xx = fminx + (float)(nr*(2*tile_ixoff[i]+tile_nxsub[i]))/(float)Nx;
      yy = fminy + (float)(nr*(2*tile_iyoff[i]+tile_nysub[i]))/(float)Nx;
      zz = fminz + (float)(nr*(2*tile_izoff[i]+tile_nzsub[i]))/(float)Nx;
      tile_dist[i] = xx*xx + yy*yy + zz*zz;
      tile_did[i] = 0;
    }
    printf("tile_dist generated\n");

/*****************************************************************************
 * GENERATE: ordered list of tiles                                           *
 *****************************************************************************/
    tolerance = rp->icoltolerance;
    angtol = rp->angletolerance;
    viewres = rp->vrtolerance;
    delxmin = 0.;
    if(viewres > 0.) { delxmin = rp->far * viewres; }

    nlist = 1;
    list_tiles[0] = node0;
    need_check = 1;

    while(need_check == 1) {
      nlistnew = 0;
      need_check = 0;
      for(ilist = 0; ilist<nlist; ilist++) {
        inode = list_tiles[ilist];

/*
        xx = (float)(tile_nxsub[inode]*nr) / ((float)Nx/2);
        yy = (float)(tile_nysub[inode]*nr) / ((float)Nx/2);
        zz = (float)(tile_nzsub[inode]*nr) / ((float)Nx/2);
        distmin = sqrt(tile_dist[inode]) - sqrt(xx*xx + yy*yy + zz*zz);
        if(distmin < 0.) { distmin = 0.; }
*/
        distmin = sqrt(tile_dist[inode]);

        delxtol  = distmin * angtol;
        delxsize =  (float)tile_nrep[inode] / ((float)Nx/2);

        if(tile_maxerr[inode] <= tolerance || delxsize < delxtol
                                           || delxsize < delxmin) {
          list_new[nlistnew] = inode;
          nlistnew++;
        } else {
          need_check = 1;
          nccc = 0;
          while(tile_children[inode][nccc] >= 0) { nccc++; }
          isub = 1;
          while(isub >= 0) {
            distmax = -10000000.;
            isub = -1;
            for(iccc = 0; iccc < nccc; iccc++) {
              i = tile_children[inode][iccc];
              if(tile_did[i] == 0) {
                if(distmax < tile_dist[i]) { isub=i; distmax = tile_dist[i]; }
              }
            }
            if(isub >= 0) {
              list_new[nlistnew] = isub;
              nlistnew++;
              tile_did[isub] = 1;
/*
printf("isub = %d   tile_dist = %f\n", isub, tile_dist[isub]);
*/
            }
          }
        }
      }
      for(i=0; i<nlistnew; i++) { list_tiles[i] = list_new[i]; }
      nlist = nlistnew;
    }
    printf("list_tiles generated, nlist = %d\n", nlist);
    
/*****************************************************************************
 *  RENDER: loop over tiles in this list                                     *
 *****************************************************************************/
    ntiles  = 0;
    nslices = 0;
    for(jsub=0; jsub<nlist; jsub++) {
      isub = list_tiles[jsub];
      if(iprint == 1) fprintf(stderr,"%4d doing subtile %d: ", jsub, isub);

      nr = tile_nrep[isub];
      nxsub = tile_nxsub[isub];
      nysub = tile_nysub[isub];
      nzsub = tile_nzsub[isub];
      ixoff = tile_ixoff[isub];
      iyoff = tile_iyoff[isub];
      izoff = tile_izoff[isub];
      offset64t = tile_off64t[isub];
      nbytes    = nxsub * nysub * nzsub;

/***************************************************************************
 *    hvr: subroutine "subvolrend" starts here                             *
 *    INPUTS: ixoff, iyoff, izoff, nxsub, nysub, nzsub, Nx, Ny, Nz         *
 *                                                                         *
 *    ixoff = x-offset of subvolume from left/min-edge of full volume      *
 *    iyoff = y-offset of subvolume from left/min-edge of full volume      *
 *    izoff = z-offset of subvolume from left/min-edge of full volume      *
 *    nxsub = x-dim size of sub-volume (not nec. power of 2, but <= 256)   *
 *    nysub = y-dim size of sub-volume (not nec. power of 2, but <= 256)   *
 *    nzsub = z-dim size of sub-volume (not nec. power of 2, but <= 256)   *
 *    Nx    = x-dim of full volume (not nec. power of 2, unlimitted size)  *
 *    Ny    = y-dim of full volume (not nec. power of 2, unlimitted size)  *
 *    Nz    = z-dim of full volume (not nec. power of 2, unlimitted size)  *
 *                                                                         *
 *    NOTE: ALL INPUTS ARE IN ZONES (int); ALL ZONES ARE CUBES             *
 ***************************************************************************/

/***************************************************************************
 *    CALCULATE: size and position of subvolume (in modelview space)       *
 *    CONVENTIONS: 1) x-dim always goes from (-1, 1);                      *
 *                 2) all zones are cubes                                  *
 *    ==>  y-dim goes from (-Ny/Nx, +Ny/Nx)                                *
 *    ==>  z-dim goes from (-Nz/Nx, +Nz/Nx)                                *
 *                                                                         *
 *    fulminpos[3] = xyz coordinates of min-vertex of full volume          *
 *    subminpos[3] = xyz coordinates of min-vertex of sub volume           *
 *    subvolsiz[3] = xyz size of subvolume                                 *
 *    subtexsiz[3] = xyz size of power of 2 texture subvolume in which     *
 *                   input subvolume is imbedded                           *
 *                                                                         *
 *                                                                         *
 *    +------------------------+ -  +Ny/Nx                                 *
 *    |                        | ^                                         *
 *    |                        | |                                         *
 *    |                        | |                                         *
 *    |    |<--- A --->|       | |     A = subtexsiz[0] = 2**n always      *
 *    |                        | |     B = subtexsiz[1] = 2**n always      *
 *    |    +-----------+ -     | |     C = subvolsiz[0]                    *
 *    |    |           | ^     | |     D = subvolsiz[1]                    *
 *    |    +-------+   | |     |       E = subminpos[0]                    *
 *    |    |   C   |   |       | Ny    F = subminpos[1]                    *
 *    |    |       |   | B     |       G = fulminpos[0] = -1 always        *
 *    |    |      D|   |       | |     H = fulminpos[1] = -Ny/Nx always    *
 *    |    |       |   | |     | |                                         *
 *    |    |       |   | v     | |                                         *
 *    |    +-------+---+ -     | |                                         *
 *    |  (E,F)                 | |                                         *
 *    |                        | |                                         *
 *    |                        | v                                         *
 *    +------------------------+ -  -Ny/Nx                                 *
 *  (G,H)                                                                  *
 *    |<--------- Nx --------->|                                           *
 *   -1                       +1                                           *
 *                                                                         *
 ***************************************************************************/
      fulminpos[0] = -1.;
      fulminpos[1] = -1. * (float)Ny / (float)Nx;
      fulminpos[2] = -1. * (float)Nz / (float)Nx;

      facXtoN = 2.0 / (float)Nx;

      subminpos[0] = fulminpos[0] + (float)(ixoff*nr) * facXtoN;
      subminpos[1] = fulminpos[1] + (float)(iyoff*nr) * facXtoN;
      subminpos[2] = fulminpos[2] + (float)(izoff*nr) * facXtoN;
  
      subvolsiz[0] = (float)(nxsub*nr) * facXtoN;
      subvolsiz[1] = (float)(nysub*nr) * facXtoN;
      subvolsiz[2] = (float)(nzsub*nr) * facXtoN;

      for(i=0; i<3; i++) { submaxpos[i] = subminpos[i] + subvolsiz[i]; }

      nxsb2 = 2;   while(nxsb2 < nxsub) { nxsb2 *= 2; }
      nysb2 = 2;   while(nysb2 < nysub) { nysb2 *= 2; }
      nzsb2 = 2;   while(nzsb2 < nzsub) { nzsb2 *= 2; }

     /*********************************************************************
      * START of ip loop -- LOOP over pannels                             *
      *********************************************************************/
      for(ip=0; ip < npannel; ip++) {

     /*********************************************************************
      * Derive min and max distances for edges of each tile               *
      * As a byproduct, determine if tile is OUTSIDE the viewing frustum  *
      * A tile is OUTSIDE of a convex faceted volume if all 8 vertices    *
      * of the tile are on the outer side of any one plane tangent to     *
      * a facet of that volume.  Viewing frustums are convex.             *
      *********************************************************************/
      edgemin = 10000000.;
      edgemax = 0.;
      isoutside_n = 1;  /* near   */
      isoutside_f = 1;  /* far    */
      isoutside_t = 1;  /* top    */
      isoutside_b = 1;  /* bottom */
      isoutside_l = 1;  /* left   */
      isoutside_r = 1;  /* right  */
      for(i=0; i<2; i++) { xx = subminpos[0]+(float)i*subvolsiz[0]-eyepos[0];
      for(j=0; j<2; j++) { yy = subminpos[1]+(float)j*subvolsiz[1]-eyepos[1];
      for(k=0; k<2; k++) { zz = subminpos[2]+(float)k*subvolsiz[2]-eyepos[2];
        edgedist = (xx*pan_eye[ip][0]+yy*pan_eye[ip][1]+zz*pan_eye[ip][2]);
        if(edgemin > edgedist) { edgemin = edgedist; }
        if(edgemax < edgedist) { edgemax = edgedist; }

        if(edgedist > rp->near - rp->softdistance   ) { isoutside_n = 0; }
        if(edgedist < rp->far  + rp->softdistance   ) { isoutside_f = 0; }
        if(xx*pan_top_o[ip][0]+yy*pan_top_o[ip][1]
                              +zz*pan_top_o[ip][2] < 0. ) { isoutside_t = 0; }
        if(xx*pan_bot_o[ip][0]+yy*pan_bot_o[ip][1]
                              +zz*pan_bot_o[ip][2] < 0. ) { isoutside_b = 0; }
        if(xx*pan_lef_o[ip][0]+yy*pan_lef_o[ip][1]
                              +zz*pan_lef_o[ip][2] < 0. ) { isoutside_l = 0; }
        if(xx*pan_rit_o[ip][0]+yy*pan_rit_o[ip][1]
                              +zz*pan_rit_o[ip][2] < 0. ) { isoutside_r = 0; }
      }}}
/*
      printf("\nmin=%f  mid=%f  max=%f\n", edgemin, tile_dist[isub], edgemax);
*/

/******************************************************************************
 *    SKIP this tile if it is outside viewing frustum                         *
 *    this is end of jsub (tile) loop if tile is outside                      *
 ******************************************************************************/
      if(   isoutside_n == 1 || isoutside_f == 1 || isoutside_t == 1
         || isoutside_b == 1 || isoutside_l == 1 || isoutside_r == 1 ) {

      if(iprint == 1) fprintf(stderr,"tile is outside viewing frustum -- skip it\n");

      } else {

     /************************************************************
      * Read in subtile isub using DIRECT IO (if not already in) *
      ************************************************************/
      if(isubcur != isub) {
        if(iprint == 1) fprintf(stderr,"reading %s = ", tile_file[isub]);
        if(iprint == 1) fprintf(stderr,"%d bytes... ", nbytes);
        ntiles++;

        sprintf(tile_full, "%s%s\0", tile_path, tile_file[isub]);
        fdd = open(tile_full, 0);
        if(fdd == -1) { perror(tile_full); }
/*      printf("offset64t=%ld   nbin=%d\n", offset64t,nbin); */
        Dio.d_maxiosz = 67108864;
        idio = fcntl( fdd, F_DIOINFO, &Dio );
        idio = fcntl( fdd, F_SETFL, FDIRECT );
        if ( idio != 0 ) { perror("Direct I/O not available"); }

        n64  = lseek64(fdd, offset64t, SEEK_SET);
        nbin = read(fdd, bobsub, nbytes);
        close(fdd);

        /* copy into slices */
        if(ido3dtex != 1) {
          islicesize = nxsub*nysub;
          for(islice=0; islice<nzsub; islice++) {
            isliceoff = islicesize*islice;
            glBindTexture(GL_TEXTURE_2D, texname[islice]);
            glTexImage2D(GL_TEXTURE_2D, 0, GL_INTENSITY8,
              nxsb2,nysb2,0, GL_LUMINANCE, GL_UNSIGNED_BYTE,
              &bobsub[isliceoff]);
/*****************************************************************************
        glTexImage3DEXT(GL_TEXTURE_3D_EXT, 0, GL_INTENSITY8_EXT,
                nxsb2,nysb2,nzsb2, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, NULL );
        glTexSubImage3DEXT( GL_TEXTURE_3D_EXT, 0, 0,0,0, nxsub,nysub,nzsub,
            GL_LUMINANCE, GL_UNSIGNED_BYTE, bobsub );

            for(ij=0; ij<islicesize; ij++) {
              myslice[ij] = (unsigned char)(2*islice);
            }
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
            glTexImage2D(GL_TEXTURE_2D, 0, GL_INTENSITY8,
              nxsb2,nysb2,0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE,
              myslice);
 *****************************************************************************/
          }
        }
        isubcur = isub;
        ireload = 1;
      }
/*****************************************************************************
 * BEGIN multiple pannel stuff                                               *
 *****************************************************************************/
      if(ip != ipcur) {

       /****************************************************
        *  set up frustum for pannel ip                    *
        ****************************************************/
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();

        dleft   = dnearclip * pan_dlef[ip];
        dright  = dnearclip * pan_drit[ip];
        dbottom = dnearclip * pan_dbot[ip];
        dtop    = dnearclip * pan_dtop[ip];
        glFrustum( dleft, dright, dbottom, dtop, dnearclip, dfarclip );
        gluLookAt(eyeposX, eyeposY, eyeposZ,
                  pan_lookat[ip][0], pan_lookat[ip][1], pan_lookat[ip][2],
                  pan_up[ip][0],     pan_up[ip][1],     pan_up[ip][2]);

       /*************************************************************
        *  swap out old pannel (if nec.) and swap in new pannel ip  *
        *************************************************************/
        glMatrixMode(GL_TEXTURE);
        if(ido3dtex == 1) { glDisable(GL_TEXTURE_3D_EXT); }
        else              { glDisable(GL_TEXTURE_2D); }
        glDisable(GL_BLEND);
        if(ipcur > -1) {
          glXWaitGL();
          glReadPixels(0,0,rp->width,rp->height,GL_RGB,GL_UNSIGNED_BYTE,
                       rgbpannel[ipcur]);
        }
        glXWaitGL();
        glDrawPixels(rp->width,rp->height,GL_RGB,GL_UNSIGNED_BYTE,
                     rgbpannel[ip]);
        ipcur = ip;
        glXWaitGL();
        glEnable(GL_BLEND);
        if(ido3dtex == 1) { glEnable(GL_TEXTURE_3D_EXT); }
        else              { glEnable(GL_TEXTURE_2D); }
        glXWaitGL();
      }
/*****************************************************************************
 * END   multiple pannel stuff                                               *
 *****************************************************************************/

     /***********************************************************************
      *  SET scale and offset of texture memory for subvolume               *
      *  ASSUMES glLoadIdentity sets limits of                              *
      *          --> subtexture <--  to (0,1)x(0,1)x(0,1)                   *
      *          which get mapped to                                        *
      *          (subminpos[i], subminpos[i]+subvolsiz[i])x for(i=0,1,2)    *
      ***********************************************************************/
      if(ido3dtex == 1) {
        glMatrixMode(GL_TEXTURE);
        glLoadIdentity();

        epsil = 0.01;                      /* epsilon*dx less than full size */
        scalex = (float)Nx * ((float)nxsub - 2.*epsil) /
                 (2.0*(float)(nxsb2*nr) * (float)nxsub);
        scaley = (float)Nx * ((float)nysub - 2.*epsil) /
                 (2.0*(float)(nysb2*nr) * (float)nysub);
        scalez = (float)Nx * ((float)nzsub - 2.*epsil) /
                 (2.0*(float)(nzsb2*nr) * (float)nzsub);
        glScalef(scalex, scaley, scalez);

/* >>> */
        dxe   = 1.00 * (float)nr / (float)Nx;
        glTranslatef(-subminpos[0]-dxe, -subminpos[1]-dxe, -subminpos[2]-dxe );
      }

     /***********************************************************************
      * SET clipping planes for the subvolume                               *
      ***********************************************************************
      * static GLdouble eqnxm[4] = { 1.,  0.,  0.0, 1.0 };     clip x< -1.0 *
      * static GLdouble eqnxp[4] = {-1.,  0.,  0.0, 1.0 };     clip x>  1.0 *
      * static GLdouble eqnym[4] = { 0.,  1.0,  0., 1.0 };     clip y< -1.0 *
      * static GLdouble eqnyp[4] = { 0., -1.0,  0., 1.0 };     clip y>  1.0 *
      * static GLdouble eqnzm[4] = { 0.,  0.,  1.0, 1.0 };     clip z< -1.0 *
      * static GLdouble eqnzp[4] = { 0.,  0., -1.0, 1.0 };     clip z>  1.0 *
      *                              A    B    C    D                       *
      ***********************************************************************
      * clip for (x*A + y*B + z*C + D) < 0.                                 *
      ***********************************************************************/
      if(ido3dtex == 1) {
        eqnxm[3] = -(GLdouble)subminpos[0]; glClipPlane(GL_CLIP_PLANE0,eqnxm );
        eqnxp[3] =  (GLdouble)submaxpos[0]; glClipPlane(GL_CLIP_PLANE1,eqnxp );
        eqnym[3] = -(GLdouble)subminpos[1]; glClipPlane(GL_CLIP_PLANE2,eqnym );
        eqnyp[3] =  (GLdouble)submaxpos[1]; glClipPlane(GL_CLIP_PLANE3,eqnyp );
        eqnzm[3] = -(GLdouble)subminpos[2]; glClipPlane(GL_CLIP_PLANE4,eqnzm );
        eqnzp[3] =  (GLdouble)submaxpos[2]; glClipPlane(GL_CLIP_PLANE5,eqnzp );
      }

      while ( glGetError() != GL_NO_ERROR ) ;

      if(ido3dtex == 1 && ireload == 1) {
        if(iprint == 1)  fprintf(stderr,"loading... ");
        glTexImage3DEXT(GL_TEXTURE_3D_EXT, 0, GL_INTENSITY8_EXT,
                nxsb2,nysb2,nzsb2, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, NULL );

        while ( glGetError() != GL_NO_ERROR ) ;

        glTexSubImage3DEXT( GL_TEXTURE_3D_EXT, 0, 0,0,0, nxsub,nysub,nzsub,
	    GL_LUMINANCE, GL_UNSIGNED_BYTE, bobsub );

        ierr = glGetError();
        if ( ierr == GL_TEXTURE_TOO_LARGE_EXT ) {
          perror("Texture too large"); exit(1);
        }
        ireload = 0;
      }

/**************************************************************************
 *    ALL this stuff with ds (below) is TOXIC WASTE                       *
 **************************************************************************/
/**************************************************************************
 *    For 'soft' clipping planes, ramp opacity up to full over the
 *    range <dsoft>.
 *
 *    Scale dsfar so that at the far clipping plane, ds is approx.
 *    'nplanes' zones.  This increases at the near clipping plane
 *    in proportion to the apparent perspective size increase of a zone.
 **************************************************************************/
      dsmax = rp->far + rp->softdistance;
      dsfar = dsmax * ftan( 0.5 * rp->fovangle * Pid180 ) 
       * (2. * cubesz[0] / ( (float)Nx * rp->nplanes ) );
      dsnear = dsfar *
        ((rp->near-rp->softdistance) / (rp->far+rp->softdistance));
      ds      =  dsfar;
      ss      =  rp->far  + rp->softdistance;
      sfinish =  rp->near - rp->softdistance;
      dsmin = 2. * cubesz[0] / (rp->maxplanes * (float)Nx);
      if(sfinish < dsmin) { sfinish = dsmin; }
      fac = (ss-rp->near) / (rp->far - rp->near + 2.0*rp->softdistance);
      ds = fac*dsfar + (1.-fac)*dsnear;
      ds = ss / ((float)Nx * rp->nplanes);
      if(ds < dsmin) { ds = dsmin; }
/**************************************************************************
 *    the only things that SHOULD survive from the ds TOXIC WASTE (above) *
 *    is dsmin and something about turning on soft clipping planes        * 
 **************************************************************************/
      ds = 2. / ( (float)Nx * rp->nplanes );
      if(viewres > 0.) { ds = delxmin / rp->nplanes; }

     /*********************************************************************
      *    THIS IS WHERE ALL ALPHA BLENDING IS DONE                       *
      *********************************************************************/
      if(ido3dtex == 1) {
      if(iprint == 1)  fprintf(stderr,"rendering... ");
        while(ss >= sfinish) {
          if(ss > edgemin  &&  ss < edgemax) {

            if ( ss > rp->far ) {
              fac = (rp->softdistance + rp->far - ss) / rp->softdistance;
            } else if ( ss < dsoftNear ) {
              fac  = (ss + rp->softdistance - dsoftNear) / rp->softdistance;
              if(fac < 0) { fac = 0.; }
            } else {
              fac = 1.0;
            }

            alpha = alpha0 * fac * (ds/(2.*cubesz[0]));
            glColor4f(1,1,1, alpha);

            hdist[0] = pan_dlef[ip] * ss;   vdist[0] = pan_dbot[ip] * ss;
            hdist[1] = pan_dlef[ip] * ss;   vdist[1] = pan_dtop[ip] * ss;
            hdist[2] = pan_drit[ip] * ss;   vdist[2] = pan_dbot[ip] * ss;
            hdist[3] = pan_drit[ip] * ss;   vdist[3] = pan_dtop[ip] * ss;

            for(j=0; j<4; j++) { for(i=0; i<3; i++) {
             tvert[j][i] = eyepos[i] + ss       * pan_eye[ip][i] +
                                       hdist[j] * pan_torq[ip][i] +
                                       vdist[j] * pan_up[ip][i]  ;
            }}
  
            glBegin(GL_TRIANGLE_STRIP);
            glTexCoord3fv(tvert[0]); glVertex3fv(tvert[0]);
            glTexCoord3fv(tvert[1]); glVertex3fv(tvert[1]);
            glTexCoord3fv(tvert[2]); glVertex3fv(tvert[2]);
            glTexCoord3fv(tvert[3]); glVertex3fv(tvert[3]);
            glEnd();
            nslices++;
          }
  
          ss -= ds;
/*
          ds = ss / ((float)Nx * rp->nplanes);
          if(ds < dsmin) { ds = dsmin; }
*/
        }
      } else {
        dz = subvolsiz[2]/nzsub;
        alpha = alpha0 * (dz/(2.*cubesz[0]));
        glColor4f(1., 1., 1., alpha);
        for(islice=0; islice<nzsub; islice++) {
          glBindTexture(GL_TEXTURE_2D, texname[islice]);
          zz = subminpos[2] + dz * (0.5 + (float)islice);
          xx0 = 0.;
          xx1 = 1.;
          yy0 = 0.;
          yy1 = 1.;
          glBegin(GL_QUADS);
            glTexCoord2f(xx0, yy0); glVertex3f(subminpos[0], subminpos[1], zz);
            glTexCoord2f(xx0, yy1); glVertex3f(subminpos[0], submaxpos[1], zz);
            glTexCoord2f(xx1, yy1); glVertex3f(submaxpos[0], submaxpos[1], zz);
            glTexCoord2f(xx1, yy0); glVertex3f(submaxpos[0], subminpos[1], zz);
          glEnd();
          nslices++;
        }
/*
        glFlush();
*/
      }

      if(iprint == 1)  fprintf(stderr,"fin  slices=%d\n", nslices);

      }           /* end of isoutside = 0 case: tile is inside frustum */

    }             /* end of ip loop (loop over pannels)                 */
    }             /* end of jsub loop                                   */
    printf("rendered %d slices in %d tiles\n", nslices, ntiles);
}

void crossprod(float vec1[3], float vec2[3], float vec3[3]) {
    vec3[0] = vec1[1] * vec2[2]  -  vec1[2] * vec2[1];
    vec3[1] = vec1[2] * vec2[0]  -  vec1[0] * vec2[2];
    vec3[2] = vec1[0] * vec2[1]  -  vec1[1] * vec2[0];
}

/* ================================================================
 Only called in demo mode, when no file or bytebucket is specified
 for the rendered image. - wait for keypress to exit
 */

static void
processInput(Display *dpy) {

    XEvent event;
    int redraw=0 ;  /* may put back in redraw someday */

    while(1) {
    do {
	char buf[31];
	KeySym keysym;

	XNextEvent(dpy, &event);
	switch(event.type) {
	case Expose:
	    redraw = 0;
	    break;
	case ConfigureNotify:
	    glViewport(0, 0, event.xconfigure.width, event.xconfigure.height);
	    redraw = 0;
	    break;
	case KeyPress:
	    (void) XLookupString(&event.xkey, buf, sizeof(buf), &keysym, NULL);
	    switch (keysym) {
	    case XK_Escape:
	    default:
	      /*ipcstop(); */
	      /* exit(EXIT_SUCCESS);  */
	      return;
	    }
	default:
	  break;
	}
    } while (XPending(dpy));
    }
    /* exit(EXIT_SUCCESS);  */
}


/* ================================================================
 */

static Display *dpy;
static GLXPbufferSGIX pbuffer;
static char *rgb;

void render( struct Renderparams *rp ) {

  int idebug;
  static int virgin = 1, isinitted = 0;
  static XVisualInfo *vi;
  static XSetWindowAttributes swa;
  static Window win;
  static GLXContext cx;
  static int attributeList[] = { GLX_RENDER_TYPE_SGIX, GLX_RGBA_BIT_SGIX,
				 GLX_RED_SIZE, 8,
				 GLX_GREEN_SIZE, 8, GLX_BLUE_SIZE, 8, 
				 GLX_ALPHA_SIZE, 8, 
				 GLX_DEPTH_SIZE, 0, GLX_STENCIL_SIZE, 0,
				 None };
  static int pbattributeList[] = { /* GLX_PRESERVED_CONTENTS_SGIX, GL_FALSE,
                                   GLX_LARGEST_PBUFFER_SGIX, GL_TRUE, */
				   None };

  static GLXFBConfigSGIX *xfbconfig;

  int nitems, screen, i, j, isectx0, isecty0, i1, i0;

    XSizeHints _sizeHints;
    int xPos, yPos, nz;
    unsigned int width, height;

    typedef struct {
#define MWM_HINTS_DECORATIONS   2
      long flags;
      long functions;
      long decorations;
      long input_mode;
    } MotifWmHints;

    MotifWmHints hints;  
    Atom motifHints;

    int mine, nbytes, fdout, npix, ip;
    off64_t ispot, ispotted;
    char outfile[128];

    Nx = rp->nx;
    Ny = rp->ny;
    Nz = rp->nz;

    xPos = rp->hpos;
    yPos = rp->vpos;
    width = rp->width;
    height = rp->height;
    nbytes = rp->height * rp->width * 3;

    if ( virgin ) {

      dpy = XOpenDisplay(NULL);
      if (!dpy) { perror("Can't open display"); exit(1); }

#ifndef INVISIBLE
      xfbconfig = glXChooseFBConfigSGIX( dpy, DefaultScreen(dpy),
					 attributeList,&nitems );
      vi = glXGetVisualFromFBConfigSGIX( dpy, *xfbconfig );
      /* vi = glXChooseVisual(dpy, DefaultScreen(dpy), attributeList); */
      if (!vi) { perror("No suitable visual"); exit(1); }
      cx = glXCreateContext(dpy, vi, 0, GL_TRUE);

      swa.colormap = XCreateColormap(dpy, RootWindow(dpy, vi->screen),
                                   vi->visual, AllocNone);
      swa.border_pixel = 0;
      swa.event_mask = ExposureMask | StructureNotifyMask | KeyPressMask;

      win = XCreateWindow(dpy,
			RootWindow(dpy, vi->screen),
			xPos, yPos,
			width, height,
			0, 
			vi->depth,
			InputOutput, 
			vi->visual,
			CWBorderPixel|CWColormap|CWEventMask, &swa);			   

      /* make sure we don't set some value we didn't intend to.  */
      memset (&_sizeHints,0,sizeof(XSizeHints)); 
      _sizeHints.x = xPos;
      _sizeHints.y = yPos;
      _sizeHints.flags |= USPosition;
      _sizeHints.width  = width;
      _sizeHints.height = height;


      _sizeHints.flags |= USSize;

      XSetStandardProperties(dpy, win, 
			 "tex", "tex",
			 None, NULL, (u_int)NULL, &_sizeHints);

      /* -- */
      motifHints = XInternAtom( dpy, "_MOTIF_WM_HINTS", 0);

      hints.flags = MWM_HINTS_DECORATIONS;
      hints.decorations = 0;  /* Absolutely no
                               decorations. */
      XChangeProperty( dpy, win,
                    motifHints, motifHints, 32,
                    PropModeReplace, (unsigned char *) &hints, 4);

      XMapWindow(dpy, win);
      /*     XMoveWindow(dpy, win, 1610, 10); */

      glXMakeCurrent(dpy, win, cx);

#else
      screen = DefaultScreen(dpy);
      xfbconfig = glXChooseFBConfigSGIX( dpy, screen,
					 attributeList,&nitems );

      cx = glXCreateContextWithConfigSGIX( dpy, *xfbconfig,
					   GLX_RGBA_TYPE_SGIX, NULL, GL_TRUE);

      fprintf(stderr,"Have config %p and context %p .. ", xfbconfig, cx );

      /* The following consistently fails with 'insufficient resources'.
	 I also had to change the declaration of the routine in glx.h (!?!)
	 to allow the width&height pointers..
	 */

      pbuffer = glXCreateGLXPbufferSGIX( dpy, *xfbconfig, width, height,
					 pbattributeList );
      if ( pbuffer == NULL ) {
	perror("Can't create pixelboffer");
	exit(1);
      }

      glXMakeCurrent(dpy, pbuffer, cx);

#endif


      glXWaitX();

    }

    if(isinitted == 0) {     /* only init once */
      isinitted = 1;
      init(rp);
      rgb  = (char*)valloc(nbytes);
    }

    draw_scene(rp);
    glFinish();

    virgin = 0;

    if(strdif(rp->imagename, "none") == 1) {

      if(ido3dtex == 1) { glDisable(GL_TEXTURE_3D_EXT); }
      glReadPixels( 0, 0, rp->width, rp->height,
		    GL_RGB, GL_UNSIGNED_BYTE, rgbpannel[ipcur]);

/*************************************************************************
 *             OUTPUT SECTION                                            *
 *************************************************************************/
      /* Put the rgbpannel frames to files */
      for(ip=0; ip<npannel; ip++) {
        i0 = ip%10;
        i1 = ip/10;
        sprintf(outfile, "%s%d%d\0", rp->imagename, i1, i0);
        fdout = open(outfile, O_RDWR|O_CREAT|O_TRUNC,0666);
        if ( fdout == -1 ) { perror(rp->imagename); exit(1); }
        npix = write(fdout, rgbpannel[ip], nbytes );
        if ( npix != nbytes ) {
          perror("Could not write entire image"); exit(1);
        }
        close(fdout);
      }
    }
    return;
}


void endrender() {
#ifdef INVISIBLE
  glXDestroyGLXPbufferSGIX( dpy, pbuffer );                  // XXXXXXXXXXXXif0
#endif
  /* XCloseDisplay(NULL); */
}


#endif

void Chvr_work::Set_HVname(char* cHVnew)
{
	sprintf(m_ShvrIn.sHVname, "%s\0", cHVnew);

//	void  setstr(char*, char*);
//	setstr(hvname, cHVnew);
}


/*****************************************************************************
 *                        READ IN PANNEL INFO HERE                           *
 *---------------------------------------------------------------------------*
 * read in of configuration file goes here : configuration file gives rules  *
 * for generating [center? and (horiz, vert) offsets]                        *
 * for each pannel for each pannel given center?, eye?, up? from above       *
 *---------------------------------------------------------------------------*
 *              torq    eye     up                                           *
 *            i    0      1      2                                           *
 *  pw_normal[i]   0.     1.     0.    <-- typical example of central pannel *
 *      pw_up[i]   0.     0.     1.    <-- typical example of central pannel *
 *                                                                           *
 *---------------------------------------------------------------------------*
 * Example PW_CONFIGURATION for single pannel (1280x1024 per pannel)         *
 *       0. 1. 0.  0. 0. 1.  0. 1. 0.  0.625 0.5                             *
 *---------------------------------------------------------------------------*
 * Example PW_CONFIGURATION for flat 4 pannel (1600x1200 per pannel)         *
 *       0. 1. 0.  0. 0. 1.  -0.6667 1.0 -0.5  0.6667 0.5                    *
 *       0. 1. 0.  0. 0. 1.   0.6667 1.0 -0.5  0.6667 0.5                    *
 *       0. 1. 0.  0. 0. 1.  -0.6667 1.0  0.5  0.6667 0.5                    *
 *       0. 1. 0.  0. 0. 1.   0.6667 1.0  0.5  0.6667 0.5                    *
 *****************************************************************************/

void Chvr_work::SetFrustum(float *center, float *up, float *normal, int iWidth, int iHeight, float fPanWidth)
{
	int i;
	float dot;

	m_ShvrIn.iNewFrustum = 1;
	m_ShvrIn.iWidth  = iWidth;
	m_ShvrIn.iHeight = iHeight;
    m_ShvrIn.fAspectRatio = (float)iWidth / (float)iHeight;

	for(i=0; i<3; i++) { m_ShvrIn.fPanCent[i] = center[i]; }
	for(i=0; i<3; i++) { m_ShvrIn.fPanNorm[i] = normal[i]; }
	for(i=0; i<3; i++) { m_ShvrIn.fPanUp[i]   = up[i]; }

	m_ShvrIn.fHalfWidth = 0.5 * fPanWidth;
	m_ShvrIn.fHalfHeight = m_ShvrIn.fAspectRatio * m_ShvrIn.fHalfWidth;

	dot = center[0]*normal[0] + center[1]*normal[1] + center[2]*normal[2];
	if(dot < 0.) { dot = -dot; }
	m_ShvrIn.fFovAngle = 2.0 * atan(m_ShvrIn.fHalfHeight/dot) / Pid180;

	npannel = 1;
}

void Chvr_work::SetDefaultFrustum()
{

	m_ShvrIn.iNewFrustum = 1;
	m_ShvrIn.iWidth  = 1024;
	m_ShvrIn.iHeight = 1024;
    m_ShvrIn.fAspectRatio = (float)m_ShvrIn.iWidth / (float)m_ShvrIn.iHeight;

    m_ShvrIn.fPanNorm[0] = 0.;    /* default single pannel settings */
    m_ShvrIn.fPanNorm[1] = 1.;
    m_ShvrIn.fPanNorm[2] = 0.;
    m_ShvrIn.fPanUp[0]   = 0.;
    m_ShvrIn.fPanUp[1]   = 0.;
    m_ShvrIn.fPanUp[2]   = 1.;
	m_ShvrIn.fPanCent[0] = 0.;
    m_ShvrIn.fPanCent[1] = 1.;
	m_ShvrIn.fPanCent[2] = 0.;
	
	m_ShvrIn.fFovAngle  = 34.;
    m_ShvrIn.fHalfHeight = tan( Pid180* m_ShvrIn.fFovAngle * 0.5 );
    m_ShvrIn.fHalfWidth  = m_ShvrIn.fHalfHeight / m_ShvrIn.fAspectRatio;

	npannel = 1;
}
/*
	struct HvrInput {    // This structure contains all of the input needed for the hvr code
		int iNewHV;
		char sHVname[100];

		int iNewFrustum;
		int iWidth;
		int iHeight;
		float fPanCent[3];
		float fPanNorm[3];
		float fPanUp[3];
		float fHalfWidth;
		float fHalfHeight;
		float fFovAngle;
		float fAspectRatio;

		int iNewLUT;
		char sCmapname[100];
		char sAmapname[100];

		int iNewView;
		float fEye[3];
		float fCent[3];
		float fUp[3];
		float fNearClip;
		float fFarrClip;
	};
	HvrInput m_ShvrIn;     // GUI writes input here
	HvrInput m_ShvrUse;    // Rendering code uses ShvrUse, after copying info from ShvrIn
*/

void Chvr_work::SetDefaultView()
{
	m_ShvrIn.iNewView = 1;
	m_ShvrIn.fCent[0] = 0.;
	m_ShvrIn.fCent[1] = 0.;
	m_ShvrIn.fCent[2] = 0.;
	m_ShvrIn.fEye[0] = 0.0;
	m_ShvrIn.fEye[1] = 0.0;
	m_ShvrIn.fEye[2] = 7.0;
	m_ShvrIn.fUp[0] = 0.;
	m_ShvrIn.fUp[1] = 1.;
	m_ShvrIn.fUp[2] = 0.;
	m_ShvrIn.fNearClip = 0.5;
	m_ShvrIn.fFarrClip = 20.5;
}

void Chvr_work::CopyHvrInputs()
{
	// Copy from GUI input struct to hvr use struct
	// Set all iNew flags to the status of NOT new.
    // BEGIN NEED THREAD SAFE!!
	memcpy(&m_ShvrUse.iNewHV, &m_ShvrIn.iNewHV, sizeof(HvrInput));
	m_ShvrIn.iNewHV      = 0;
	m_ShvrIn.iNewLUT     = 0;
	m_ShvrIn.iNewView    = 0;
	m_ShvrIn.iNewFrustum = 0;
    // END NEED THREAD SAFE!!
}

void Chvr_work::IncrementEyePoint(int delx, int dely, int iMouseMode)
{
    void crossprod(float vec1[3], float vec2[3], float vec3[3]);
    float dotproduct( const float*, const float* );
	float radfac, rotfacx, rotfacy;
	float fEC[3], fHoriz[3], fVert[3], fDelUp, fEN[3], fNewEN[3], fNormEN2, fNormNewEN2;
	float fNewEC[3], fNormEC2, fNormNewEC2;
	float fReNormFac, fNewDelUp, fDelCent;
	int i;

	// adjustable parameter : sets scale between speed of mouse motion and speed of rotation
	radfac = (float)0.01;

	rotfacx =              radfac * (float)delx;
	rotfacy = (float)0.2 * radfac * (float)dely;
	for(i=0; i<3; i++) { fEC[i] = m_ShvrIn.fEye[i] - m_ShvrIn.fCent[i]; }
	crossprod(fEC, m_ShvrIn.fUp, fHoriz);

	if(iMouseMode == 0) {
		crossprod(fHoriz, fEC, fVert);
		for(i=0; i<3; i++) { fNewEC[i] = fEC[i] + rotfacx * fHoriz[i] + rotfacy * fVert[i]; }
		fNormEC2    = dotproduct(fEC, fEC);
		fNormNewEC2 = dotproduct(fNewEC, fNewEC);
		fReNormFac = (float)sqrt(fNormEC2 / fNormNewEC2);
		for(i=0; i<3; i++) { fNewEC[i] *= fReNormFac; }    // Want norms of NewEC and old EC to be equal
		for(i=0; i<3; i++) { m_ShvrIn.fEye[i] = m_ShvrIn.fCent[i] + fNewEC[i]; }
	}

	if(iMouseMode == 1) {
		fDelUp = dotproduct(m_ShvrIn.fUp, fEC);
		for(i=0; i<3; i++) { fEN[i]    = fEC[i] - fDelUp * m_ShvrIn.fUp[i]; }
		for(i=0; i<3; i++) { fNewEN[i] = fEN[i] + rotfacx * fHoriz[i]; }
		fNormEN2    = dotproduct(fEN, fEN);
		fNormNewEN2 = dotproduct(fNewEN, fNewEN);
		fReNormFac = (float)sqrt(fNormEN2 / fNormNewEN2);
		for(i=0; i<3; i++) { fNewEN[i] *= fReNormFac; }    // Want norms of NewEN and old EN to be equal
		fDelCent  = rotfacy * (float)sqrt(fNormEN2);
		fNewDelUp = fDelUp + fDelCent;
		for(i=0; i<3; i++) {
			m_ShvrIn.fEye[i]  = m_ShvrIn.fCent[i] + fNewEN[i] + fNewDelUp * m_ShvrIn.fUp[i];
			m_ShvrIn.fCent[i] = m_ShvrIn.fCent[i]             + fDelCent  * m_ShvrIn.fUp[i];
		}
	}

	if(iMouseMode == 2) {
		crossprod(fHoriz, fEC, fVert);
		for(i=0; i<3; i++) {
			m_ShvrIn.fEye[i]  += rotfacx * fHoriz[i] + rotfacy * fVert[i];
			m_ShvrIn.fCent[i] += rotfacx * fHoriz[i] + rotfacy * fVert[i];
		}
	}
}

void Chvr_work::SetRenderQuality(int iPixErr, float fAngleError, float fSizeError)
{
	tolerance = iPixErr;		/* max color level error allowed with no scan down  */
	angtol    = fAngleError;	/* max angle allowed with no scan down              */
	viewres   = fSizeError;	    /* dx_brick > farclip * vrtolerance => no scan down */
}

void Chvr_work::StopRendering()
{
	m_iStopRendering = 1;
}

void Chvr_work::SaveKey(struct Renderparams *SKey)
{
	int i;

	SKey->nx = Nx;
	SKey->ny = Ny;
	SKey->nz = Nz;
	SKey->opacity = opacity;
	sprintf(SKey->cmapname,"%s", m_ShvrUse.sCmapname);
	sprintf(SKey->amapname,"%s", m_ShvrUse.sAmapname);
	*SKey->bobname = NULL;
	sprintf(SKey->hvname, "%s", m_ShvrUse.sHVname);
	SKey->isectx = 0;
	SKey->isecty = 0;
	SKey->nsectx = 1;
	SKey->nsecty = 1;
	SKey->width = m_ShvrUse.iWidth;
	SKey->height = m_ShvrUse.iHeight;
	SKey->hpos = 0;
	SKey->vpos = 0;
	SKey->moviemode = 0;
	SKey->movieframes = 1;
	sprintf(SKey->imagename, "Test_Image.pix");
	sprintf(SKey->moviename, "Test_Movie.pix");
	SKey->fovangle = m_ShvrUse.fFovAngle;
	SKey->eyeX = m_ShvrUse.fEye[0];
	SKey->eyeY = m_ShvrUse.fEye[1];
	SKey->eyeZ = m_ShvrUse.fEye[2];
	SKey->centerX = m_ShvrUse.fCent[0];
	SKey->centerY = m_ShvrUse.fCent[1];
	SKey->centerZ = m_ShvrUse.fCent[2];
	SKey->upX = m_ShvrUse.fUp[0];
	SKey->upY = m_ShvrUse.fUp[1];
	SKey->upZ = m_ShvrUse.fUp[2];
	SKey->eyedirX = m_ShvrUse.fCent[0] - m_ShvrUse.fEye[0];
	SKey->eyedirY = m_ShvrUse.fCent[1] - m_ShvrUse.fEye[1];
	SKey->eyedirZ = m_ShvrUse.fCent[2] - m_ShvrUse.fEye[2];
	for(i=0; i<4; i++) { SKey->viewdefined[i] = 1; }
	for(i=0; i<6; i++) { SKey->ifauxclip[i] = 0; }
	SKey->my_near = m_ShvrUse.fNearClip;
	SKey->my_far  = m_ShvrUse.fFarrClip;
	SKey->softdistance = 0.;
	SKey->nplanes = 1;
	SKey->maxplanes = 1;
	SKey->boxcolor = -1;
	SKey->saveslabs = 0;
	SKey->movieframe = 0;
	SKey->nfpk = 10;
	SKey->ntpf = 0;
	SKey->nrpk = 0.;
	SKey->icoltolerance = tolerance;
	SKey->angletolerance = angtol;
	SKey->vrtolerance = viewres;
}

void Chvr_work::RestorKey(struct Renderparams *SKey)
{
	opacity = SKey->opacity;
	sprintf(m_ShvrIn.sCmapname, "%s", SKey->cmapname);
	sprintf(m_ShvrIn.sAmapname, "%s", SKey->amapname);
	sprintf(m_ShvrIn.sHVname, "%s", SKey->hvname);
	m_ShvrIn.fFovAngle = SKey->fovangle;
	m_ShvrIn.fEye[0] = SKey->eyeX;
	m_ShvrIn.fEye[1] = SKey->eyeY;
	m_ShvrIn.fEye[2] = SKey->eyeZ;
	m_ShvrIn.fCent[0] = SKey->centerX;
	m_ShvrIn.fCent[1] = SKey->centerY;
	m_ShvrIn.fCent[2] = SKey->centerZ;
	m_ShvrIn.fUp[0] = SKey->upX;
	m_ShvrIn.fUp[1] = SKey->upY;
	m_ShvrIn.fUp[2] = SKey->upZ;
	m_ShvrIn.fNearClip = SKey->my_near;
	m_ShvrIn.fFarrClip = SKey->my_far;
}

void Chvr_work::ZoomEyePoint(int delx, int dely, int iMouseMode)
{
	float radfac, fMult, fEC[3];
	int i;

	// adjustable parameter : sets scale between speed of mouse motion and speed of rotation
	radfac = (float)0.01;
	fMult = (float)1.0 - radfac * (float)dely;

	for(i=0; i<3; i++) { fEC[i] = m_ShvrIn.fEye[i] - m_ShvrIn.fCent[i]; }
	for(i=0; i<3; i++) { m_ShvrIn.fEye[i] = m_ShvrIn.fCent[i] + fMult * fEC[i]; }
}

void Chvr_work::SetLUT(char *sAmap, char *sCmap)
{
	setstr(m_ShvrIn.sCmapname, sCmap);
	setstr(m_ShvrIn.sAmapname, sAmap);
}
