// hvr_mfcDlg.h : header file
//
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#if !defined(AFX_HVR_MFCDLG_H__0790D72B_9701_11D4_AB18_00D0680005C4__INCLUDED_)
#define AFX_HVR_MFCDLG_H__0790D72B_9701_11D4_AB18_00D0680005C4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CHvr_mfcDlg dialog

class CHvr_mfcDlg : public CDialog
{
// Construction
public:
	BOOL m_bMakeMovie;
	CMenu *pCMainMenu;
	int LoadPowerWallConfig(char* sFileName);
	void LoadProjectInfo();
	int m_iNMovieKeys;
	char m_cMovieName[100];
	int m_iNSavedKeys;
	int m_iNDeletedKeys;
	struct Renderparams m_SSavedKeys[128];
	struct Renderparams m_SMovieKeys[128];
	struct SLutNots m_SMovieKeySluts[128];
	CHvr_mfcDlg(CWnd* pParent = NULL);	// standard constructor
	int m_dlgViewPortCreated;
	int m_iNFields;
	int m_iChosenField;
	struct SFieldInfo {
		char cFieldFile[256];
		char cLutFile[256];
	};
	SFieldInfo m_sFields[100];
/*
	struct SLutNots {
		int iNCnots;
		int iNAnots;
		int iCind[32];
		int iAind[32];
		float fRed[32];
		float fGrn[32];
		float fBlu[32];
		float fAlp[32];
	};
*/
	struct SLutNots m_SLUTs[128];

// Dialog Data
	//{{AFX_DATA(CHvr_mfcDlg)
	enum { IDD = IDD_HVR_MFC_DIALOG };
	CButton	m_bcPQFrame;
	CListBox	m_CListFields;
	CListBox	m_CListDataFiles;
	CListBox	m_CListMovieKeys;
	CListBox	m_CListKeys;
	CString	m_csHVname;
	int		m_iNfpk;
	float	m_fNrpk;
	int		m_iMouseMode;
	float	m_Opacity;
	float	m_fRenderingQuality;
	int		m_iFarClip;
	int		m_iNearLimit;
	BOOL	m_bLoopOverData;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHvr_mfcDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CHvr_mfcDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnExit();
	afx_msg void OnGo();
	afx_msg void OnChangeEditHvFile();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnSaveKey();
	afx_msg void OnSelchangeListKeys();
	afx_msg void OnDblclkListKeys();
	afx_msg void OnChangeEditFpk();
	afx_msg void OnChangeEditRpk();
	afx_msg void OnSelchangeListDatafiles();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnStaticViewControl();
	afx_msg void OnRadioCf();
	afx_msg void OnRadioCe();
	afx_msg void OnRadioE();
	afx_msg void OnButtonWriteFrame();
	afx_msg void OnClearPath();
	afx_msg void OnChangeEditOpacity();
	afx_msg void OnChangeEditRQuality();
	afx_msg void OnReleasedcaptureSliderFarClip(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderNearClip(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMenuMainOpen();
	afx_msg void OnMenuDisplayEdit();
	afx_msg void OnMenuEditLut();
	afx_msg void OnMenuMainNewProject();
	afx_msg void OnMenuMainBobs();
	afx_msg void OnRadioTb();
	afx_msg void OnButtonPreviewMovie();
	afx_msg void OnSelchangeListFields();
	afx_msg void OnMenuDisplayInteractivedisplayQuality();
	afx_msg void OnMenuDisplayHosts();
	afx_msg void OnMenuColorsUsePalett();
	afx_msg void OnMenuColorsUseRgba();
	afx_msg void OnMenuOptionsTimersOn();
	afx_msg void OnMenuOptionsTimersOff();
	afx_msg void OnMenuOptionsTimersFile();
	afx_msg void OnMenuOptionsBufioOn();
	afx_msg void OnMenuOptionsBufioOff();
	afx_msg void OnMenuOptionsSingleBuffer();
	afx_msg void OnMenuOptionsDoubleBuffer();
	afx_msg void OnMenuOptionsPresentationSingle();
	afx_msg void OnMenuOptionsShowLut();
	afx_msg void OnMenuOptionsShowTicks();
	afx_msg void OnMenuViewEdit();
	afx_msg void OnMenuFileSaveImage();
	afx_msg void OnCheckLoopOverData();
	afx_msg void OnSelchangeListMovieKeys();
	afx_msg void OnButtonMakeMovie();
	afx_msg void OnMenuTimeAdvance();
	afx_msg void OnMenuFileSavekeyframes();
	afx_msg void OnMenuFileLoadKeyframes();
	afx_msg void OnMenuFileSaveMoviePath();
	afx_msg void OnMenuFileLoadMoviePath();
	afx_msg void OnMenuFileSaveProject();
	afx_msg void OnMenuFileSaveProjectAs();
	afx_msg void OnMenuFileLoadExplicitPath();
	afx_msg void OnMenuStatsPDF();
	afx_msg void OnMenuStatsCross();
	afx_msg void OnMenuEditAuxclip();
	afx_msg void OnDblclkListFields();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	int m_iLMouseDown;
	int m_iRMouseDown;
	int m_iMouseY;
	int m_iMouseX;
	int m_iPorts;
	char cHostNames[100][80];
	char m_ProjectFile[256];
public:
	void SetCrossInfo(int iServer);
	int m_iDoStats;
	void ClusterEyePoint(int iDelX, int iDelY, int iMouseMode, int iInc);
	void ClusterRender(int iBlock);
	void XferLocalKeyInfoToCluster();
	Ihvr_work *pChvrMainPort[100];
	void DoQualityFrame();
	int m_iYField;
	int LoadOneFieldArg(int iNfield, char cPathList[][80], char cFileList[][80]);
	int ExPathToHvrIn(char DirPath[3000][80]);
	int m_iRemoteRendering;
	int StopRendering();
	int m_iAmRendering;
	void PresentationRendering();
	int FindFieldAndTime(CString csHVfile, int *iField, int *iTime);
	int m_iChosenTime;
	int LoadOneField(int iNfield);
	void DisplayKey(Renderparams rp, SLutNots lut);
	void SetMainWidgetsFromKey(Renderparams rp);
	int m_iUseProjName;
	void TimeAdvance();
	int m_iTimeAdvance;
	void OnOK();
	int m_iStop;
	void MakeMovie();
	int m_iNBobs;
	int InitializeHVRserver();
	void SetLutTicks();
	int m_iNBuffers;
	int LoadFieldInfo(int iResetLUTs);
	void CalculateAndSetNearFarClipping();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_HVR_MFCDLG_H__0790D72B_9701_11D4_AB18_00D0680005C4__INCLUDED_)
