// hvr_mfcDlg.cpp : implementation file
//
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#include "stdafx.h"

#include <sys/timeb.h>
// ack #include "C:\include\GL\gl3dlabsext.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <math.h>
#include "wingdi.h"
// ack #include "C:\include\GL\glut.h"
// #include "mui.h"

// #include "renderparams.h"
// #include "hvr_work.h"
#include "hvr_mfc.h"
#include "hvr_mfcDlg.h"
#include "HvrViewDlg.h"
#include "DisplayControl.h"
#include "EditLUT.h"
#include "EditProject.h"
#include "GetBobs.h"
#include "InteractiveDisplayQaulity.h"
#include "DisplayHosts.h"
#include "TimeStamp.h"
#include "Edit_View.h"
#include "EditSubregion.h"
#include "AbortBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define MAX_DATA_FILES     3000
#define MAX_N_FIELDS        100
static int iNDataFiles;
static int iNDataFiless[MAX_N_FIELDS];
static char cDirPath[MAX_DATA_FILES][80];
static char cRemDirPath[MAX_DATA_FILES][80];
static char cRemHost[MAX_DATA_FILES][80];
static char cHVlist[MAX_DATA_FILES][80];
static char cHVlists[MAX_N_FIELDS][MAX_DATA_FILES][80];
static char cYHVlist[MAX_N_FIELDS][80];
static char cYDirPath[MAX_N_FIELDS][80];
struct Renderparams Movieframes[8192];
struct SLutNots MovieSluts[8192];
struct SExplicitPath {
	float eyex;
	float eyey;
	float eyez;
	float cntx;
	float cnty;
	float cntz;
	float upx;
	float upy;
	float upz;
	int iTime;
};
static SExplicitPath sExPath[8192];
static int iNExFrames = 0;

CHvrViewDlg dlgView;
CDisplayControl dlgDispCont;
CEditLUT dlgEditLUT;
EditProject dlgEditProject;
CGetBobs dlgGetBobs;
CInteractiveDisplayQaulity dlgIDQ;
CDisplayHosts dlgDHosts;
CEdit_View dlgEditView;
CAbortBox dlgAbortBox;
CEditSubregion dlgSubRegion;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHvr_mfcDlg dialog

CHvr_mfcDlg::CHvr_mfcDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHvr_mfcDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHvr_mfcDlg)
	m_csHVname = _T("");
	m_iNfpk = 40;
	m_fNrpk = 0.0f;
	m_iMouseMode = -1;
	m_Opacity = 0.0f;
	m_fRenderingQuality = 0.0f;
	m_iFarClip = 0;
	m_iNearLimit = 0;
	m_bLoopOverData = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CHvr_mfcDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHvr_mfcDlg)
	DDX_Control(pDX, IDC_BUTTON_WRITE_FRAME, m_bcPQFrame);
	DDX_Control(pDX, IDC_LIST_FIELDS, m_CListFields);
	DDX_Control(pDX, IDC_LIST_DATAFILES, m_CListDataFiles);
	DDX_Control(pDX, IDC_LIST_MOVIE_KEYS, m_CListMovieKeys);
	DDX_Control(pDX, IDC_LIST_KEYS, m_CListKeys);
	DDX_Text(pDX, IDC_EDIT_HV_FILE, m_csHVname);
	DDX_Text(pDX, IDC_EDIT_FPK, m_iNfpk);
	DDV_MinMaxInt(pDX, m_iNfpk, -10000, 10000);
	DDX_Text(pDX, IDC_EDIT_RPK, m_fNrpk);
	DDV_MinMaxFloat(pDX, m_fNrpk, -1000.f, 1000.f);
	DDX_Radio(pDX, IDC_RADIO_CF, m_iMouseMode);
	DDX_Text(pDX, IDC_EDIT_OPACITY, m_Opacity);
	DDV_MinMaxFloat(pDX, m_Opacity, 0.f, 10000.f);
	DDX_Text(pDX, IDC_EDIT_R_QUALITY, m_fRenderingQuality);
	DDV_MinMaxFloat(pDX, m_fRenderingQuality, 0.f, 100.f);
	DDX_Slider(pDX, IDC_SLIDER_FAR_CLIP, m_iFarClip);
	DDX_Slider(pDX, IDC_SLIDER_NEAR_CLIP, m_iNearLimit);
	DDX_Check(pDX, IDC_CHECK_LOOP_OVER_DATA, m_bLoopOverData);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHvr_mfcDlg, CDialog)
	//{{AFX_MSG_MAP(CHvr_mfcDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnExit)
	ON_BN_CLICKED(IDC_GO, OnGo)
	ON_EN_CHANGE(IDC_EDIT_HV_FILE, OnChangeEditHvFile)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_BN_CLICKED(IDC_SAVE_KEY, OnSaveKey)
	ON_LBN_SELCHANGE(IDC_LIST_KEYS, OnSelchangeListKeys)
	ON_LBN_DBLCLK(IDC_LIST_KEYS, OnDblclkListKeys)
	ON_EN_CHANGE(IDC_EDIT_FPK, OnChangeEditFpk)
	ON_EN_CHANGE(IDC_EDIT_RPK, OnChangeEditRpk)
	ON_LBN_SELCHANGE(IDC_LIST_DATAFILES, OnSelchangeListDatafiles)
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_BN_CLICKED(IDC_STATIC_VIEW_CONTROL, OnStaticViewControl)
	ON_BN_CLICKED(IDC_RADIO_CF, OnRadioCf)
	ON_BN_CLICKED(IDC_RADIO_CE, OnRadioCe)
	ON_BN_CLICKED(IDC_RADIO_E, OnRadioE)
	ON_BN_CLICKED(IDC_BUTTON_WRITE_FRAME, OnButtonWriteFrame)
	ON_BN_CLICKED(IDC_CLEAR_PATH, OnClearPath)
	ON_EN_CHANGE(IDC_EDIT_OPACITY, OnChangeEditOpacity)
	ON_EN_CHANGE(IDC_EDIT_R_QUALITY, OnChangeEditRQuality)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_FAR_CLIP, OnReleasedcaptureSliderFarClip)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_NEAR_CLIP, OnReleasedcaptureSliderNearClip)
	ON_COMMAND(IDR_MENU_MAIN_OPEN, OnMenuMainOpen)
	ON_COMMAND(IDR_MENU_DISPLAY_EDIT, OnMenuDisplayEdit)
	ON_COMMAND(IDR_MENU_EDIT_LUT, OnMenuEditLut)
	ON_COMMAND(IDR_MENU_MAIN_NEW_PROJECT, OnMenuMainNewProject)
	ON_COMMAND(IDR_MENU_MAIN_BOBS, OnMenuMainBobs)
	ON_BN_CLICKED(IDC_RADIO_TB, OnRadioTb)
	ON_BN_CLICKED(IDC_BUTTON_PREVIEW_MOVIE, OnButtonPreviewMovie)
	ON_LBN_SELCHANGE(IDC_LIST_FIELDS, OnSelchangeListFields)
	ON_COMMAND(IDR_MENU_DISPLAY_INTERACTIVEDISPLAY_QUALITY, OnMenuDisplayInteractivedisplayQuality)
	ON_COMMAND(IDR_MENU_DISPLAY_HOSTS, OnMenuDisplayHosts)
	ON_COMMAND(IDR_MENU_COLORS_USE_PALETT, OnMenuColorsUsePalett)
	ON_COMMAND(IDR_MENU_COLORS_USE_RGBA, OnMenuColorsUseRgba)
	ON_COMMAND(IDR_MENU_OPTIONS_TIMERS_ON, OnMenuOptionsTimersOn)
	ON_COMMAND(IDR_MENU_OPTIONS_TIMERS_OFF, OnMenuOptionsTimersOff)
	ON_COMMAND(IDR_MENU_OPTIONS_TIMERS_FILE, OnMenuOptionsTimersFile)
	ON_COMMAND(IDR_MENU_OPTIONS_BUFIO_ON, OnMenuOptionsBufioOn)
	ON_COMMAND(IDR_MENU_OPTIONS_BUFIO_OFF, OnMenuOptionsBufioOff)
	ON_COMMAND(IDR_MENU_OPTIONS_SINGLE_BUFFER, OnMenuOptionsSingleBuffer)
	ON_COMMAND(IDR_MENU_OPTIONS_DOUBLE_BUFFER, OnMenuOptionsDoubleBuffer)
	ON_COMMAND(IDR_MENU_OPTIONS_PRESENTATION_SINGLE, OnMenuOptionsPresentationSingle)
	ON_COMMAND(IDR_MENU_OPTIONS_SHOW_LUT, OnMenuOptionsShowLut)
	ON_COMMAND(IDR_MENU_OPTIONS_SHOW_TICKS, OnMenuOptionsShowTicks)
	ON_COMMAND(IDR_MENU_VIEW_EDIT, OnMenuViewEdit)
	ON_COMMAND(IDR_MENU_FILE_SAVE_IMAGE, OnMenuFileSaveImage)
	ON_BN_CLICKED(IDC_CHECK_LOOP_OVER_DATA, OnCheckLoopOverData)
	ON_LBN_SELCHANGE(IDC_LIST_MOVIE_KEYS, OnSelchangeListMovieKeys)
	ON_BN_CLICKED(IDC_BUTTON_MAKE_MOVIE, OnButtonMakeMovie)
	ON_COMMAND(IDR_MENU_TIME_ADVANCE, OnMenuTimeAdvance)
	ON_COMMAND(IDR_MENU_FILE_SAVEKEYFRAMES, OnMenuFileSavekeyframes)
	ON_COMMAND(IDR_MENU_FILE_LOAD_KEYFRAMES, OnMenuFileLoadKeyframes)
	ON_COMMAND(IDR_MENU_FILE_SAVE_MOVIE_PATH, OnMenuFileSaveMoviePath)
	ON_COMMAND(IDR_MENU_FILE_LOAD_MOVIE_PATH, OnMenuFileLoadMoviePath)
	ON_COMMAND(IDR_MENU_FILE_SAVE_PROJECT, OnMenuFileSaveProject)
	ON_COMMAND(IDR_MENU_FILE_SAVE_PROJECT_AS, OnMenuFileSaveProjectAs)
	ON_COMMAND(IDR_MENU_FILE_LOAD_EXPLICIT_PATH, OnMenuFileLoadExplicitPath)
	ON_COMMAND(IDR_MENU_STATS_PDF, OnMenuStatsPDF)
	ON_COMMAND(IDR_MENU_STATS_CROSS, OnMenuStatsCross)
	ON_COMMAND(IDR_MENU_EDIT_AUXCLIP, OnMenuEditAuxclip)
	ON_COMMAND(IDR_MENU_MAIN_EXIT, OnExit)
	ON_LBN_DBLCLK(IDC_LIST_FIELDS, OnDblclkListFields)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHvr_mfcDlg message handlers

BOOL CHvr_mfcDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// SET DEFAULT AND INITIAL VALUES HERE
	dlgIDQ.Initialize();
	m_iDoStats = 0;
	m_iNSavedKeys = 0;
	m_iNDeletedKeys = 0;
	m_iNMovieKeys = 0;
	m_iLMouseDown = 0;
	m_iRMouseDown = 0;
	m_iMouseMode  = 3;
	dlgView.m_iMouseMode = m_iMouseMode;
	m_iPorts      = 0;
	m_Opacity     = 0.5;
	m_fRenderingQuality = dlgIDQ.m_fPresentationAngleTolerance;
	m_iNearLimit  = 1;		// Lower limit of near clip as a fraction of distance from eye to center
	m_iFarClip    = 100;	// Distance from center to both near and far clipping planes
	strcpy(m_ProjectFile, "current.hvp");
	m_iNFields = 0;
	m_bMakeMovie = FALSE;
	m_iUseProjName = 0;
	m_iChosenTime = 0;
	m_iChosenField = 0;
	m_iAmRendering = 0;
	m_iRemoteRendering = 0;
	m_iYField = -1;

	dlgDispCont.m_iDisplayWidth  = 512;
	dlgDispCont.m_iDisplayHeight = 512;
	dlgDispCont.m_fDisplayFOV    = 34.;
	dlgDispCont.m_fFullFOV       = 34.;
	dlgDispCont.m_fSeamAngle     = 0.;
	dlgDispCont.m_fStereoEyeDisp = 0.;
	dlgDispCont.m_iPanelHeight   = 512;
	dlgDispCont.m_iPanelWidth    = 512;
	dlgDispCont.m_iNPanelHoriz   = 1;
	dlgDispCont.m_iNPanelVert    = 1;
	dlgEditLUT.InitPlots();
	dlgEditProject.m_csLUTFile       = "GrayRamp";
	dlgEditProject.m_csTickFile      = "none";
	dlgEditProject.m_csTickFiles[0]  = "none";
	dlgEditProject.m_csMoviePathFile = "none";
	dlgEditProject.m_csKeyFrameFile  = "none";
	dlgEditProject.m_csProjectFile   = "none";
	dlgDispCont.GenerateMovieFrusta();
	dlgDHosts.m_csQueueHost = "localhost";
	dlgDHosts.m_csRenderServer = "localhost";
	dlgView.SetPP(this);
	dlgEditLUT.SetPP(this);
	dlgDHosts.SetPP(this);
	dlgSubRegion .SetPP(this);
	dlgEditView.SetPP(this);

	int i;
	for(i=0; i<100; i++) {
		dlgDHosts.m_iHostIsUp[i] = -2;
		sprintf(dlgDHosts.m_cRemoteDirectories[i], "SameAsLocal");
	}

	m_dlgViewPortCreated = 0;
	if(m_dlgViewPortCreated == 0) {
		dlgView.Create(IDD_HVR_VIEW, this);
//		dlgView.SetWindowPos(&wndTop, 10, 10, 512+6, 512+26, SWP_NOACTIVATE | SWP_NOCOPYBITS | SWP_NOZORDER);
//		AfxMessageBox("lala", MB_OK);
		m_dlgViewPortCreated = 1;
	}

	pCMainMenu = GetMenu();

	sprintf(cHostNames[0], "%s", "rend01");

	// Initialize multithreaded dcom system
	//
	HRESULT hr = CoInitializeEx(NULL, COINIT_MULTITHREADED);
	if(FAILED(hr)) {
		AfxMessageBox("CoInitializeEx failed.", MB_ICONSTOP);		
		CoUninitialize();
		exit(0);
	}

	// Startup local hvr_server
	//
	if(InitializeHVRserver() == 0) {
		AfxMessageBox("InitializeHVRserver Failed at 1st startup", MB_ICONSTOP);
		CoUninitialize();
		exit(0);
	}

	LoadProjectInfo();

	char cHVfile[100];
	sprintf(cHVfile, "%s%s", cDirPath[m_iChosenTime], cHVlist[m_iChosenTime]);
	pChvrMainPort[0]->Set_HVname((unsigned char *)cHVfile);

	int iWnd = (int) dlgView.m_hWnd;
	pChvrMainPort[0]->Set_hWnd(iWnd);

/*****************************************************************
 *                    Set Viewing Frustum                        *
 *****************************************************************/
	float fUp[3], fNorm[3], fCent[3], fWidth, fFOV, Pid180;
	int iWidth, iHeight;
	iWidth  = dlgDispCont.m_iDisplayWidth;
	iHeight = dlgDispCont.m_iDisplayHeight;
	fFOV = 34.;
	fCent[0] = 0.;    fUp[0] = 0.;    fNorm[0] = 0.;
	fCent[1] = 1.;    fUp[1] = 0.;    fNorm[1] = 1.;
	fCent[2] = 0.;    fUp[2] = 1.;    fNorm[2] = 0.;
	Pid180 = (float)(3.141592654/180.);
	fWidth = (float)2.0 * ((float)iWidth / (float)iHeight) * (float)tan( Pid180* fFOV * 0.5 );
	pChvrMainPort[0]->SetFrustum(fCent, fUp, fNorm, iWidth, iHeight, fWidth);

	pChvrMainPort[0]->StartUp();
	pChvrMainPort[0]->SetOpacity(m_Opacity);
	CalculateAndSetNearFarClipping();

//  dhp - if version with paletted texture by default do this
	OnMenuColorsUsePalett();

//	SetRenderQuality(int iPixErr, float fAngleError, float fSizeError)

	pChvrMainPort[0]->SetRenderQuality(dlgIDQ.m_iValueTolerance,dlgIDQ.m_fAngleTolerance,dlgIDQ.m_fVoxelSize);
	pChvrMainPort[0]->SetDoRender();  // Initdialog
	m_csHVname.Format("A");

	// Set Initial Position of Main window
	SetWindowPos(&wndTop, 512+10, 41, 0, 0, SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);

	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CHvr_mfcDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CHvr_mfcDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CHvr_mfcDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CHvr_mfcDlg::OnExit() 
{
	int i;
	int iAnswer = MessageBox("Save project to file?  Cancel returns to project.",
							 "EXIT BOX",  MB_ICONQUESTION | MB_YESNOCANCEL);

	if(iAnswer == IDCANCEL) { return; }

	if(iAnswer == IDYES) { OnMenuFileSaveProject(); }

	StopRendering();

	for(i=0; i <= dlgDHosts.m_iNCols * dlgDHosts.m_iNRows; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
		pChvrMainPort[i]->ClearIt();
		pChvrMainPort[i]->Release();
		dlgDHosts.m_iHostIsUp[i] = 0;
	}}

	CoUninitialize();

	CDialog::OnOK();
}
/*
UINT SpawnPort( LPVOID pParam ){

	Chvr_work* my_work = (Chvr_work*)pParam;
	my_work->StartUp();

    return 0;   // thread completed successfully
}
*/
void CHvr_mfcDlg::OnGo() 
{
	int KeysToHvrIn(char DirPath[3000][80], char HVlist[3000][80],
					struct Renderparams Keys[64], struct SLutNots SlutKeys[64], char *movnam, bool bLoop);
	int nMovieFrames, im, i, j;
	int rend_dump_params(struct Renderparams *rp, FILE *fp, char *movnam, int im);
	bool bLoop;
	Ihvr_q *pChvrQueue;

/*********************************************************************************
 *  COPY Queue Host name from CString to wide character string for               *
 *  CoCreateInstance below                                                       *
 *********************************************************************************/
	char cServer[256], str[256];
	wchar_t wcServer[256];
	wchar_t wcA[2] = L"a";

	sprintf(cServer, "%s", (LPCSTR)dlgDHosts.m_csQueueHost);
	sprintf(str, "Remote host for HVR Queue will be: %s", cServer);
	if( IDCANCEL  == MessageBox(str, "Confirm Remote Host for Movie Queue",
								MB_OKCANCEL | MB_ICONQUESTION | MB_DEFBUTTON1) ) {
		return;
	}

	for(i=0; i<256; i++) { wcServer[i] = L'\0'; }

	i = 0;
	while(i < 256  &&  cServer[i] != '\0') {
		wcServer[i] = (wchar_t)((int)wcA[0] + (int)cServer[i] - (int)'a');
		i++;
	}

//	sprintf(str, "Number of characters copyied to wide character string = %d", i);
//	MessageBox(str);

/*********************************************************************************
 *  GENERATE movie frame data by interpolating between key frames                *
 *********************************************************************************/
	sprintf(m_cMovieName, "%s", m_csHVname);
	if(m_bLoopOverData) { bLoop = TRUE; } else { bLoop = FALSE; }
	if(iNExFrames > 0) {
		nMovieFrames = ExPathToHvrIn(cRemDirPath);
	} else {
		nMovieFrames = KeysToHvrIn(cRemDirPath, cHVlist, m_SMovieKeys, m_SMovieKeySluts, m_cMovieName, bLoop);
	}

	if(nMovieFrames <= 0) {
		MessageBox("Failed to interpolate path with these keys", "Movie Generation Error",
			MB_ICONEXCLAMATION | MB_OK);
		return;
	}

/*********************************************************************************
 *  GET a pointer to the hvr_queue on a remote host                              *
 *********************************************************************************/
	MULTI_QI mqi[] = { {&IID_Ihvr_q, NULL, S_OK} };
//	COSERVERINFO csi = {0, L"Rend05", NULL, 0};
	COSERVERINFO csi = {0, NULL, NULL, 0};
	csi.pwszName = (LPWSTR)wcServer;
	HRESULT hr = CoCreateInstanceEx(CLSID_hvr_q, NULL, CLSCTX_SERVER, &csi, 
                                   sizeof(mqi)/sizeof(mqi[0]), mqi);
	if(FAILED(hr)) {
		AfxMessageBox("CoCreateInstanceEx failed for Ihvr_queue.", MB_ICONSTOP);
		return;
	}
	pChvrQueue = (Ihvr_q *)(mqi[0].pItf);

/*********************************************************************************
 *  SEND begin flag to the queue (tells queue to expect incoming movie info)     *
 *********************************************************************************/
	hr = pChvrQueue->BeginMovie();
	if(FAILED(hr)) {
		AfxMessageBox("BeginMovie failed for Ihvr_queue.", MB_ICONSTOP);
	}

/*********************************************************************************
 *  SEND view frusta information (one frustum per display panel)                 *
 *********************************************************************************/
	for(i=0; i<dlgDispCont.m_iNMovieFrusta; i++) {
		pChvrQueue->AddFrustum( dlgDispCont.m_SMovieFrusta[i].fCent,
								dlgDispCont.m_SMovieFrusta[i].fUp,
								dlgDispCont.m_SMovieFrusta[i].fNorm,
								dlgDispCont.m_SMovieFrusta[i].iWidth,
								dlgDispCont.m_SMovieFrusta[i].iHeight,
								dlgDispCont.m_SMovieFrusta[i].fWidth  );
	}

/*********************************************************************************
 *  IF a non-0 Stereo Eye Displacement is specified, pass it as an extra panel   *
 *********************************************************************************/
	if(dlgDispCont.m_fStereoEyeDisp > 0.000001) {
		float fStereoCent[3], fStereoUp[3], fStereoNorm[3], fUpInv, fNormInv;

		// Cent vector can by 0, Up and Norm are normalized averages over all the movie panels
		// Eye displacment will be along the cross product of these average Up and Norm vectors
		for(j=0; j<3; j++) {
			fStereoCent[j] = (float)0.;
			fStereoUp[j]   = (float)0.;
			fStereoNorm[j] = (float)0.;
		}

		for(i=0; i<dlgDispCont.m_iNMovieFrusta; i++) {
			for(j=0; j<3; j++) {
				fStereoUp[j]   += dlgDispCont.m_SMovieFrusta[i].fUp[j];
				fStereoNorm[j] += dlgDispCont.m_SMovieFrusta[i].fNorm[j];
			}
		}
		fUpInv   = (float)(1.0 / sqrt(fStereoUp[0]*fStereoUp[0] +
									  fStereoUp[1]*fStereoUp[1] +
									  fStereoUp[2]*fStereoUp[2]   ));
		fNormInv = (float)(1.0 / sqrt(fStereoNorm[0]*fStereoNorm[0] +
									  fStereoNorm[1]*fStereoNorm[1] +
									  fStereoNorm[2]*fStereoNorm[2]  ));
		for(j=0; j<3; j++) {
			fStereoUp[j]   *= fUpInv;
			fStereoNorm[j] *= fNormInv;
		}

		int iStereoHeight = 0;
		int iStereoWidth  = 0;

		pChvrQueue->AddFrustum( fStereoCent,
								fStereoUp,
								fStereoNorm,
								iStereoHeight,
								iStereoWidth,
								dlgDispCont.m_fStereoEyeDisp );
	}

/*********************************************************************************
 *  SEND movie frame information (one view + color/alpha LUT per movie frame)    *
 *********************************************************************************/
	for(im=0; im < nMovieFrames; im++) {

		pChvrQueue->SetLUTia(	MovieSluts[im].iNAnots,
								MovieSluts[im].iAind,
								MovieSluts[im].fAlp    );

		pChvrQueue->SetLUTirgb(	MovieSluts[im].iNCnots,
								MovieSluts[im].iCind,
								MovieSluts[im].fRed,
								MovieSluts[im].fGrn,
								MovieSluts[im].fBlu    );

		Movieframes[im].angletolerance = dlgIDQ.m_fPresentationAngleTolerance;
		Movieframes[im].vrtolerance    = dlgIDQ.m_fPresentationVoxelSize;
		Movieframes[im].icoltolerance  = dlgIDQ.m_iPresentationValueTolerance;
		Movieframes[im].nplanes        = (float)dlgIDQ.m_iNPresentationPlanes;

		pChvrQueue->AddFrame(&Movieframes[im]);
	}

/*******************************************************************************************
 *  SEND end flag to the queue (tells queue to close input to this movie and submit queue) *
 *******************************************************************************************/
	hr = pChvrQueue->EndMovie();
	if(FAILED(hr)) {
		AfxMessageBox("EndMovie failed for Ihvr_queue.", MB_ICONSTOP);
	}

/*********************************************************************************
 *  RELEASE pointer to hvr_queue                                                 *
 *********************************************************************************/
	hr = pChvrQueue->Release();
	if(FAILED(hr)) {
		AfxMessageBox("Release failed for Ihvr_queue.", MB_ICONSTOP);
	}

	MessageBox("Completed queue submission");
//	AfxBeginThread(SpawnPort, pChvrMainPort);  // Here's how to spawn a thread
}

void CHvr_mfcDlg::OnChangeEditHvFile() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	sprintf(m_cMovieName, m_csHVname);
}

void CHvr_mfcDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{

	CDialog::OnLButtonDown(nFlags, point);
}

void CHvr_mfcDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	CDialog::OnMouseMove(nFlags, point);
}

void CHvr_mfcDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CDialog::OnLButtonUp(nFlags, point);
}

void CHvr_mfcDlg::OnSaveKey() 
{
	int /*i,*/ rend_dump_params(struct Renderparams *rp, FILE *fp, char *movnam, int im);
/*	FILE *fpp;*/
/*	char str[100];*/
	char file[_MAX_PATH];
//	char str[100];

	// TODO: Add your control notification handler code here
	pChvrMainPort[0]->SaveKey(&m_SSavedKeys[m_iNSavedKeys]);

	pChvrMainPort[0]->GetLUT32irgb(	&m_SLUTs[m_iNSavedKeys].iNCnots,
									 m_SLUTs[m_iNSavedKeys].iCind,
									 m_SLUTs[m_iNSavedKeys].fRed,
									 m_SLUTs[m_iNSavedKeys].fGrn,
									 m_SLUTs[m_iNSavedKeys].fBlu    );

	pChvrMainPort[0]->GetLUT32ia(	&m_SLUTs[m_iNSavedKeys].iNAnots,
									 m_SLUTs[m_iNSavedKeys].iAind,
									 m_SLUTs[m_iNSavedKeys].fAlp    );

//	sprintf(str, "# of alpha Nots: %d   # of rgb Nots: %d\n", m_SLUTs[m_iNSavedKeys].iNAnots, m_SLUTs[m_iNSavedKeys].iNAnots);
//	MessageBox(str);



//	sprintf(file, "Mouse Mode = %d\n", m_iMouseMode);
//	MessageBox(file, NULL, MB_OK);

	sprintf(file, "Key%03d", m_iNSavedKeys+m_iNDeletedKeys);
	m_CListKeys.AddString(file);
	m_iNSavedKeys++;

/*
	fpp = fopen(file, "w");
	i = rend_dump_params(&m_SSavedKeys[m_iNSavedKeys], fpp, m_cMovieName, 0);
	fclose(fpp);
*/

}

void CHvr_mfcDlg::OnSelchangeListKeys() 
{
	int i, j;
	int iPopup, iList;
	CPoint point;
	RECT rList, rItem;

	CMenu menu;
	menu.CreatePopupMenu();
	menu.AppendMenu(MF_STRING, 1, "Display this key");
	menu.AppendMenu(MF_STRING, 2, "Append to key Movie Path");
//	menu.AppendMenu(MF_STRING, 3, "Duplicate key");
	menu.AppendMenu(MF_STRING, 4, "Set LUTs of this key to current");
	menu.AppendMenu(MF_STRING, 5, "Set LUTs of ALL keys to current");
//	menu.AppendMenu(MF_STRING, 6, "Set field of this key to current");
//	menu.AppendMenu(MF_STRING, 7, "Set field of ALL keys to current");
	menu.AppendMenu(MF_STRING, 8, "Delete this key");
	menu.AppendMenu(MF_STRING, 9, "Delete ALL keys");

	i = m_CListKeys.GetCurSel();
	iList = i;
	m_CListKeys.GetWindowRect(&rList);			// Get screen ccords of list box
	m_CListKeys.GetItemRect(iList, &rItem);		// Get offset to item in list box
	point.x = rItem.left + rList.left;
	point.y = rItem.top  + rList.top;

	iPopup = menu.TrackPopupMenu(TPM_RETURNCMD | TPM_RIGHTALIGN,
		 point.x, point.y, AfxGetMainWnd());

	if(iPopup < 1  ||  iPopup > 9) { return; }
	StopRendering();

	if(iPopup == 1) { DisplayKey(m_SSavedKeys[i], m_SLUTs[i]); }	// Display this key

	if(iPopup == 2) { OnDblclkListKeys(); }							// Append to key Movie Path
		
//	if(iPopup == 3) {    // Duplicate key
//		char str[100];
//		memcpy(&m_SSavedKeys[m_iNSavedKeys], &m_SSavedKeys[i], sizeof(m_SSavedKeys[0]));
//		memcpy(&m_SLUTs[m_iNSavedKeys], &m_SLUTs[i], sizeof(m_SLUTs[0]));
//
//		sprintf(str, "Key%03d", m_iNSavedKeys);
//		m_CListKeys.AddString(str);
//		m_iNSavedKeys++;
//	}
	if(iPopup == 4) {    // Set LUTs of this key to current
		pChvrMainPort[0]->GetLUT32irgb(	&m_SLUTs[i].iNCnots,
										 m_SLUTs[i].iCind,
										 m_SLUTs[i].fRed,
										 m_SLUTs[i].fGrn,
										 m_SLUTs[i].fBlu    );

		pChvrMainPort[0]->GetLUT32ia(	&m_SLUTs[i].iNAnots,
										 m_SLUTs[i].iAind,
										 m_SLUTs[i].fAlp    );
	}
	if(iPopup == 5) {    // Set LUTs of ALL keys to current

		for(j=0; j<m_iNSavedKeys; j++) {
			pChvrMainPort[0]->GetLUT32irgb(	&m_SLUTs[j].iNCnots,
											 m_SLUTs[j].iCind,
											 m_SLUTs[j].fRed,
											 m_SLUTs[j].fGrn,
											 m_SLUTs[j].fBlu    );

			pChvrMainPort[0]->GetLUT32ia(	&m_SLUTs[j].iNAnots,
											 m_SLUTs[j].iAind,
											 m_SLUTs[j].fAlp    );
		}
	}
//	if(iPopup == 6) {    // Set field of this key to current
//	}
//	if(iPopup == 7) {    // Set field of ALL keys to current
//	}
	if(iPopup == 8) {    // Delete this key
		m_iNSavedKeys--;
		for(j=i; j<m_iNSavedKeys; j++) {
			memcpy(&m_SSavedKeys[j], &m_SSavedKeys[j+1], sizeof(m_SSavedKeys[0]));
			memcpy(&m_SLUTs[j], &m_SLUTs[j+1], sizeof(m_SLUTs[0]));
		}
		m_CListKeys.DeleteString(i);
		m_iNDeletedKeys++;
	}
	if(iPopup == 9) {    // Delete ALL keys
		m_iNSavedKeys = 0;
		m_iNDeletedKeys = 0;
		m_CListKeys.ResetContent();
	}

}

void CHvr_mfcDlg::OnDblclkListKeys() 
{
	int iKey, i, i1, i2, n1, n2;
	char str[256];
	int GetTail(char *str, char *tail);
	char keytail_1[256], keytail_2[256];

	UpdateData(TRUE);

	// IF an explicit path is loaded, clear it out and start fresh
	if(iNExFrames > 0) {
		iNExFrames = 0;
		m_iNMovieKeys = 0;
		m_CListMovieKeys.ResetContent();
	}

	// Copy keyframe view & time, color LUT, and interpolation info into movie keys
	iKey = m_CListKeys.GetCurSel();
	memcpy(&m_SMovieKeys[m_iNMovieKeys].opacity, &m_SSavedKeys[iKey].opacity, sizeof(Renderparams));
	m_SMovieKeys[m_iNMovieKeys].nfpk            = m_iNfpk;
	m_SMovieKeys[m_iNMovieKeys].nrpk            = m_fNrpk;
	m_SMovieKeys[m_iNMovieKeys].ntpf            = 1;
//	m_SMovieKeys[m_iNMovieKeys].width           = width;
//	m_SMovieKeys[m_iNMovieKeys].height          = height;
//	m_SMovieKeys[m_iNMovieKeys].nplanes         = nplanes;
//	m_SMovieKeys[m_iNMovieKeys].maxplanes       = maxplanes;
	m_SMovieKeys[m_iNMovieKeys].icoltolerance   = 6;
	m_SMovieKeys[m_iNMovieKeys].angletolerance  = m_fRenderingQuality;
	m_SMovieKeys[m_iNMovieKeys].vrtolerance     = 0.0;

	memcpy(&m_SMovieKeySluts[m_iNMovieKeys].iNCnots, &m_SLUTs[iKey].iNCnots, sizeof(SLutNots));

	// IF: 1) on 2nd or later keyframe, 2) NOT looping over data, and 3) different bobs
	// THEN: set Number of movie Frames Per Key to be consistent with one frame per time state.
	if(m_iNMovieKeys > 0) { if(m_bLoopOverData == FALSE) {
		n1 = GetTail((char *)m_SMovieKeys[m_iNMovieKeys-1].hvname, keytail_1);
		n2 = GetTail((char *)m_SMovieKeys[m_iNMovieKeys  ].hvname, keytail_2);
		i1 = -1;
		i2 = -2;
		for(i=0; i<iNDataFiles; i++) {
			if(strncmp(keytail_1, cHVlist[i], n1) == 0 ) { i1 = i; }
			if(strncmp(keytail_2, cHVlist[i], n2) == 0 ) { i2 = i; }
		}
		if(i2 != i1) {
			m_iNfpk = i2 - i1;
			m_SMovieKeys[m_iNMovieKeys].nfpk = m_iNfpk;
		}
	}}

	// UPDATE list box of movie keys
	if(m_iNMovieKeys > 0) {
		sprintf(str, "  #Frames:%d   #Rotations:%f", m_iNfpk, m_fNrpk);
		m_CListMovieKeys.AddString(str);
	}

	sprintf(str, "Key%03d", iKey+m_iNDeletedKeys);
	m_CListMovieKeys.AddString(str);

	m_iNMovieKeys++;
	m_SMovieKeys[m_iNMovieKeys].nfpk = 0;

	UpdateData(FALSE);
}

void CHvr_mfcDlg::OnSelchangeListMovieKeys() 
{
	int iMovieKey, j;
	char str[256];
	int iPopup, iList;
	CPoint point;
	RECT rList, rItem;

	UpdateData(TRUE);

	iList = m_CListMovieKeys.GetCurSel();
	m_CListMovieKeys.GetWindowRect(&rList);			// Get screen ccords of list box
	m_CListMovieKeys.GetItemRect(iList, &rItem);	// Get offset to item in list box
	point.x = rItem.left + rList.left;
	point.y = rItem.top  + rList.top;

	if(iList%2 == 1) {
		// If selection points to interpolation info:
		iMovieKey = 1 + iList / 2;

		CMenu menu;
		menu.CreatePopupMenu();
		menu.AppendMenu(MF_STRING, 1, "Set #Frames & #Rotations to inputs");
//		menu.AppendMenu(MF_STRING, 2, "Set #Frames from keys");
//		menu.AppendMenu(MF_STRING, 3, "Set #Rotations from keys");

		iPopup = menu.TrackPopupMenu(TPM_RETURNCMD | TPM_RIGHTALIGN,
			 point.x, point.y, AfxGetMainWnd());

		if(iPopup == 1) {
			// 1) modify MovieKeys to reflect edit box info
			m_SMovieKeys[iMovieKey].nfpk = m_iNfpk;
			m_SMovieKeys[iMovieKey].nrpk = m_fNrpk;

			// 2) modify list box display to reflect edit box info
			sprintf(str, "  #Frames:%d   #Rotations:%f", m_iNfpk, m_fNrpk);
			m_CListMovieKeys.DeleteString(iList);
			m_CListMovieKeys.InsertString(iList, str);
		}
	} else {
		// If selection points to a key frame:
		iMovieKey = iList / 2;

		CMenu menu;
		menu.CreatePopupMenu();
		menu.AppendMenu(MF_STRING, 1, "Display this movie key");
		menu.AppendMenu(MF_STRING, 2, "Replace this key with current");
		menu.AppendMenu(MF_STRING, 3, "Delete this movie key");
		menu.AppendMenu(MF_STRING, 4, "Set ALL keys to Current Field & LUT");

		iPopup = menu.TrackPopupMenu(TPM_RETURNCMD | TPM_RIGHTALIGN,
			 point.x, point.y, AfxGetMainWnd());

		if(iPopup < 1  ||  iPopup > 4) { return; }
		StopRendering();

		if(iPopup == 1) { DisplayKey(m_SMovieKeys[iMovieKey], m_SMovieKeySluts[iMovieKey]); }

		if(iPopup == 2) {    // Replace this key with current

			// set key to be current HVRwork values, leaving nfpk and nrpk alone
			int   nfpk = m_SMovieKeys[iMovieKey].nfpk;
			float nrpk = m_SMovieKeys[iMovieKey].nrpk;
			pChvrMainPort[0]->SaveKey(&m_SMovieKeys[iMovieKey]);
			m_SMovieKeys[iMovieKey].nfpk = nfpk;
			m_SMovieKeys[iMovieKey].nrpk = nrpk;

			m_SMovieKeys[iMovieKey].angletolerance = dlgIDQ.m_fPresentationAngleTolerance;
			m_SMovieKeys[iMovieKey].icoltolerance  = dlgIDQ.m_iPresentationValueTolerance;
			m_SMovieKeys[iMovieKey].vrtolerance    = dlgIDQ.m_fPresentationVoxelSize;
			m_SMovieKeys[iMovieKey].nplanes        = (float)dlgIDQ.m_iNPresentationPlanes;

			pChvrMainPort[0]->GetLUT32irgb(	&m_SMovieKeySluts[iMovieKey].iNCnots,
											 m_SMovieKeySluts[iMovieKey].iCind,
											 m_SMovieKeySluts[iMovieKey].fRed,
											 m_SMovieKeySluts[iMovieKey].fGrn,
											 m_SMovieKeySluts[iMovieKey].fBlu    );

			pChvrMainPort[0]->GetLUT32ia(	&m_SMovieKeySluts[iMovieKey].iNAnots,
											 m_SMovieKeySluts[iMovieKey].iAind,
											 m_SMovieKeySluts[iMovieKey].fAlp    );

			CString csText;
			int n = m_CListMovieKeys.GetTextLen( iList );
			m_CListMovieKeys.GetText( iList, csText.GetBuffer(n) );
			sprintf(str, "%s-m", (LPCSTR)csText);
			m_CListMovieKeys.DeleteString(iList);
			m_CListMovieKeys.InsertString(iList, str);
			UpdateData(FALSE);
		}

		if(iPopup == 3) {    // Delete this movie key
			m_iNMovieKeys--;
			for(j=iMovieKey; j<m_iNSavedKeys; j++) {
				memcpy(&m_SMovieKeys[j], &m_SMovieKeys[j+1], sizeof(m_SMovieKeys[0]));
				memcpy(&m_SMovieKeySluts[j], &m_SMovieKeySluts[j+1], sizeof(m_SMovieKeySluts[0]));
			}
			if(iMovieKey != 0) {
				m_CListMovieKeys.DeleteString(iList);
				m_CListMovieKeys.DeleteString(iList-1);
			}
			else {
				m_CListMovieKeys.DeleteString(iList+1);
				m_CListMovieKeys.DeleteString(iList);
			}
			m_SMovieKeys[m_iNMovieKeys].nfpk = 0;
		}
		if(iPopup == 4) {    // Set ALL keys to Current Field
			int iKey, iField, iTime;
			CString csHVfile;
			for(iKey=0; iKey<m_iNMovieKeys; iKey++) {
				csHVfile.Format("%s", m_SMovieKeys[iKey].hvname);
				if(FindFieldAndTime(csHVfile, &iField, &iTime) >= 0) {
					sprintf((char *)m_SMovieKeys[iKey].hvname, "%s%s", cDirPath[iTime], cHVlist[iTime]);
					pChvrMainPort[0]->GetLUT32irgb(	&m_SMovieKeySluts[iKey].iNCnots,
													 m_SMovieKeySluts[iKey].iCind,
													 m_SMovieKeySluts[iKey].fRed,
													 m_SMovieKeySluts[iKey].fGrn,
													 m_SMovieKeySluts[iKey].fBlu    );

					pChvrMainPort[0]->GetLUT32ia(	&m_SMovieKeySluts[iKey].iNAnots,
													 m_SMovieKeySluts[iKey].iAind,
													 m_SMovieKeySluts[iKey].fAlp    );

				} else {
					MessageBox("Could not find HVfile in any field associated with this project");
				}

			}

		}
	}
}


void CHvr_mfcDlg::OnChangeEditFpk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
}

void CHvr_mfcDlg::OnChangeEditRpk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	/*char str[100];*/
	UpdateData(TRUE);
//	sprintf(str, "# Rotations Per Frame = %f\n", m_fNrpk);
//	MessageBox(str, NULL, MB_OK);
	
}

void CHvr_mfcDlg::LoadProjectInfo()
{
	FILE *fp;
	char line[256];
	char *keyword;
	static char *seps = " ,;\t\n";
	char cmapname[256], amapname[256];
	int nc;
	int i;
	int match( char *, char *, int );
	HRESULT hr;
	CFileDialog myFileDialog(TRUE);

	iNDataFiles = 0;
	fp = fopen(m_ProjectFile, "r");
	if(fp != NULL) {
		while ( fgets(line,256,fp) != NULL ) {
			if ( line[0] == '#' ) continue;
			nc = strlen(line);
			keyword = strtok( line,seps );
			nc = strlen(keyword);
			if (!nc) continue;

			if ( match(keyword,"LUTfiles",nc) ) {
				strncpy( amapname, strtok(NULL,seps),256 );
				strncpy( cmapname, strtok(NULL,seps),256 );
				hr = pChvrMainPort[0]->SetLUT((unsigned char *)amapname, (unsigned char *)cmapname);
				if(FAILED(hr)) {
					AfxMessageBox("SetLUT failed.", MB_ICONSTOP);		
					hr = pChvrMainPort[0]->Release();
					CoUninitialize();
					exit(0);
				}
			}
			else if ( match(keyword,"HVfile",nc) ) {
				strncpy(  cHVlist[iNDataFiles], strtok(NULL,seps),80 );
				strncpy( cDirPath[iNDataFiles], strtok(NULL,seps),80 );
				iNDataFiles++;
			}
		}
		fclose(fp); 

		char cDir[256], cPath[256];
		nc = strlen("current.hvp");
		strcpy(cPath, m_ProjectFile);
		if(match(cPath, "current.hvp", nc) ) {
			GetCurrentDirectory(256, cDir);
			hr = pChvrMainPort[0]->SetCurrentWorkingDir((unsigned char *)cDir);
		} else {
			nc = strlen(cPath);
//			MessageBox(cPath);
			while((int)cPath[nc] != (int)'/'  &&  (int)cPath[nc] != (int)'\\'  && nc > 0) { nc--; }
			cPath[nc] = '\0';
//			MessageBox(cPath);
			strcpy(cDir, "C:\\users/dhp/hvrDCOM/data");
			hr = pChvrMainPort[0]->SetCurrentWorkingDir((unsigned char *)cDir);
			SetCurrentDirectory( cDir );
//			MessageBox("after");
		}
		m_CListDataFiles.SetCurSel(m_iChosenTime);
		m_CListFields.SetCurSel(m_iChosenField);

	} else {
//		MessageBox("No Project Selected.  Creating A Test Pattern Project");
		sprintf( cHVlist[iNDataFiles], "test_pattern");
		sprintf(cDirPath[iNDataFiles], "./");
		iNDataFiles++;
		sprintf( cHVlist[iNDataFiles], "end");
		m_SLUTs[0].iNAnots = 3;
		m_SLUTs[0].iAind[0] =   0;   m_SLUTs[0].fAlp[0] = 0.;
		m_SLUTs[0].iAind[1] = 127;   m_SLUTs[0].fAlp[1] = 1.;
		m_SLUTs[0].iAind[2] = 255;   m_SLUTs[0].fAlp[2] = 1.;

		m_SLUTs[0].iNCnots = 6;
		m_SLUTs[0].iCind[0] =   0;     m_SLUTs[0].fRed[0] = 0.;    m_SLUTs[0].fGrn[0] = 0.;    m_SLUTs[0].fBlu[0] = 0.;
		m_SLUTs[0].iCind[1] = 127;     m_SLUTs[0].fRed[1] = 0.;    m_SLUTs[0].fGrn[1] = 1.;    m_SLUTs[0].fBlu[1] = 1.;
		m_SLUTs[0].iCind[2] = 159;     m_SLUTs[0].fRed[2] = 0.;    m_SLUTs[0].fGrn[2] = 0.;    m_SLUTs[0].fBlu[2] = 1.;
		m_SLUTs[0].iCind[3] = 191;     m_SLUTs[0].fRed[3] = 0.;    m_SLUTs[0].fGrn[3] = 1.;    m_SLUTs[0].fBlu[3] = 0.;
		m_SLUTs[0].iCind[4] = 221;     m_SLUTs[0].fRed[4] = 1.;    m_SLUTs[0].fGrn[4] = 0.;    m_SLUTs[0].fBlu[4] = 0.;
		m_SLUTs[0].iCind[5] = 255;     m_SLUTs[0].fRed[5] = 1.;    m_SLUTs[0].fGrn[5] = 1.;    m_SLUTs[0].fBlu[5] = 0.;

		pChvrMainPort[0]->SetLUTia(		m_SLUTs[0].iNAnots,
										m_SLUTs[0].iAind,
										m_SLUTs[0].fAlp    );

		pChvrMainPort[0]->SetLUTirgb(	m_SLUTs[0].iNCnots,
										m_SLUTs[0].iCind,
										m_SLUTs[0].fRed,
										m_SLUTs[0].fGrn,
										m_SLUTs[0].fBlu    );

		dlgEditLUT.SetLUTfromHVRwork(m_SLUTs[0]);

	}
	sprintf( cHVlist[iNDataFiles], "end");
	m_iNBobs = iNDataFiles;

	m_CListDataFiles.ResetContent();
	for(i=0; i<iNDataFiles; i++) { m_CListDataFiles.AddString(cHVlist[i]); }

	dlgEditProject.m_iNFields = 0;
	m_CListFields.ResetContent();
}

void CHvr_mfcDlg::OnSelchangeListDatafiles() 
{
	StopRendering();

	m_iChosenTime = m_CListDataFiles.GetCurSel();
	char cHVfile[256];
	sprintf(cHVfile, "%s%s", cDirPath[m_iChosenTime], cHVlist[m_iChosenTime]);
	pChvrMainPort[0]->Set_HVname((unsigned char *)cHVfile);
	DoQualityFrame();   // was pChvrMainPort[0]->SetDoRender()
}

void CHvr_mfcDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CDialog::OnRButtonDown(nFlags, point);
}

void CHvr_mfcDlg::OnRButtonUp(UINT nFlags, CPoint point) 
{
	CDialog::OnRButtonUp(nFlags, point);
}

void CHvr_mfcDlg::OnStaticViewControl() 
{
	// TODO: Add your control notification handler code here
}

void CHvr_mfcDlg::OnRadioCf() 
{
	UpdateData(TRUE);
	dlgView.m_iMouseMode = m_iMouseMode;
}

void CHvr_mfcDlg::OnRadioCe() 
{
	UpdateData(TRUE);
	dlgView.m_iMouseMode = m_iMouseMode;
}

void CHvr_mfcDlg::OnRadioE() 
{
	UpdateData(TRUE);	
	dlgView.m_iMouseMode = m_iMouseMode;
}

void CHvr_mfcDlg::OnRadioTb() 
{
	UpdateData(TRUE);	
	dlgView.m_iMouseMode = m_iMouseMode;
}

UINT SpawnPresentationRendering( LPVOID pParam ){
	CHvr_mfcDlg* my_work = (CHvr_mfcDlg*)pParam;

	my_work->PresentationRendering();
    return 0;   // thread completed successfully
}

void CHvr_mfcDlg::DoQualityFrame()
{
	if(dlgDHosts.m_csRenderServer.Compare("localhost") == 0) {
		m_iStop = 0;
		AfxBeginThread(SpawnPresentationRendering, this);
	}
}

void CHvr_mfcDlg::OnButtonWriteFrame() 
{
	if(m_iAmRendering == 0) {
		m_iStop = 0;
		AfxBeginThread(SpawnPresentationRendering, this);
	} else {
		StopRendering();
	}
}

void CHvr_mfcDlg::PresentationRendering()
{
	int iNCluster, iIsWorking, i, i0, iRes, iResMin;
	Renderparams rp;
	SLutNots slutFrame;
	wchar_t* pwcStr=0;

	while(m_iAmRendering == 1) { _sleep(10); }

	if(dlgDHosts.m_csRenderServer.Compare("localhost") == 0) {
		// Number of servers in the cluster
		iNCluster = dlgDHosts.m_iNCols * dlgDHosts.m_iNRows;

		m_bcPQFrame.SetWindowText("STOP RENDERING");
		if(m_iDoStats == 1) { m_bcPQFrame.SetWindowText("STOP PDF"); }
		if(m_iDoStats == 2) { m_bcPQFrame.SetWindowText("STOP CORRELATION"); }
		m_iAmRendering = 1;

		// Get rendering parameters from local host
		pChvrMainPort[0]->SaveKey(&rp);

		// Make sure that the local server is up to date with a quick low res rendering
		rp.vrtolerance = ((float)0.01 + dlgIDQ.m_fVoxelSize);
		pChvrMainPort[0]->RestorKey(&rp);
		pChvrMainPort[0]->SetOption(L"BlockOnRender", L"1");
//		pChvrMainPort[0]->SetDoRender();   // Leave: this IS under DoQualityFrame
//		pChvrMainPort[0]->SetDoRender();   // Leave: this IS under DoQualityFrame

		// Set rendering to high quality
		rp.angletolerance = dlgIDQ.m_fPresentationAngleTolerance;
		rp.icoltolerance  = dlgIDQ.m_iPresentationValueTolerance;
		rp.vrtolerance    = dlgIDQ.m_fPresentationVoxelSize;
		rp.nplanes        = (float)dlgIDQ.m_iNPresentationPlanes;
		pChvrMainPort[0]->RestorKey(&rp);

		XferLocalKeyInfoToCluster();

		i0 = 0;
		if(dlgDHosts.m_iHostIsUp[1] == 1){ i0 = 1; }

		// Set blocking and buffer settings on all servers to presentation quality
		pChvrMainPort[0]->SetOption(L"BlockOnRender", L"0");
		for(i=0; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
			if(m_iNBuffers == 2) { pChvrMainPort[i]->SetOption(L"NRenderingBuffers", L"2"); }
			else                 { pChvrMainPort[i]->SetOption(L"NRenderingBuffers", L"1"); }		
		}}

		// RENDER frames, sequentially approching presentation quality
		iRes    = (int)((float)0.01 + dlgIDQ.m_fVoxelSize);
		iResMin = (int)((float)0.01 + dlgIDQ.m_fPresentationVoxelSize);
		if(m_iNBuffers != 2) { iRes = iResMin; }
		while(iRes >= iResMin  &&  m_iStop == 0) {
			rp.vrtolerance = (float)iRes;
			pChvrMainPort[0]->RestorKey(&rp);
			XferLocalKeyInfoToCluster();
			for(i=i0; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
				if(m_iDoStats == 1) { pChvrMainPort[i]->SetOption(L"Stats", L"pdf"); }
				if(m_iDoStats == 2) {
					pChvrMainPort[i]->SetOption(L"Stats", L"cross");
					SetCrossInfo(i);
				}
				pChvrMainPort[i]->SetDoRender();   // Leave: this IS under DoQualityFrame
			}}
			iIsWorking = 1;
			while(iIsWorking == 1) {
				iIsWorking = 0;
				for(i=i0; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
					pChvrMainPort[i]->GetStatus(&pwcStr);
					if(wcscmp(pwcStr, L"WORKING") == 0) { iIsWorking = 1; }
					CoTaskMemFree(pwcStr);
				}}
				_sleep(100);
			}
			iRes = iRes / 2; 
		}

		// RESET blocking and buffer settings on all servers to interactive
		pChvrMainPort[0]->SetOption(L"BlockOnRender", L"1");
		for(i=0; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
			if(m_iNBuffers == 3) { pChvrMainPort[i]->SetOption(L"NRenderingBuffers", L"2"); }		
		}}

		// RESET rendering paramets to interactive quality
		rp.angletolerance = dlgIDQ.m_fAngleTolerance;
		rp.icoltolerance  = dlgIDQ.m_iValueTolerance;
		rp.vrtolerance    = dlgIDQ.m_fVoxelSize;
		rp.nplanes        = (float)dlgIDQ.m_iNPlanes;
		pChvrMainPort[0]->RestorKey(&rp);
		m_iAmRendering = 0;
		m_iDoStats = 0;
		m_bcPQFrame.SetWindowText("Do Presentation Quality Frame");
	} else {
		// Make sure that only one remote rendering is done at a time
		if(m_iRemoteRendering == 1) {
			MessageBox("A remote rendering is already in progress");
			return;
		}
		m_iRemoteRendering = 1;
		m_bcPQFrame.SetWindowText("REMOTE RENDERING IN PROGRESS");
		char str[256];
		sprintf(str, "Rendering Submitted To Remote Host: %s", (LPCSTR)dlgDHosts.m_csRenderServer);
		MessageBox(str);
		// Setup timer
		CTimeStamp tsMine;
		tsMine.SetOutputFileName("GetPixTimeStamp.txt");
		sprintf(str, "Connected to server: %s", (LPCSTR)dlgDHosts.m_csRenderServer);
		tsMine.StampTime(str);

		// Coinitialize remote HVR server and get pointer to it.
		Ihvr_work *pChvrServer;
		MULTI_QI mqi[] = { {&IID_Ihvr_work, NULL, S_OK} };
		COSERVERINFO csi = {0, NULL, NULL, 0};
		wchar_t wcServer[256];
		swprintf(wcServer, L"%hs", (LPCSTR)dlgDHosts.m_csRenderServer);
		csi.pwszName = (LPWSTR)wcServer;
		HRESULT hr = CoCreateInstanceEx(CLSID_hvr_work, NULL, CLSCTX_SERVER, &csi, 
									   sizeof(mqi)/sizeof(mqi[0]), mqi);
		if(FAILED(hr)) {
			AfxMessageBox("CoCreateInstanceEx failed for Ihvr_work.", MB_ICONSTOP);
			m_iRemoteRendering = 0;
			m_bcPQFrame.SetWindowText("Do Presentation Quality Frame");
			return;
		}
		pChvrServer = (Ihvr_work *)(mqi[0].pItf);

		// Set Viewing Frustum on remote server
		float fUp[3], fNorm[3], fCent[3], fWidth, fFOV, Pid180;
		int iWidth, iHeight;

		iWidth  = dlgDispCont.m_iDisplayWidth;
		iHeight = dlgDispCont.m_iDisplayHeight;
		fFOV    = dlgDispCont.m_fDisplayFOV;
		fCent[0] = 0.;    fUp[0] = 0.;    fNorm[0] = 0.;
		fCent[1] = 1.;    fUp[1] = 0.;    fNorm[1] = 1.;
		fCent[2] = 0.;    fUp[2] = 1.;    fNorm[2] = 0.;
		Pid180 = (float)(3.141592654/180.);
		fWidth = (float)2.0 * ((float)iWidth / (float)iHeight) * (float)tan( Pid180* fFOV * 0.5 );

		pChvrServer->SetFrustum(fCent, fUp, fNorm, iWidth, iHeight, fWidth);

		// Initialize openGL window on remote
		pChvrServer->StartUp();
		if(FAILED(hr)) {
			AfxMessageBox("HVR server startup failed.", MB_ICONSTOP);
			pChvrServer->Release();
			m_iRemoteRendering = 0;
			m_bcPQFrame.SetWindowText("Do Presentation Quality Frame");
			return;
		}

		// Get color LUT info from local server
		pChvrMainPort[0]->GetLUT32irgb(	&slutFrame.iNCnots,
										 slutFrame.iCind,
										 slutFrame.fRed,
										 slutFrame.fGrn,
										 slutFrame.fBlu    );

		pChvrMainPort[0]->GetLUT32ia(	&slutFrame.iNAnots,
										 slutFrame.iAind,
										 slutFrame.fAlp    );

		// Set color LUT on remote server
		pChvrServer->SetLUTia(	slutFrame.iNAnots,
								slutFrame.iAind,
								slutFrame.fAlp    );

		pChvrServer->SetLUTirgb(slutFrame.iNCnots,
								slutFrame.iCind,
								slutFrame.fRed,
								slutFrame.fGrn,
								slutFrame.fBlu    );

		// Set option to use palet for faster rendering
//		wchar_t wcKey[30]   = L"UsePalet";
//		wchar_t wcValue[10] = L"TRUE";
//		pChvrServer->SetOption(wcKey, wcValue);

		// Get viewing geometry from local server
		Renderparams rp;
		pChvrMainPort[0]->SaveKey(&rp);
		rp.angletolerance = dlgIDQ.m_fPresentationAngleTolerance;
		rp.icoltolerance  = dlgIDQ.m_iPresentationValueTolerance;
		rp.vrtolerance    = dlgIDQ.m_fPresentationVoxelSize;
		rp.nplanes        = (float)dlgIDQ.m_iNPresentationPlanes;

		// Map full path to HV file from local server space to remote server space
		int i, inc, iMatch, GetTail(char *str, char *tail);
		char cBobTail[256];
		inc = GetTail((char *)rp.hvname, cBobTail);
		for(i=0; i<iNDataFiles; i++) {
			if(strncmp(cHVlist[i], cBobTail, inc) == 0 ) { iMatch = i; }
		}
		sprintf((char *)rp.hvname, "%s%s", cRemDirPath[iMatch], cHVlist[iMatch]);

		// Set viewing geometry on remote server
		pChvrServer->RestorKey(&rp);

		tsMine.StampTime("Finished sending inputs");

		// Set remote renderer to work in single buffer mode
		pChvrServer->SetOption(L"NRenderingBuffers", L"1");

		// Render on remote server (timing things from gui side
		pChvrServer->SetDoRender();         // Leave: Rendering on remote server
		tsMine.StampTime("Finished Rendering");

		// Make sure the LOCAL rendering thread is free
		if(m_iAmRendering == 1) {
			m_iStop = 1;
			while(m_iAmRendering == 1) { _sleep(10); }
		}
		MessageBox("Will Display Remotely Rendered Image NOW");

		// Get pixel data from remote server and paste onto local server's view
		BinaryDataHVR bdPix;
		pChvrServer->GetPix(&bdPix);
		sprintf(str, "Finished GetPix: moved %d bytes", bdPix.m_lSize);
		tsMine.StampTime(str);
		pChvrMainPort[0]->PutPix(bdPix.m_lSize, bdPix.m_pBuffer);
		tsMine.StampTime("Finished PutPix to local host");
		CoTaskMemFree(bdPix.m_pBuffer);
		tsMine.StampTime("Finished CoTaskMemFree");

		// Release remote server object
		pChvrServer->ClearIt();
		tsMine.StampTime("Finished Remote Clear of OpenGL");
		pChvrServer->Release();
		tsMine.StampTime("Finished Release of pointer");
		tsMine.WriteToFile();

		m_bcPQFrame.SetWindowText("Do Presentation Quality Frame");
		m_iRemoteRendering = 0;
	}
}

int CHvr_mfcDlg::LoadPowerWallConfig(char* sFileName)
{
//	FILE* fp;
//	fpPWfile = fopen(sFileName, "r");
	return 0;
}

void CHvr_mfcDlg::OnClearPath() 
{
	iNExFrames = 0;
	m_iNMovieKeys = 0;
	m_CListMovieKeys.ResetContent();
}

void CHvr_mfcDlg::OnChangeEditOpacity() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

	UpdateData(TRUE);

	pChvrMainPort[0]->SetOpacity(m_Opacity);
}

void CHvr_mfcDlg::OnChangeEditRQuality() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	dlgIDQ.m_fPresentationAngleTolerance = m_fRenderingQuality;

}

void CHvr_mfcDlg::OnReleasedcaptureSliderFarClip(NMHDR* pNMHDR, LRESULT* pResult) 
{
	StopRendering();

	UpdateData(TRUE);
	m_iNearLimit = 100 - m_iFarClip;
	CalculateAndSetNearFarClipping();

	DoQualityFrame();

	*pResult = 0;
}

void CHvr_mfcDlg::OnReleasedcaptureSliderNearClip(NMHDR* pNMHDR, LRESULT* pResult) 
{
	StopRendering();

	UpdateData(TRUE);
	CalculateAndSetNearFarClipping();

	DoQualityFrame();

	*pResult = 0;
}

void CHvr_mfcDlg::CalculateAndSetNearFarClipping()
{
	float fNear, fFar;
	float fFarrCent, fNearCent, fCentEyeDist, x, y, z;
	Renderparams RendParams;

	pChvrMainPort[0]->SaveKey(&RendParams);

	x = RendParams.centerX - RendParams.eyeX;
	y = RendParams.centerY - RendParams.eyeY;
	z = RendParams.centerZ - RendParams.eyeZ;
	fCentEyeDist = (float)sqrt(x*x + y*y + z*z);

	fFarrCent = (float)exp(log(10.) * (0.04*(double)m_iFarClip   - 3.0));
	fNearCent = (float)exp(log(10.) * (0.04*(double)(100-m_iNearLimit) - 3.0));

	if(fNearCent > (float)0.7 * fCentEyeDist) {
		fNearCent = (float)0.9 * fCentEyeDist;
		m_iNearLimit = 100 - (int)( 0.5 + (3.0 + log((double)fNearCent)/log(10.))/0.04 );
	}
	fNear = fCentEyeDist - fNearCent;
	fFar  = fCentEyeDist + fFarrCent;

	pChvrMainPort[0]->SetNearFarClip(fNear, fFar);

	UpdateData(FALSE);
}

void CHvr_mfcDlg::OnMenuMainOpen() 
{
	CFileDialog myFileDialog(TRUE);

	myFileDialog.m_ofn.lpstrFilter = "HV Project Files (*.hvp)\0*.hvp\0\0";

	if(myFileDialog.DoModal() == IDOK) {	
		strcpy(m_ProjectFile, (LPCSTR)myFileDialog.GetPathName());
		if(m_ProjectFile != "") {
			dlgEditProject.m_csProjectFile = myFileDialog.GetPathName();
			dlgEditProject.m_iNFields = 0;
			dlgEditProject.LoadProjectFromFile();

			m_CListFields.ResetContent();
			int iField;
			for(iField=0; iField<dlgEditProject.m_iNFields; iField++) {
				m_CListFields.AddString((LPCTSTR)dlgEditProject.m_csFieldNames[iField]);
			}

			char cDir[256];
			GetCurrentDirectory(256, cDir);
			pChvrMainPort[0]->SetCurrentWorkingDir((unsigned char *)cDir);

			m_iChosenField = -1;
			LoadFieldInfo(1);

			if(dlgEditProject.m_csMoviePathFile.Compare("none") != 0) {
				m_iUseProjName = 1;
				OnMenuFileLoadMoviePath();
				m_iUseProjName = 0;
			}

			if(dlgEditProject.m_csKeyFrameFile.Compare("none") != 0) {
				m_iUseProjName = 1;
				OnMenuFileLoadKeyframes();
				m_iUseProjName = 0;
			}
		}
	}
}

void CHvr_mfcDlg::OnMenuDisplayEdit() 
{
/*****************************************************************
 *                    Reset Display                              *
 *****************************************************************/
	float fUp[3], fNorm[3], fCent[3], fWidth, fFOV, Pid180;
	int iWidth, iHeight;

	if(dlgDispCont.DoModal() == IDOK) {
		StopRendering();

		Renderparams rp;
		pChvrMainPort[0]->SaveKey(&rp);
		pChvrMainPort[0]->ClearIt();
		pChvrMainPort[0]->Release();

		iWidth  = dlgDispCont.m_iDisplayWidth;
		iHeight = dlgDispCont.m_iDisplayHeight;
		fFOV    = dlgDispCont.m_fDisplayFOV;
		fCent[0] = 0.;    fUp[0] = 0.;    fNorm[0] = 0.;
		fCent[1] = 1.;    fUp[1] = 0.;    fNorm[1] = 1.;
		fCent[2] = 0.;    fUp[2] = 1.;    fNorm[2] = 0.;
		Pid180 = (float)(3.141592654/180.);
		fWidth = (float)2.0 * ((float)iWidth / (float)iHeight) * (float)tan( Pid180* fFOV * 0.5 );

		SetWindowPos(&wndTop, iWidth+6+2, 2, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
		dlgView.SetWindowPos(&wndTop, 2, 2, iWidth+6, iHeight+26, SWP_DRAWFRAME);

		if(InitializeHVRserver() == 0) {
			MessageBox("CoCreateInstanceEx failed to create Ihvr_work in OnMenuDisplayEdit.",
						"Unrecoverable Error", MB_ICONSTOP | MB_OK);
			exit(0);
		}

		int iWnd = (int) dlgView.m_hWnd;
		pChvrMainPort[0]->SetFrustum(fCent, fUp, fNorm, iWidth, iHeight, fWidth);
		pChvrMainPort[0]->Set_hWnd(iWnd);
		pChvrMainPort[0]->RestorKey(&rp);
		dlgEditLUT.SetLUTirgba();
		pChvrMainPort[0]->StartUp();

		MessageBox("Resizing window and resetting options.", "Information",  MB_OK);

//		dhp - if version with paletted texture by default do this
		OnMenuColorsUsePalett();

		DoQualityFrame();   //  was: pChvrMainPort[0]->SetDoRender();
	}
}

void CHvr_mfcDlg::OnMenuEditLut() 
{
	dlgEditLUT.CreateOnce();
/*
	if(dlgEditLUT.m_iAmCreated == 0) {
		dlgEditLUT.Create(IDD_DIALOG_GRAPH_LUT, this);
		dlgEditLUT.InitPlots();
		dlgEditLUT.m_iAmCreated = 1;
	}
	dlgEditLUT.ShowWindow(SW_SHOW);
	dlgEditLUT.DrawPlots();
*/
}

void CHvr_mfcDlg::OnMenuMainNewProject()
{
	char cOldProjectFile[256];
	sprintf(cOldProjectFile, "%s", (LPCTSTR)dlgEditProject.m_csProjectFile);

	if(dlgEditProject.DoModal() == IDOK) {
		m_CListFields.ResetContent();
		int iField;
		for(iField=0; iField<dlgEditProject.m_iNFields; iField++) {
			m_CListFields.AddString((LPCTSTR)dlgEditProject.m_csFieldNames[iField]);
		}

		m_iChosenField = -1;
		LoadFieldInfo(1);
	} else {
		dlgEditProject.m_csProjectFile.Format("%s", cOldProjectFile);
		dlgEditProject.m_iNFields = 0;
		if(dlgEditProject.m_csProjectFile.Compare("none") != 0) {
			dlgEditProject.LoadProjectFromFile();
		}
	}
}

int CHvr_mfcDlg::LoadFieldInfo(int iResetLUTs)
{
	FILE *fp;
	char line[256];
	char *keyword;
	static char *seps = " ,;\t\n";
	int nc, i, iNRDataFiles;
	int match( char *, char *, int );

	StopRendering();

	// IF   there is a new set of fields,
	// THEN read in names of HVfiles for all fields up front ending with field 0
	// ELSE just read list of local HV files for the chosen field
	if(m_iChosenField < 0) {
		int iField;
		for(iField = dlgEditProject.m_iNFields-1; iField >= 0; iField--) {
			iNDataFiles = LoadOneField(iField);
			for(i=0; i<iNDataFiles; i++) { sprintf(cHVlists[iField][i], "%s", cHVlist[i]); }
			iNDataFiless[iField] = iNDataFiles;
		}
		m_iChosenField = 0;
		m_iChosenTime  = 0;
	} else {
		// Read list of local HV files
		iNDataFiles = LoadOneField(m_iChosenField);
		if(m_iChosenTime >= iNDataFiles) {
			// could not find a corresponding time
			m_iChosenTime = 0;
		}
	}

	if(iNDataFiles != 0) {
		m_iNBobs = iNDataFiles;
		m_CListDataFiles.ResetContent();
		for(i=0; i<iNDataFiles; i++) { m_CListDataFiles.AddString(cHVlist[i]); }
	}
	m_CListDataFiles.SetCurSel(m_iChosenTime);
	m_CListFields.SetCurSel(m_iChosenField);
	UpdateData(FALSE);
/*
	fp = fopen((LPCSTR)dlgEditProject.m_csFieldFiles[m_iChosenField], "r");
	if(fp != NULL) {
		while ( fgets(line, 256, fp) != NULL ) {
			if ( line[0] == '#' ) continue;
			nc = strlen(line);
			keyword = strtok( line,seps );
			nc = strlen(keyword);
			if (!nc) continue;

			else if ( match(keyword,"HVfile",nc) ) {
				strncpy(  cHVlist[iNDataFiles], strtok(NULL,seps), 256 );
				strncpy( cDirPath[iNDataFiles], strtok(NULL,seps), 256 );
				iNDataFiles++;
			}
		}
		fclose(fp);
		sprintf( cHVlist[iNDataFiles], "end");
		m_iNBobs = iNDataFiles;

		m_CListDataFiles.ResetContent();
		for(i=0; i<iNDataFiles; i++) { m_CListDataFiles.AddString(cHVlist[i]); }
	}
*/
	// Read list of remote HV files
	iNRDataFiles = 0;
	CString csRootName;
	char cStr[256];
	csRootName = dlgEditProject.m_csFieldFiles[m_iChosenField].SpanExcluding(".");
	char cFile[256];
	sprintf(cFile, "%s.fldremote", (LPCSTR)csRootName);
	fp = fopen(cFile, "r");
	if(fp != NULL) {
		while ( fgets(line, 256, fp) != NULL ) {
			if ( line[0] == '#' ) continue;
			nc = strlen(line);
			keyword = strtok( line,seps );
			nc = strlen(keyword);
			if (!nc) continue;

			else if ( match(keyword,"RHVfile",nc) ) {
				strncpy(  cStr, strtok(NULL,seps), 256 );
				strncpy( cRemDirPath[iNRDataFiles], strtok(NULL,seps), 256 );
				strncpy( cRemHost[iNRDataFiles], strtok(NULL,seps), 256 );
				iNRDataFiles++;
			}
		}
		fclose(fp);

		if(iNRDataFiles != iNDataFiles) {
			sprintf(cStr, "# of LOCAL HV files = %d  but  # of Remote HV files = %d",
				iNDataFiles, iNRDataFiles);
			MessageBox(cStr, "WARNING", MB_ICONWARNING | MB_OK);
		}

		dlgDHosts.m_csQueueHost.Format("%s", cRemHost[0]);
	} else {
		for(iNRDataFiles=0; iNRDataFiles<iNDataFiles; iNRDataFiles++) {
			strncpy( cRemDirPath[iNRDataFiles], cDirPath[iNRDataFiles], 256 );
			sprintf(cRemHost[iNRDataFiles], (LPCSTR)dlgDHosts.m_csQueueHost);
		}
	}

	// Set ticks for current field
	SetLutTicks();

	if(iResetLUTs == 1) {
		// Read in and use Color LUT info
		dlgEditLUT.ReadLUTfile((LPCSTR)dlgEditProject.m_csLUTFiles[m_iChosenField]);
		dlgEditLUT.SetLUTirgba();
		if(dlgEditLUT.m_iAmCreated == 1) { dlgEditLUT.DrawPlots(); }

		// Render new data
		char cHVfile[256];
		sprintf(cHVfile, "%s%s", cDirPath[m_iChosenTime], cHVlist[m_iChosenTime]);
		pChvrMainPort[0]->Set_HVname((unsigned char *)cHVfile);
		dlgEditLUT.SetLUTirgba();
		DoQualityFrame();         // was: pChvrMainPort[0]->SetDoRender();
	}

	return iNDataFiles;
}

void CHvr_mfcDlg::OnMenuMainBobs()
{
	if(dlgGetBobs.DoModal() == IDOK) {
		if(dlgGetBobs.m_csProjectFile != "") {
			dlgEditProject.m_csProjectFile = dlgGetBobs.m_csProjectFile;

			dlgEditProject.m_iNFields = 0;
			dlgEditProject.LoadProjectFromFile();
			m_CListFields.ResetContent();
			int iField;
			for(iField=0; iField<dlgEditProject.m_iNFields; iField++) {
				m_CListFields.AddString((LPCTSTR)dlgEditProject.m_csFieldNames[iField]);
			}

			char cDir[256];
			GetCurrentDirectory(256, cDir);
			pChvrMainPort[0]->SetCurrentWorkingDir((unsigned char *)cDir);

			m_iChosenField = -1;
			LoadFieldInfo(1);
		}
	}
}

UINT SpawnMakeMovie( LPVOID pParam ){

	CHvr_mfcDlg* my_work = (CHvr_mfcDlg*)pParam;

	my_work->MakeMovie();

    return 0;   // thread completed successfully
}

void CHvr_mfcDlg::OnButtonMakeMovie() 
{
//	m_bMakeMovie = TRUE;
//	OnButtonPreviewMovie();
//	m_bMakeMovie = FALSE;

	if(m_bMakeMovie == TRUE) {
		m_iStop = 1;
	} else {
		m_iStop = 0;
		AfxBeginThread(SpawnMakeMovie, this);
		dlgAbortBox.m_iOnFrame = 0;
		dlgAbortBox.m_iTotalFrames = 0;
		int i = dlgAbortBox.DoModal();
		StopRendering();
		m_iStop = 1;
	}
}

void CHvr_mfcDlg::MakeMovie()
{
	// Check to see if the number of buffers is different between presentation and interactive
	UINT state = pCMainMenu->GetMenuState(IDR_MENU_OPTIONS_PRESENTATION_SINGLE, MF_BYCOMMAND);
	ASSERT(state != 0xFFFFFFFF);

	// Set number of buffers to be 1 if need be
	if (state & MF_CHECKED) {
		wchar_t wcKey[30]   = L"NRenderingBuffers";
		wchar_t wcValue[10] = L"1";
		pChvrMainPort[0]->SetOption(wcKey, wcValue);
	}

	// Here is where the rendering actually gets done
	m_bMakeMovie = TRUE;
	OnButtonPreviewMovie();
	m_bMakeMovie = FALSE;

	// Set number of buffers back to 2 if need be
	if (state & MF_CHECKED) {
		wchar_t wcKey[30]   = L"NRenderingBuffers";
		wchar_t wcValue[10] = L"2";
		pChvrMainPort[0]->SetOption(wcKey, wcValue);
	}
}

void CHvr_mfcDlg::OnButtonPreviewMovie() 
{
	int KeysToHvrIn(char DirPath[3000][80], char HVlist[3000][80],
					 struct Renderparams Keys[64], struct SLutNots SlutKeys[64], char *movnam, bool bLoop);
	int nMovieFrames, im;
	int rend_dump_params(struct Renderparams *rp, FILE *fp, char *movnam, int im);
	bool bLoop;
	BinaryDataHVR bdPix;
	FILE *fp;
	char cMovieFile[256], cMGFile[256];
	CString csHVfile;
	int iOldField;
	int iIsWorking;
	wchar_t* pwcStr=0;

	StopRendering();

	m_iStop = 0;
	m_iAmRendering = 1;

	csHVfile.Format("%s", m_SMovieKeys[0].hvname);
	iOldField = m_iChosenField;
	if(FindFieldAndTime(csHVfile, &m_iChosenField, &m_iChosenTime) >= 0) {
		if(m_iChosenField != iOldField) { LoadFieldInfo(0); }
		m_CListFields.SetCurSel(m_iChosenField);
		m_CListDataFiles.SetCurSel(m_iChosenTime);
		UpdateData(FALSE);
	} else {
		MessageBox("Could not find HVfile in any field associated with this project");
	}

	sprintf(m_cMovieName, "%s", m_csHVname);
	if(m_bLoopOverData) { bLoop = TRUE; } else { bLoop = FALSE; }

	if(iNExFrames > 0) {
		nMovieFrames = ExPathToHvrIn(cDirPath);
	} else {
		nMovieFrames = KeysToHvrIn(cDirPath, cHVlist, m_SMovieKeys, m_SMovieKeySluts, m_cMovieName, bLoop);
	}

	if(nMovieFrames <= 0) {
		MessageBox("Failed to interpolate path with these keys",
			"Preview Error",MB_ICONEXCLAMATION | MB_OK);
		pChvrMainPort[0]->SetOption(L"BlockOnRender", L"1");
		m_iAmRendering = 0;
		return;
	}

//	pChvrMainPort[0]->SetRenderQuality(6, 0.001, 0.1);
//	pChvrMainPort[0]->SetRenderQuality(dlgIDQ.m_iValueTolerance,dlgIDQ.m_fVoxelSize,dlgIDQ.m_fAngleTolerance);

//	char str[256];	
//	sprintf(str, "nMovieFrames=%d", nMovieFrames);
//	MessageBox(str);

	if(m_bMakeMovie) {
		CFileDialog dlgFile(TRUE);
		dlgFile.m_ofn.lpstrTitle = "CHOOSE Directory and Name of File for Movie\0";
		if(dlgFile.DoModal() != IDOK) {
			pChvrMainPort[0]->SetOption(L"BlockOnRender", L"1");
			m_iAmRendering = 0;
			return;
		}
		sprintf(cMovieFile, "%s", (LPCSTR)dlgFile.GetPathName());
		sprintf(cMGFile, "%s.mg", cMovieFile);
		fp = fopen(cMGFile, "w");
		fprintf(fp, "localhost %s %4d %4d %5d\n",	cMovieFile,
													dlgDispCont.m_iDisplayWidth,
													dlgDispCont.m_iDisplayHeight,
													nMovieFrames                  );
		fclose(fp);

		fp = fopen(cMovieFile, "wb");

		dlgAbortBox.m_iOnFrame = 0;
		dlgAbortBox.m_iTotalFrames = nMovieFrames;
		dlgAbortBox.UpdateData(FALSE);
//		dlgAbortBox.Invalidate():
	}

	if(m_bMakeMovie) { pChvrMainPort[0]->SetOption(L"BlockOnRender", L"0"); }
	for(im=0; im < nMovieFrames; im++) {
		if(m_bMakeMovie) {
			Movieframes[im].angletolerance = dlgIDQ.m_fPresentationAngleTolerance;
			Movieframes[im].vrtolerance    = dlgIDQ.m_fPresentationVoxelSize;
			Movieframes[im].icoltolerance  = dlgIDQ.m_iPresentationValueTolerance;
			Movieframes[im].nplanes        = (float)dlgIDQ.m_iNPresentationPlanes;
		} else {
			Movieframes[im].angletolerance = dlgIDQ.m_fAngleTolerance;
			Movieframes[im].vrtolerance    = dlgIDQ.m_fVoxelSize;
			Movieframes[im].icoltolerance  = dlgIDQ.m_iValueTolerance;
			Movieframes[im].nplanes        = (float)dlgIDQ.m_iNPlanes;
		}

		pChvrMainPort[0]->RestorKey(&Movieframes[im]);

		pChvrMainPort[0]->SetLUTia(		MovieSluts[im].iNAnots,
										MovieSluts[im].iAind,
										MovieSluts[im].fAlp    );

		pChvrMainPort[0]->SetLUTirgb(	MovieSluts[im].iNCnots,
										MovieSluts[im].iCind,
										MovieSluts[im].fRed,
										MovieSluts[im].fGrn,
										MovieSluts[im].fBlu    );

		dlgEditLUT.SetLUTfromHVRwork(MovieSluts[im]);
		if(dlgEditLUT.m_iAmCreated == 1) { dlgEditLUT.DrawPlots(); }

		pChvrMainPort[0]->SetDoRender();  // Leave: we are rendering a movie
		iIsWorking = 1;
		while(iIsWorking == 1) {
			_sleep(10);
			iIsWorking = 0;
			pChvrMainPort[0]->GetStatus(&pwcStr);
			if(wcscmp(pwcStr, L"WORKING") == 0) { iIsWorking = 1; }
			CoTaskMemFree(pwcStr);
		}

		if(m_bMakeMovie) {
			// Get pixel data from hvr_server and write to file
			pChvrMainPort[0]->GetPix(&bdPix);
			fwrite(bdPix.m_pBuffer, sizeof(char), bdPix.m_lSize, fp);
			CoTaskMemFree(bdPix.m_pBuffer);

			if(m_iStop == 0) {
				dlgAbortBox.m_iOnFrame++;
				dlgAbortBox.UpdateData(FALSE);
			}
		}

		if(m_iStop == 1) { im = nMovieFrames + 1; }
	}
	if(m_bMakeMovie) {
		fclose(fp);

		Renderparams rp;
		pChvrMainPort[0]->SaveKey(&rp);
		rp.angletolerance = dlgIDQ.m_fAngleTolerance;
		rp.icoltolerance  = dlgIDQ.m_iValueTolerance;
		rp.vrtolerance    = dlgIDQ.m_fVoxelSize;
		rp.nplanes        = (float)dlgIDQ.m_iNPlanes;
		pChvrMainPort[0]->RestorKey(&rp);
	}
	pChvrMainPort[0]->SetOption(L"BlockOnRender", L"1");
	m_iAmRendering = 0;
}

void CHvr_mfcDlg::OnSelchangeListFields() 
{
	int i;
	int iPopup, iList;
	CPoint point;
	RECT rList, rItem;

	CMenu menu;
	menu.CreatePopupMenu();
	menu.AppendMenu(MF_STRING, 1, "Display this field");
	menu.AppendMenu(MF_STRING, 2, "Select as Y-field");

	i = m_CListFields.GetCurSel();
	iList = i;
	m_CListFields.GetWindowRect(&rList);			// Get screen ccords of list box
	m_CListFields.GetItemRect(iList, &rItem);		// Get offset to item in list box
	point.x = rItem.right + rList.left;
	point.y = rItem.top  + rList.top;

	iPopup = menu.TrackPopupMenu(TPM_RETURNCMD | TPM_LEFTALIGN,
		 point.x, point.y, AfxGetMainWnd());


	if(iPopup == 1) {
		int iDada      = m_CListDataFiles.GetCurSel();
		m_iChosenField = m_CListFields.GetCurSel();
		LoadFieldInfo(1);
	}

	if(iPopup == 2) {
		m_iYField = m_CListFields.GetCurSel();
		m_CListFields.ResetContent();
		int iField;
		char cYFieldStr[256];
		for(iField=0; iField<dlgEditProject.m_iNFields; iField++) {
			if(iField != m_iYField) {
				m_CListFields.AddString((LPCTSTR)dlgEditProject.m_csFieldNames[iField]);
			} else {
				sprintf(cYFieldStr, "%s  (Y)", (LPCTSTR)dlgEditProject.m_csFieldNames[iField]);
				m_CListFields.AddString(cYFieldStr);
			}
		}

		m_CListFields.SetCurSel(m_iChosenField);
	}
}

void CHvr_mfcDlg::OnDblclkListFields() 
{
	int iDada      = m_CListDataFiles.GetCurSel();
	m_iChosenField = m_CListFields.GetCurSel();
	LoadFieldInfo(1);
}

void CHvr_mfcDlg::OnMenuDisplayInteractivedisplayQuality() 
{
	if(dlgIDQ.DoModal() == IDOK) {
		StopRendering();

		Renderparams rp;
		pChvrMainPort[0]->SaveKey(&rp);
		rp.angletolerance = dlgIDQ.m_fAngleTolerance;
		rp.icoltolerance  = dlgIDQ.m_iValueTolerance;
		rp.vrtolerance    = dlgIDQ.m_fVoxelSize;
		rp.nplanes        = (float)dlgIDQ.m_iNPlanes;
		pChvrMainPort[0]->RestorKey(&rp);
		pChvrMainPort[0]->SetDoRender();   // Leave this because we want to see Interactive Quality

		m_fRenderingQuality = dlgIDQ.m_fPresentationAngleTolerance;
		UpdateData(FALSE);
	}
}

void CHvr_mfcDlg::OnMenuDisplayHosts() 
{
	int i;
	dlgDHosts.m_iNCols = dlgDispCont.m_iNPanelHoriz;
	dlgDHosts.m_iNRows = dlgDispCont.m_iNPanelVert;

	dlgDHosts.m_iNFrusta = dlgDispCont.m_iNMovieFrusta;
	for(i=0; i<dlgDispCont.m_iNMovieFrusta; i++) {
		memcpy(&dlgDHosts.m_SFrusta[i+1].fCent, &dlgDispCont.m_SMovieFrusta[i].fCent,
			sizeof(CDisplayHosts::Frustum));
	}
	dlgDHosts.InitializeHostList();
	if(dlgDHosts.DoModal() == IDOK) {
	}
}

void CHvr_mfcDlg::OnMenuColorsUsePalett() 
{
	StopRendering();
	wchar_t wcKey[10]   = L"UsePalet";
	wchar_t wcValue[10] = L"TRUE";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	DoQualityFrame();    // was: pChvrMainPort[0]->SetDoRender()
	pCMainMenu->CheckMenuItem(IDR_MENU_COLORS_USE_PALETT, MF_CHECKED  );
	pCMainMenu->CheckMenuItem(IDR_MENU_COLORS_USE_RGBA,   MF_UNCHECKED);
}

void CHvr_mfcDlg::OnMenuColorsUseRgba() 
{
	StopRendering();
	wchar_t wcKey[10]   = L"UsePalet";
	wchar_t wcValue[10] = L"FALSE";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	DoQualityFrame();    // was:pChvrMainPort[0]->SetDoRender()
	pCMainMenu->CheckMenuItem(IDR_MENU_COLORS_USE_PALETT, MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_COLORS_USE_RGBA,   MF_CHECKED  );
}
/*
	ON_COMMAND(IDR_MENU_COLORS_USE_PALETT, OnMenuColorsUsePalett)
	ON_COMMAND(IDR_MENU_COLORS_USE_RGBA, OnMenuColorsUseRgba)
	ON_COMMAND(IDR_MENU_OPTIONS_TIMERS_ON, OnMenuOptionsTimersOn)
	ON_COMMAND(IDR_MENU_OPTIONS_TIMERS_OFF, OnMenuOptionsTimersOff)

	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_TIMERS_ON, 1);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_TIMERS_OFF,0);
	pCMainMenu->CheckMenuItem(IDR_MENU_COLORS_USE_PALETT, 0);
	pCMainMenu->CheckMenuItem(IDR_MENU_COLORS_USE_RGBA,   1);


*/
void CHvr_mfcDlg::OnMenuOptionsTimersOn() 
{
	wchar_t wcKey[10]   = L"TimersOn";
	wchar_t wcValue[10] = L"1";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_TIMERS_ON,  MF_CHECKED );
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_TIMERS_OFF, MF_UNCHECKED);
}

void CHvr_mfcDlg::OnMenuOptionsTimersOff() 
{
	wchar_t wcKey[10]   = L"TimersOn";
	wchar_t wcValue[10] = L"0";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_TIMERS_ON,  MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_TIMERS_OFF, MF_CHECKED  );
}

void CHvr_mfcDlg::OnMenuOptionsTimersFile() 
{
	CFileDialog myFileDialog(TRUE);

	myFileDialog.m_ofn.lpstrFilter = "Performance Time Output File (*.pto)\0*.pto\0\0";

	if(myFileDialog.DoModal() == IDOK) {
		char cFile[256];
		wchar_t wcKey[64]   = L"TimerOutputFile";
		wchar_t wcValue[256];
		strcpy(cFile, (LPCSTR)myFileDialog.GetPathName());
		sscanf(cFile, "%ls", wcValue);
		pChvrMainPort[0]->SetOption(wcKey, wcValue);
	}
}

void CHvr_mfcDlg::OnMenuOptionsBufioOn() 
{
	wchar_t wcKey[20]   = L"BufferedIO";
	wchar_t wcValue[10] = L"1";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_BUFIO_ON,  MF_CHECKED );
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_BUFIO_OFF, MF_UNCHECKED);
}

void CHvr_mfcDlg::OnMenuOptionsBufioOff() 
{
	wchar_t wcKey[20]   = L"BufferedIO";
	wchar_t wcValue[10] = L"0";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_BUFIO_ON,  MF_UNCHECKED );
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_BUFIO_OFF, MF_CHECKED);
}

void CHvr_mfcDlg::OnMenuOptionsSingleBuffer() 
{
	wchar_t wcKey[30]   = L"NRenderingBuffers";
	wchar_t wcValue[10] = L"1";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SINGLE_BUFFER, MF_CHECKED        );
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_DOUBLE_BUFFER, MF_UNCHECKED      );	
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_PRESENTATION_SINGLE, MF_UNCHECKED);
	m_iNBuffers = 1;
}

void CHvr_mfcDlg::OnMenuOptionsDoubleBuffer() 
{
	wchar_t wcKey[30]   = L"NRenderingBuffers";
	wchar_t wcValue[10] = L"2";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SINGLE_BUFFER, MF_UNCHECKED      );
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_DOUBLE_BUFFER, MF_CHECKED        );	
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_PRESENTATION_SINGLE, MF_UNCHECKED);
	m_iNBuffers = 2;
}

void CHvr_mfcDlg::OnMenuOptionsPresentationSingle() 
{
	wchar_t wcKey[30]   = L"NRenderingBuffers";
	wchar_t wcValue[10] = L"2";
	pChvrMainPort[0]->SetOption(wcKey, wcValue);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SINGLE_BUFFER, MF_UNCHECKED    );
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_DOUBLE_BUFFER, MF_UNCHECKED    );
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_PRESENTATION_SINGLE, MF_CHECKED);
	m_iNBuffers = 3;
}

void CHvr_mfcDlg::OnMenuOptionsShowLut() 
{
	StopRendering();

	UINT state = pCMainMenu->GetMenuState(IDR_MENU_OPTIONS_SHOW_LUT, MF_BYCOMMAND);
	ASSERT(state != 0xFFFFFFFF);

	if (state & MF_CHECKED) {
		pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SHOW_LUT, MF_UNCHECKED | MF_BYCOMMAND);
		pChvrMainPort[0]->SetOption(L"ShowColorBar", L"0");
		pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SHOW_TICKS, MF_UNCHECKED | MF_BYCOMMAND);
		pChvrMainPort[0]->SetOption(L"ClearTicks", L"0");
	} else {
		pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SHOW_LUT, MF_CHECKED | MF_BYCOMMAND);
		pChvrMainPort[0]->SetOption(L"ShowColorBar", L"1");
	}
	DoQualityFrame();    // was: pChvrMainPort[0]->SetDoRender()
}

void CHvr_mfcDlg::OnMenuOptionsShowTicks() 
{
	StopRendering();

	UINT state = pCMainMenu->GetMenuState(IDR_MENU_OPTIONS_SHOW_TICKS, MF_BYCOMMAND);
	ASSERT(state != 0xFFFFFFFF);

	if (state & MF_CHECKED) {
		pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SHOW_TICKS, MF_UNCHECKED | MF_BYCOMMAND);
		pChvrMainPort[0]->SetOption(L"ClearTicks", L"0");
	} else {
		pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SHOW_LUT, MF_CHECKED | MF_BYCOMMAND);
		pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SHOW_TICKS, MF_CHECKED | MF_BYCOMMAND);
		pChvrMainPort[0]->SetOption(L"ShowColorBar", L"1");
		SetLutTicks();
	}
	DoQualityFrame();    // was: pChvrMainPort[0]->SetDoRender()
}

void CHvr_mfcDlg::SetLutTicks()
{
	FILE *fp;
	wchar_t wcTick[128];
	char cTickIndex[4], cTickValue[128], cError[256];
	int iCount;

	pChvrMainPort[0]->SetOption(L"ClearTicks", L"0");

	UINT state = pCMainMenu->GetMenuState(IDR_MENU_OPTIONS_SHOW_TICKS, MF_BYCOMMAND);
	ASSERT(state != 0xFFFFFFFF);
	if (state & MF_CHECKED) {
		if(0 != dlgEditProject.m_csTickFiles[m_iChosenField].Compare("none")) {
			fp = fopen((LPCSTR)dlgEditProject.m_csTickFiles[m_iChosenField], "r");
			if(fp != NULL) {
				iCount = 0;
				while(fscanf(fp, "%s%s", cTickIndex, cTickValue) > 1  &&  iCount < 128) {
					swprintf(wcTick, L"%3hs %hs", cTickIndex, cTickValue);
					pChvrMainPort[0]->SetOption(L"AddTick", wcTick);
					iCount++;
				}
				fclose(fp);
				if(iCount == 0) {
					sprintf(cError, "WARNING: Failed to read tick mark information from file: %s",
						(LPCSTR)dlgEditProject.m_csTickFiles[m_iChosenField]);
					MessageBox(cError);
				}
			} else {
				sprintf(cError, "WARNING: Failed to open tick file: %s",
					(LPCSTR)dlgEditProject.m_csTickFiles[m_iChosenField]);
				MessageBox(cError);
			}
		} else {
			MessageBox("WARNING: No tick file specified for this field");
		}
	}
}

void CHvr_mfcDlg::OnMenuViewEdit() 
{
	dlgEditView.GetViewFromServer();
	dlgEditView.m_fNearLim = (float)exp(log(10.) * (0.04*(double)(100-m_iNearLimit) - 3.0));

	if(dlgEditView.DoModal() == IDOK) { }
	m_iNearLimit = 100 - (int)( 0.5 + (3.0 + log((double)dlgEditView.m_fNearLim)/log(10.))/0.04 );
	m_iFarClip   =       (int)( 0.5 + (3.0 + log((double)dlgEditView.m_fNearFar)/log(10.))/0.04 );

	if(m_iNearLimit <   1) { m_iNearLimit =   1; }
	if(m_iNearLimit > 100) { m_iNearLimit = 100; }
	if(m_iFarClip <   0) { m_iFarClip =   0; }
	if(m_iFarClip > 100) { m_iFarClip = 100; }
	UpdateData(FALSE);
}

void CHvr_mfcDlg::OnMenuFileSaveImage() 
{
	void write_bmp_file(int width, int height, unsigned char *image, char file[256]);
	CFileDialog myFileDialog(FALSE);
	char file[256];

	BinaryDataHVR bdPix;
	pChvrMainPort[0]->GetPix(&bdPix);

	myFileDialog.m_ofn.lpstrFilter = "BMP files (*.bmp)\0*.bmp\0\0";

	if(myFileDialog.DoModal() == IDOK) {	
		strcpy(file, (LPCSTR)myFileDialog.GetPathName());
		if(file != "") {
			write_bmp_file(dlgDispCont.m_iDisplayWidth,dlgDispCont.m_iDisplayHeight,
							bdPix.m_pBuffer, file);
		}
	}
	CoTaskMemFree(bdPix.m_pBuffer);
}

int CHvr_mfcDlg::InitializeHVRserver()
{
	// Instantiate and get a pointer to a local hvr_server object
	//
	MULTI_QI mqi[] = { {&IID_Ihvr_work, NULL, S_OK} };
	COSERVERINFO csi = {0, L"localhost", NULL, 0};
	HRESULT hr = CoCreateInstanceEx(CLSID_hvr_work, NULL, CLSCTX_SERVER, &csi, 
                                   sizeof(mqi)/sizeof(mqi[0]), mqi);
	if(FAILED(hr)) {
		AfxMessageBox("CoCreateInstanceEx failed for Ihvr_work.", MB_ICONSTOP);
		return 1;
	}
	pChvrMainPort[0] = (Ihvr_work *)(mqi[0].pItf);

	dlgView.SetHVRport(pChvrMainPort[0]);
	dlgEditLUT.SetHVRport(pChvrMainPort[0]);
	dlgEditView.pChvrMainPort[0] = pChvrMainPort[0];
	dlgDHosts.m_iHostIsUp[0] = 1;

	// Set Options Menu to reflect INITIAL values of hvr_server settings
	//
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_TIMERS_ON, MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_TIMERS_OFF,MF_CHECKED  );
	pCMainMenu->CheckMenuItem(IDR_MENU_COLORS_USE_PALETT, MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_COLORS_USE_RGBA,   MF_CHECKED  );
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_BUFIO_ON,  MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_BUFIO_OFF, MF_CHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SINGLE_BUFFER, MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_DOUBLE_BUFFER, MF_CHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_PRESENTATION_SINGLE, MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SHOW_LUT, MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_OPTIONS_SHOW_TICKS, MF_UNCHECKED);
	pCMainMenu->CheckMenuItem(IDR_MENU_TIME_ADVANCE, MF_UNCHECKED);
	m_iNBuffers = 2;
	m_iTimeAdvance = 0;

	return 1;
}

void CHvr_mfcDlg::OnCheckLoopOverData() 
{
	UpdateData(TRUE);
}

void CHvr_mfcDlg::OnOK()
{
//	OnExit();
}

UINT SpawnTimeAdvance( LPVOID pParam ){

	CHvr_mfcDlg* my_work = (CHvr_mfcDlg*)pParam;

	my_work->TimeAdvance();

    return 0;   // thread completed successfully
}


void CHvr_mfcDlg::OnMenuTimeAdvance() 
{
	if(m_iTimeAdvance == 0) {
		pCMainMenu->CheckMenuItem(IDR_MENU_TIME_ADVANCE, MF_CHECKED);
		m_iTimeAdvance = 1;
		AfxBeginThread(SpawnTimeAdvance, this);
	} else {
		pCMainMenu->CheckMenuItem(IDR_MENU_TIME_ADVANCE, MF_UNCHECKED);
		m_iTimeAdvance = 0;
	}
}

void CHvr_mfcDlg::TimeAdvance()
{
	int iData, iDataMax, iTimeMax, iMaxTimeExists, iSleepNms;
	int iSleep0, iSleep1, iDT0, iDT1, iDT;
	float fSlope;
	static int iTime;
	char cHVfile[256];
	FILE *fp;

	StopRendering();

	// GET current file and max number of files
	UpdateData(TRUE);
	iTime = m_iChosenTime;
	iDataMax = m_CListDataFiles.GetCount();
	if(iTime < 0  ||  iTime >= iDataMax) { iTime = 0; }

	// CHECK to see if current time number file exists
	// If it exists, get a max time to start with
	iMaxTimeExists = 0;
	fp = fopen("Max_Time", "r");
	if(fp != NULL) {
		iMaxTimeExists = 1;
		fscanf(fp, "%d", &iTimeMax);
		fclose(fp);
	} else {
		iTimeMax = iTime + 200;
	}

	// Wait until max time 
	if(iMaxTimeExists == 1) {
		while(iTime > iTimeMax  &&  m_iTimeAdvance == 1) {
			fp = fopen("Max_Time", "r");
			fscanf(fp, "%d", &iTimeMax);
			fclose(fp);
			_sleep(200);
		}
	}

	// Will run untill time advance is stopped by user
	// Will start at current file and loop to beginning of list at last file
	while(m_iTimeAdvance == 1) {

		// Render data at frame iTime
		iData = iTime % iDataMax;
		sprintf(cHVfile, "%s%s", cDirPath[iData], cHVlist[iData]);
		pChvrMainPort[0]->Set_HVname((unsigned char *)cHVfile);
		pChvrMainPort[0]->SetDoRender();    // Leave: continuous play mode

		// IF there's a max time, get it's latest value
		if(iMaxTimeExists == 1) {
			fp = fopen("Max_Time", "r");
			fscanf(fp, "%d", &iTimeMax);
			fclose(fp);
		} else {
			iTimeMax = iTime + 200;
		}

		// SLEEP more if you are running out of frames
		iSleep0 = 200;
		iSleep1 = 10;
		iDT0 = 5;
		iDT1 = 30;
		iDT = iTimeMax-iTime;
		if(iDT >= iDT1) {
			iSleepNms = iSleep1;
		} else {
			if(iDT < iDT0) {
				iSleepNms = iSleep0;
			} else {
				fSlope = (float)(iSleep1-iSleep0)/(float)(iDT1-iDT0);
				iSleepNms = iSleep0 + (int)((float)(iDT-iDT0) * fSlope);
			}
		}
		_sleep(iSleepNms);


		iTime++;
		// IF there is a max time file, make sure iTIme never exceeds iTimeMax
		if(iMaxTimeExists == 1) {
			while(iTime > iTimeMax) {
				fp = fopen("Max_Time", "r");
				fscanf(fp, "%d", &iTimeMax);
				fclose(fp);
				_sleep(200);
			}
		}
	}

	m_CListDataFiles.SetCurSel(iData);
	m_iChosenTime = iData;
	UpdateData(FALSE);
}

void CHvr_mfcDlg::OnMenuFileSavekeyframes() 
{
	int rend_dump_params(struct Renderparams *rp, FILE *fp, char *movnam, int im);
	CFileDialog myFileDialog(FALSE);
	FILE *fp;
	int i, j, idoit;
	char cFile[256];

	UpdateData(TRUE);

	if(m_iNSavedKeys <= 0) {
		if(m_iUseProjName == 0) { MessageBox("There are no KeyFrames to save.", "WARNING", MB_ICONEXCLAMATION); }
		return;
	}

	myFileDialog.m_ofn.lpstrFilter = "KeyFrame File (*.keys)\0*.keys\0All Files (*.*)\0*.*\0\0";

	if(m_iUseProjName == 0) {
		if(myFileDialog.DoModal() == IDOK) {
			sprintf(cFile, "%s", (LPCSTR)myFileDialog.GetPathName());
			idoit = 1;
		} else {
			idoit = 0;
		}
	} else {
		sprintf(cFile, "%s.keys", dlgEditProject.m_csProjectFile.SpanExcluding("."));
		dlgEditProject.m_csKeyFrameFile.Format("%s", cFile);
		idoit = 1;
	}

	if(idoit == 1) {
		fp = fopen(cFile, "w");
		for(i=0; i<m_iNSavedKeys; i++) {
			fprintf(fp, "#NOTS_AC: %3d %3d\n", m_SLUTs[i].iNAnots, m_SLUTs[i].iNCnots);
			for(j=0; j<m_SLUTs[i].iNAnots; j++) {
				fprintf(fp, "Anot:     %3d %f\n", m_SLUTs[i].iAind[j], m_SLUTs[i].fAlp[j]);
			}
			for(j=0; j<m_SLUTs[i].iNCnots; j++) {
				fprintf(fp, "Cnot:     %3d %f %f %f\n", m_SLUTs[i].iCind[j], m_SLUTs[i].fRed[j],
														m_SLUTs[i].fGrn[j],  m_SLUTs[i].fBlu[j]);
			}
			rend_dump_params(&m_SSavedKeys[i], fp,"foo", 0);
			fprintf(fp, "# NEXT KEY\n");
		}

		fprintf(fp, "#NOTS_AC: %3d %3d\n", 0, 0);   // Marks end of KeyFrame list
		fclose(fp);
	}

	UpdateData(FALSE);
}

void CHvr_mfcDlg::OnMenuFileLoadKeyframes() 
{
	int rend_load_from_file(struct Renderparams *Rp, FILE *fp);
	CFileDialog myFileDialog(TRUE);
	FILE *fp;
	int i, j, idoit;
	char str[256], cFile[256];

	UpdateData(TRUE);

	myFileDialog.m_ofn.lpstrFilter = "KeyFrame File (*.keys)\0*.keys\0All Files (*.*)\0*.*\0\0";

	if(m_iUseProjName == 0) {
		if(myFileDialog.DoModal() == IDOK) {
			sprintf(cFile, "%s", (LPCSTR)myFileDialog.GetPathName());
			idoit = 1;
		} else {
			idoit = 0;
		}
	} else {
		sprintf(cFile, "%s", dlgEditProject.m_csKeyFrameFile);
		idoit = 1;
	}

	if(idoit == 1) {
		fp = fopen(cFile, "r");
		i = m_iNSavedKeys;
		fscanf(fp, "#NOTS_AC: %3d %3d\n", &m_SLUTs[i].iNAnots, &m_SLUTs[i].iNCnots);
		while(m_SLUTs[i].iNAnots > 0) {

			// Read in Color and Alpha LUTs
			for(j=0; j<m_SLUTs[i].iNAnots; j++) {
				fscanf(fp, "Anot:     %3d %f\n", &m_SLUTs[i].iAind[j], &m_SLUTs[i].fAlp[j]);
			}
			for(j=0; j<m_SLUTs[i].iNCnots; j++) {
				fscanf(fp, "Cnot:     %3d %f %f %f\n", &m_SLUTs[i].iCind[j], &m_SLUTs[i].fRed[j],
													   &m_SLUTs[i].fGrn[j],  &m_SLUTs[i].fBlu[j]);
			}

			// Read in view and data file info
			rend_load_from_file(&m_SSavedKeys[i], fp);

			// Add pointer to keyframe in listbox
			sprintf(str, "Key%03d", i);
			m_CListKeys.AddString(str);

			// Check for next key
			i++;
			m_SLUTs[i].iNAnots = 0;
			fscanf(fp, "#NOTS_AC: %3d %3d\n", &m_SLUTs[i].iNAnots, &m_SLUTs[i].iNCnots);
		}
		fclose(fp);
		m_iNSavedKeys = i;
	}

	UpdateData(FALSE);
}

//	m_SMovieKeys[m_iNMovieKeys].vrtolerance     = 0.0;
//	memcpy(&m_SMovieKeySluts[m_iNMovieKeys].iNCnots, &m_SLUTs[iKey].iNCnots, sizeof(SLutNots));


void CHvr_mfcDlg::OnMenuFileSaveMoviePath() 
{
	int rend_dump_params(struct Renderparams *rp, FILE *fp, char *movnam, int im);
	CFileDialog myFileDialog(FALSE);
	FILE *fp;
	int i, j, idoit;
	char cFile[256];

	UpdateData(TRUE);
	sprintf(m_cMovieName, "%s", m_csHVname);

	if(m_iNMovieKeys <= 0) {
		if(m_iUseProjName == 0) { MessageBox("There is no movie path to save.", "WARNING", MB_ICONEXCLAMATION); }
		return;
	}

	myFileDialog.m_ofn.lpstrFilter = "Movie Path File File (*.path)\0*.path\0All Files (*.*)\0*.*\0\0";

	if(m_iUseProjName == 0) {
		if(myFileDialog.DoModal() == IDOK) {
			sprintf(cFile, "%s", (LPCSTR)myFileDialog.GetPathName());
			idoit = 1;
		} else {
			idoit = 0;
		}
	} else {
		sprintf(cFile, "%s.path", dlgEditProject.m_csProjectFile.SpanExcluding("."));
		dlgEditProject.m_csMoviePathFile.Format("%s", cFile);
		idoit = 1;
	}

	if(idoit == 1) {
		fp = fopen(cFile, "w");
		fprintf(fp, "Movie Name: %s\n", m_cMovieName);
		for(i=0; i<m_iNMovieKeys; i++) {
			fprintf(fp, "#NOTS_AC: %3d %3d\n", m_SMovieKeySluts[i].iNAnots, m_SMovieKeySluts[i].iNCnots);
			for(j=0; j<m_SMovieKeySluts[i].iNAnots; j++) {
				fprintf(fp, "Anot:     %3d %f\n", m_SMovieKeySluts[i].iAind[j], m_SMovieKeySluts[i].fAlp[j]);
			}
			for(j=0; j<m_SMovieKeySluts[i].iNCnots; j++) {
				fprintf(fp, "Cnot:     %3d %f %f %f\n", m_SMovieKeySluts[i].iCind[j], m_SMovieKeySluts[i].fRed[j],
														m_SMovieKeySluts[i].fGrn[j],  m_SMovieKeySluts[i].fBlu[j]);
			}
			rend_dump_params(&m_SMovieKeys[i], fp, m_cMovieName, 0);
			fprintf(fp, "# NEXT KEY\n");
		}

		fprintf(fp, "#NOTS_AC: %3d %3d\n", 0, 0);   // Marks end of the list of Movie Path keys
		fclose(fp);
	}

	UpdateData(FALSE);

}

void CHvr_mfcDlg::OnMenuFileLoadMoviePath() 
{
	int rend_load_from_file(struct Renderparams *Rp, FILE *fp);
	CFileDialog myFileDialog(TRUE);
	FILE *fp;
	int i, j, idoit;
	char str[256], cFile[256];

	UpdateData(TRUE);

	myFileDialog.m_ofn.lpstrFilter = "Movie Path File File (*.path)\0*.path\0All Files (*.*)\0*.*\0\0";

	if(m_iUseProjName == 0) {
		if(myFileDialog.DoModal() == IDOK) {
			sprintf(cFile, "%s", (LPCSTR)myFileDialog.GetPathName());
			idoit = 1;
		} else {
			idoit = 0;
		}
	} else {
		sprintf(cFile, "%s", dlgEditProject.m_csMoviePathFile);
		idoit = 1;
	}

	if(idoit == 1) {
		fp = fopen(cFile, "r");

		// Read in movie name
		fscanf(fp, "Movie Name: %s\n", m_cMovieName);
		m_csHVname.Format("%s", m_cMovieName);

		// Re-initialize movie key list box
		m_CListMovieKeys.ResetContent();
		m_iNMovieKeys = 0;
		i             = 0;
		fscanf(fp, "#NOTS_AC: %3d %3d\n", &m_SMovieKeySluts[i].iNAnots, &m_SMovieKeySluts[i].iNCnots);
		while(m_SMovieKeySluts[i].iNAnots > 0) {

			// Read in Color and Alpha LUTs
			for(j=0; j<m_SMovieKeySluts[i].iNAnots; j++) {
				fscanf(fp, "Anot:     %3d %f\n", &m_SMovieKeySluts[i].iAind[j], &m_SMovieKeySluts[i].fAlp[j]);
			}
			for(j=0; j<m_SMovieKeySluts[i].iNCnots; j++) {
				fscanf(fp, "Cnot:     %3d %f %f %f\n", &m_SMovieKeySluts[i].iCind[j], &m_SMovieKeySluts[i].fRed[j],
													   &m_SMovieKeySluts[i].fGrn[j],  &m_SMovieKeySluts[i].fBlu[j]);
			}

			// Read in view and HV data file info
			rend_load_from_file(&m_SMovieKeys[i], fp);

			// Add pointer in movie path listbox
			if(i > 0) {
				sprintf(str, "  #Frames:%d   #Rotations:%f", m_SMovieKeys[i].nfpk, m_SMovieKeys[i].nrpk);
				m_CListMovieKeys.AddString(str);
			}

			sprintf(str, "%s_%03d", m_cMovieName, i);
			m_CListMovieKeys.AddString(str);

			// Check for next key
			i++;
			m_SMovieKeys[i].nfpk = 0;
			m_SLUTs[i].iNAnots = 0;
			fscanf(fp, "#NOTS_AC: %3d %3d\n", &m_SMovieKeySluts[i].iNAnots, &m_SMovieKeySluts[i].iNCnots);
		}
		fclose(fp);
		m_iNMovieKeys = i;
	}

	UpdateData(FALSE);
}

void CHvr_mfcDlg::OnMenuFileSaveProject() 
{
	// CHECK to see if there is any project info to save based on project name having been set
	if(dlgEditProject.m_csProjectFile.Compare("none") == 0) {
		MessageBox("There is no project to save.", "WARNING", MB_OK | MB_ICONWARNING);
		return;
	}

	// Write out KeyFrame and MoviePath files, with names associated with this project
	m_iUseProjName = 1;
	OnMenuFileSavekeyframes();
	OnMenuFileSaveMoviePath();
	m_iUseProjName = 0;

	// Write out project info, including pointers to data, keyframes, and movie path
	dlgEditProject.SaveProjectToFile();

}

void CHvr_mfcDlg::OnMenuFileSaveProjectAs() 
{
	CFileDialog myFileDialog(FALSE);
	myFileDialog.m_ofn.lpstrFilter = "Hierarchical Volume Project File (*.hvp)\0*.hvp\0All Files (*.*)\0*.*\0\0";

	if(myFileDialog.DoModal() == IDOK) {
		dlgEditProject.m_csProjectFile.Format("%s", (LPCSTR)myFileDialog.GetPathName());
		OnMenuFileSaveProject();
	}
}

void CHvr_mfcDlg::SetMainWidgetsFromKey(Renderparams rp)
{
	m_Opacity = rp.opacity;
	m_fRenderingQuality = rp.angletolerance;
	dlgEditView.GetViewFromServer();
	m_iNearLimit = 100 - (int)( 0.5 + (3.0 + log((double)dlgEditView.m_fNearLim)/log(10.))/0.04 );
	m_iFarClip   =       (int)( 0.5 + (3.0 + log((double)dlgEditView.m_fNearFar)/log(10.))/0.04 );
	if(m_iNearLimit <   1) { m_iNearLimit =   1; }
	if(m_iNearLimit > 100) { m_iNearLimit = 100; }
	if(m_iFarClip <   0) { m_iFarClip =   0; }
	if(m_iFarClip > 100) { m_iFarClip = 100; }
	UpdateData(FALSE);
}

void CHvr_mfcDlg::DisplayKey(Renderparams rp, SLutNots lut)
{
	StopRendering();

	pChvrMainPort[0]->RestorKey(&rp);

	pChvrMainPort[0]->SetLUTia(		lut.iNAnots,
									lut.iAind,
									lut.fAlp    );

	pChvrMainPort[0]->SetLUTirgb(	lut.iNCnots,
									lut.iCind,
									lut.fRed,
									lut.fGrn,
									lut.fBlu    );

	dlgEditLUT.SetLUTfromHVRwork(lut);
	if(dlgEditLUT.m_iAmCreated == 1) {
			dlgEditLUT.DrawPlots();
			UpdateData(FALSE);
			dlgEditLUT.Invalidate();
	}

	SetMainWidgetsFromKey(rp);

	// Find and set the chosen field and time based on HVfile name
	CString csHVfile;
	csHVfile.Format("%s", rp.hvname);
/*
	int iend, i2;
	iend = csHVfile.ReverseFind('/');  // Find the 0 based characher index of the last directory delimiter
	i2   = csHVfile.ReverseFind('\\');
	if(i2 > iend) { iend = i2; }
	csHVfile.Delete(0, iend+1);        // Delete characters in name up to and including the last directory delimiter
*/
	if(FindFieldAndTime(csHVfile, &m_iChosenField, &m_iChosenTime) >= 0) {
		LoadFieldInfo(0);
		m_CListFields.SetCurSel(m_iChosenField);
		m_CListDataFiles.SetCurSel(m_iChosenTime);
		UpdateData(FALSE);
	}

	DoQualityFrame();  // was: pChvrMainPort[0]->SetDoRender()
}

int CHvr_mfcDlg::LoadOneField(int iNfield)
{
	FILE *fp;
	char line[256];
	char *keyword;
	static char *seps = " ,;\t\n";
	int nc, iNfiles;
	int match( char *, char *, int );

	// Read list of local HV files
	iNfiles = 0;
	fp = fopen((LPCSTR)dlgEditProject.m_csFieldFiles[iNfield], "r");
	if(fp != NULL) {
		while ( fgets(line, 256, fp) != NULL ) {
			if ( line[0] == '#' ) continue;
			nc = strlen(line);
			keyword = strtok( line,seps );
			nc = strlen(keyword);
			if (!nc) continue;

			else if ( match(keyword,"HVfile",nc) ) {
				strncpy(  cHVlist[iNfiles], strtok(NULL,seps), 256 );
				strncpy( cDirPath[iNfiles], strtok(NULL,seps), 256 );
				iNfiles++;
			}
		}
		fclose(fp);
		sprintf( cHVlist[iNfiles], "end");
	} else {
		char str[256];
		sprintf(str, "Failed to open field file: %s", (LPCSTR)dlgEditProject.m_csFieldFiles[iNfield]);
		MessageBox(str);
	}
	
	return iNfiles;
}

int CHvr_mfcDlg::FindFieldAndTime(CString csHVfile, int *iField, int *iTime)
{

	// Trim away full path from HV file name
	int iend, i2;
	iend = csHVfile.ReverseFind('/');  // Find the 0 based characher index of the last directory delimiter
	i2   = csHVfile.ReverseFind('\\');
	if(i2 > iend) { iend = i2; }
	csHVfile.Delete(0, iend+1);        // Delete characters in name up to and including the last directory delimiter

	// Try to find a name mach for the HVfile in any field in this project.
	// Start with the currently chosen field & loop around
	// Stop searching as soon as a match is found, or when you run out of fields
	int iFld, iTim, iFld1, iTim1, iCount;
	iFld = -1;
	iFld1 = m_iChosenField;
	iCount = 0;
	while(iFld < 0  &&  iCount < dlgEditProject.m_iNFields) {
		for(iTim1=0; iTim1<iNDataFiless[iFld1]; iTim1++) {
			if(csHVfile.Compare(cHVlists[iFld1][iTim1]) == 0) { iFld = iFld1; iTim = iTim1; }
		}
		iCount++;
		iFld1 = (iFld1+1) % dlgEditProject.m_iNFields;
	}
	// IF a match is found, set the found field and time in the passed addresses
	if(iFld >= 0) {
		*iField = iFld;
		*iTime  = iTim;
	}

	// IF a match is found, return field number > 0
	// IF a match is NOT found, return -1
	return iFld;
}


int CHvr_mfcDlg::StopRendering()
{
	int i;
	m_iStop = 1;
	for(i=0; i <= dlgDHosts.m_iNCols * dlgDHosts.m_iNRows; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
		pChvrMainPort[i]->StopRendering();
	}}
	while(m_iAmRendering == 1) { _sleep(10); }
	m_iStop = 0;

	return 0;
}

void CHvr_mfcDlg::OnMenuFileLoadExplicitPath() 
{
	FILE *fp;
	char line[256];
	char *keyword;
	static char *seps = " ,;\t\n";
	int nc, iFrame, iNframes;
	int match( char *, char *, int );
	float fTime;
	char cPath[256], cFile[256], cStr[256];
	CFileDialog dlgFile(TRUE);

	// Get name of file which contains an explicit movie path
	dlgFile.m_ofn.lpstrFilter = "Explicit Path File (*.epf)\0*.epf\0All Files (*.*)\0*.*\0\0";
	if(dlgFile.DoModal() == IDOK) {
		// Read in an explicit movie path
		sprintf(cPath, "%s", (LPCSTR)dlgFile.GetPathName());
		sprintf(cFile, "%s", (LPCSTR)dlgFile.GetFileName());
		iNframes = 0;
		fp = fopen(cPath, "r");
		if(fp != NULL) {
			while ( fgets(line, 256, fp) != NULL ) {
				if ( line[0] == '#' ) continue;
				nc = strlen(line);
				keyword = strtok( line,seps );
				nc = strlen(keyword);
				if (!nc) continue;

				else if ( match(keyword,"frame",nc) ) {
					iFrame = atoi ( strtok(NULL,seps) );

					sExPath[iFrame].eyex = (float) atof ( strtok(NULL,seps) );
					sExPath[iFrame].eyey = (float) atof ( strtok(NULL,seps) );
					sExPath[iFrame].eyez = (float) atof ( strtok(NULL,seps) );

					sExPath[iFrame].cntx = (float) atof ( strtok(NULL,seps) );
					sExPath[iFrame].cnty = (float) atof ( strtok(NULL,seps) );
					sExPath[iFrame].cntz = (float) atof ( strtok(NULL,seps) );

					sExPath[iFrame].upx = (float) atof ( strtok(NULL,seps) );
					sExPath[iFrame].upy = (float) atof ( strtok(NULL,seps) );
					sExPath[iFrame].upz = (float) atof ( strtok(NULL,seps) );

					fTime = (float)atof ( strtok(NULL,seps) );
					sExPath[iFrame].iTime = (int)fTime % m_CListDataFiles.GetCount();

					iNframes++;
				}
			}
			fclose(fp);
			iNExFrames = iNframes;

			// Warn user if no path was found
			if(iNExFrames == 0) {
				sprintf(cStr, "No Frames found in %s", cPath);
				MessageBox(cStr, "WARNING", MB_ICONWARNING | MB_OK);
			} else {
				// Update application and GUI about explicit movie path
				m_iNMovieKeys = 0;
				m_CListMovieKeys.ResetContent();
				sprintf(cStr, "%s : %d frames", cFile, iNExFrames);
				m_CListMovieKeys.AddString(cStr);
				fp = fopen("Debug_ExFramesInput.txt", "w");
				for(iFrame=0; iFrame<iNExFrames; iFrame++) {
					fprintf(fp, "%f %f %f   %f %f %f   %f %f %f   %d\n",
						sExPath[iFrame].eyex, sExPath[iFrame].eyey, sExPath[iFrame].eyez,
						sExPath[iFrame].cntx, sExPath[iFrame].cnty, sExPath[iFrame].cntz,
						sExPath[iFrame].upx,  sExPath[iFrame].upy,  sExPath[iFrame].upz,
						sExPath[iFrame].iTime											);
				}
				fclose(fp);
			}
		}
	}
}

int CHvr_mfcDlg::ExPathToHvrIn(char DirPath[][80])
{

	// 1) Grab current rendering parameters to be used as a template for all movie frames
	Renderparams rp;
	SLutNots ms;
	pChvrMainPort[0]->SaveKey(      &rp);
	pChvrMainPort[0]->GetLUT32irgb(	&ms.iNCnots, ms.iCind, ms.fRed, ms.fGrn, ms.fBlu);
	pChvrMainPort[0]->GetLUT32ia(	&ms.iNAnots, ms.iAind, ms.fAlp);

	// 2) Set movie name from dialog edit field
	sprintf((char *)rp.imagename, "%s000",	(LPCSTR)m_csHVname);

	// 3) Calculate fNearCent and fFarrCent for later use
	float fFarrCent, fNearCent, fCentEyeDist, x, y, z;
	x = rp.centerX - rp.eyeX;
	y = rp.centerY - rp.eyeY;
	z = rp.centerZ - rp.eyeZ;
	fCentEyeDist = (float)sqrt(x*x + y*y + z*z);
	fNearCent = fCentEyeDist - rp.my_near;
	fFarrCent = rp.my_far    - fCentEyeDist;

	// 4) Copy template into each movie frame and set individual parameters
	int i;
	for(i=0; i<iNExFrames; i++) {
		// 4a) copy template into movie frame
		memcpy(&Movieframes[i].opacity, &rp.opacity, sizeof(Renderparams));
		memcpy(&MovieSluts[i].iNCnots, &ms.iNCnots, sizeof(SLutNots));

		// 4b) set eye, center, and up vectors from explicit path
		Movieframes[i].eyeX = sExPath[i].eyex;
		Movieframes[i].eyeY = sExPath[i].eyey;
		Movieframes[i].eyeZ = sExPath[i].eyez
			;
		Movieframes[i].centerX = sExPath[i].cntx;
		Movieframes[i].centerY = sExPath[i].cnty;
		Movieframes[i].centerZ = sExPath[i].cntz
			;
		Movieframes[i].upX = sExPath[i].upx;
		Movieframes[i].upY = sExPath[i].upy;
		Movieframes[i].upZ = sExPath[i].upz;

		// 4c) set HV file path/name
		sprintf((char *)Movieframes[i].hvname, "%s%s", DirPath[sExPath[i].iTime], cHVlist[sExPath[i].iTime]);

		// 4d) set Near and far clipping planes
		float fNear, fFar;
		x = Movieframes[i].centerX - Movieframes[i].eyeX;
		y = Movieframes[i].centerY - Movieframes[i].eyeY;
		z = Movieframes[i].centerZ - Movieframes[i].eyeZ;
		fCentEyeDist = (float)sqrt(x*x + y*y + z*z);
		fNear = fCentEyeDist - fNearCent;
		fFar  = fCentEyeDist + fFarrCent;
		if(fNear < (float)0.1*fCentEyeDist) { fNear = (float)0.1*fCentEyeDist; }
		Movieframes[i].my_near = fNear;
		Movieframes[i].my_far  = fFar;
	}

	return iNExFrames;
}

void CHvr_mfcDlg::OnMenuStatsPDF() 
{
	StopRendering();
	m_iDoStats = 1;   //  will do PDF
	DoQualityFrame();
}

void CHvr_mfcDlg::OnMenuStatsCross() 
{

	// Make sure Y-Field is chosen
	if(m_iYField < 0) {
		MessageBox("You need to choose a Y-Field from the Fields list box to correlate against",
				   "IN ORDER FOR CROSS-CORRELATE TO WORK",
				   MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	StopRendering();

	// Load Y-Field info into arrays
	if(LoadOneFieldArg(m_iYField, cYDirPath, cYHVlist) != iNDataFiles) {
		MessageBox("Warning: X and Y Fields have different numbers of snapshots",
				   "MISMATCHED FIELDS",
					MB_ICONEXCLAMATION | MB_OK);
	}

//	SetCrossInfo(0);

	//Set HVR server to do cross-correlation
	m_iDoStats = 2;   //  will do Cross Correlate
	DoQualityFrame();
}

void CHvr_mfcDlg::SetCrossInfo(int iServer)
{
	int i, iCount;
	wchar_t wcValue[256];
	char cFile[256];
	FILE *fp;
	wchar_t wcTick[128];
	char cTickIndex[4], cTickValue[128];

	// Set Tick Marks
	pChvrMainPort[iServer]->SetOption(L"ClearXTicks", L"0");
	if(0 != dlgEditProject.m_csTickFiles[m_iChosenField].Compare("none")) {
		fp = fopen((LPCSTR)dlgEditProject.m_csTickFiles[m_iChosenField], "r");
		if(fp != NULL) {
			iCount = 0;
			while(fscanf(fp, "%s%s", cTickIndex, cTickValue) > 1  &&  iCount < 128) {
				swprintf(wcTick, L"%3hs %hs", cTickIndex, cTickValue);
				pChvrMainPort[iServer]->SetOption(L"AddXTick", wcTick);
				iCount++;
			}
			fclose(fp);
		}
	}
	pChvrMainPort[iServer]->SetOption(L"ClearYTicks", L"0");
	if(0 != dlgEditProject.m_csTickFiles[m_iYField].Compare("none")) {
		fp = fopen((LPCSTR)dlgEditProject.m_csTickFiles[m_iYField], "r");
		if(fp != NULL) {
			iCount = 0;
			while(fscanf(fp, "%s%s", cTickIndex, cTickValue) > 1  &&  iCount < 128) {
				swprintf(wcTick, L"%3hs %hs", cTickIndex, cTickValue);
				pChvrMainPort[iServer]->SetOption(L"AddYTick", wcTick);
				iCount++;
			}
			fclose(fp);
		}
	}

	// Set Y-Field HV data file in HVR server
	m_iChosenTime = m_CListDataFiles.GetCurSel();
	if(m_iChosenTime < 0) { m_iChosenTime = 0; }
	sprintf(cFile, "%s%s\0", cYDirPath[m_iChosenTime], cYHVlist[m_iChosenTime]);
	for(i=0; i < (int)strlen(cFile); i++) { if(cFile[i] == '/') { cFile[i] = '\\'; }}
	sscanf(cFile, "%ls\0", wcValue);
	pChvrMainPort[iServer]->SetOption(L"Yfile", wcValue);
}

int CHvr_mfcDlg::LoadOneFieldArg(int iNfield, char cPathList[][80], char cFileList[][80])
{
	FILE *fp;
	char line[256];
	char *keyword;
	static char *seps = " ,;\t\n";
	int nc, iNfiles;
	int match( char *, char *, int );

	// Read list of local HV files
	iNfiles = 0;
	fp = fopen((LPCSTR)dlgEditProject.m_csFieldFiles[iNfield], "r");
	if(fp != NULL) {
		while ( fgets(line, 256, fp) != NULL ) {
			if ( line[0] == '#' ) continue;
			nc = strlen(line);
			keyword = strtok( line,seps );
			nc = strlen(keyword);
			if (!nc) continue;

			else if ( match(keyword,"HVfile",nc) ) {
				strncpy( cFileList[iNfiles], strtok(NULL,seps), 256 );
				strncpy( cPathList[iNfiles], strtok(NULL,seps), 256 );
				iNfiles++;
			}
		}
		fclose(fp);
		sprintf( cHVlist[iNfiles], "end");
	} else {
		char str[256];
		sprintf(str, "Failed to open field file: %s",
			(LPCSTR)dlgEditProject.m_csFieldFiles[iNfield]);
		MessageBox(str);
	}
	
	return iNfiles;

}

void CHvr_mfcDlg::XferLocalKeyInfoToCluster()
{
	int iNCluster, i, iNAreUp;
	Renderparams rp;
	SLutNots slutFrame;
	wchar_t* pwcStr=0;
	char cLocalDir[256];
	CString csRemDir;


	// If no cluster servers are up, just return
	iNCluster = dlgDHosts.m_iNCols * dlgDHosts.m_iNRows;
	iNAreUp = 0;
	for(i=1; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
		iNAreUp++;
	}}
	if(iNAreUp == 0) { return; }

	// Get RenderParams info from local server
	pChvrMainPort[0]->SaveKey(&rp);

	// Get color LUT info from local server
	pChvrMainPort[0]->GetLUT32irgb(	&slutFrame.iNCnots,
									 slutFrame.iCind,
									 slutFrame.fRed,
									 slutFrame.fGrn,
									 slutFrame.fBlu    );

	pChvrMainPort[0]->GetLUT32ia(&slutFrame.iNAnots,
								  slutFrame.iAind,
								  slutFrame.fAlp    );

	// Set RenderParams and color LUT on each remote server if it is up
	sprintf(cLocalDir, "%s", rp.hvname);
	for(i=1; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {

		// Send RenderParams info to Cluster Server with appropriate directory
		csRemDir.Format("%s", dlgDHosts.m_cRemoteDirectories[i]);
		if(csRemDir.Compare("SameAsLocal") == 0) {
			sprintf((char *)rp.hvname, "%s", cLocalDir);
		} else {
			sprintf((char *)rp.hvname, "%s\\%s", dlgDHosts.m_cRemoteDirectories[i], cHVlist[m_iChosenTime]);
		}
		pChvrMainPort[i]->RestorKey(&rp);

		// Send Color LUT info to Cluster Server
		pChvrMainPort[i]->SetLUTia(	slutFrame.iNAnots,
									slutFrame.iAind,
									slutFrame.fAlp    );

		pChvrMainPort[i]->SetLUTirgb(slutFrame.iNCnots,
									 slutFrame.iCind,
									 slutFrame.fRed,
									 slutFrame.fGrn,
									 slutFrame.fBlu    );
	}}
}

void CHvr_mfcDlg::ClusterRender(int iBlock)
{
	int iNCluster, i, iNAreUp, iIsWorking;
	wchar_t* pwcStr=0;

	// Get the number of cluster server that are up
	iNCluster = dlgDHosts.m_iNCols * dlgDHosts.m_iNRows;
	iNAreUp = 0;
	for(i=1; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
		iNAreUp++;
	}}


	if(iNAreUp == 0) {
		// If no cluster servers are up, just so the local rendering as usual
		pChvrMainPort[0]->SetDoRender();   // Leave: this IS cluster render
	} else {
		// If any cluster servers are up: render on all in parallel
		pChvrMainPort[0]->SetOption(L"BlockOnRender", L"0");

		for(i=0; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
			pChvrMainPort[i]->SetDoRender();   // Leave: this IS cluster render
		}}
		iIsWorking = 1;
		while(iIsWorking == 1) {
			_sleep(10);
			iIsWorking = 0;
			for(i=0; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
				pChvrMainPort[i]->GetStatus(&pwcStr);
				if(wcscmp(pwcStr, L"WORKING") == 0) { iIsWorking = 1; }
				CoTaskMemFree(pwcStr);
			}}
		}

		pChvrMainPort[0]->SetOption(L"BlockOnRender", L"1");
	}
}

void CHvr_mfcDlg::ClusterEyePoint(int iDelX, int iDelY, int iMouseMode, int iInc)
{
	int iNCluster, i, iNAreUp;
	wchar_t* pwcStr=0;

	// Increment view on local host, reset clipping planes if necessary
	if(iInc == 1) { pChvrMainPort[0]->IncrementEyePoint(iDelX, iDelY, iMouseMode); }
	else          { pChvrMainPort[0]->ZoomEyePoint(iDelX, iDelY, iMouseMode); }
	if(iMouseMode != 2) { CalculateAndSetNearFarClipping(); }

	// Get the number of cluster server that are up
	iNCluster = dlgDHosts.m_iNCols * dlgDHosts.m_iNRows;
	iNAreUp = 0;
	for(i=1; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) { iNAreUp++; }}

	// If cluster servers are up, copy RenderParams info from local server to remote servers
	if(iNAreUp > 0) { 
		Renderparams rp;
		CString csRemDir;
		char cLocalDir[256];

		// Get RenderParams info from local server
		pChvrMainPort[0]->SaveKey(&rp);
		sprintf(cLocalDir, "%s", rp.hvname);

		// Send RenderParams info to Cluster Server with appropriate directory
		for(i=1; i <= iNCluster; i++) { if(dlgDHosts.m_iHostIsUp[i] == 1) {
			csRemDir.Format("%s", dlgDHosts.m_cRemoteDirectories[i]);
			if(csRemDir.Compare("SameAsLocal") == 0) {
				sprintf((char *)rp.hvname, "%s", cLocalDir);
			} else {
				sprintf((char *)rp.hvname, "%s\\%s", dlgDHosts.m_cRemoteDirectories[i], cHVlist[m_iChosenTime]);
			}
			pChvrMainPort[i]->RestorKey(&rp);
		}}
	}
}

void CHvr_mfcDlg::OnMenuEditAuxclip() 
{
	if(dlgSubRegion.DoModal() == IDOK) {
	}
}
