// TimeStamp.h: interface for the CTimeStamp class.
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#if !defined(AFX_TIMESTAMP_H__7323D778_3A43_11D5_AB5E_00D0680005D6__INCLUDED_)
#define AFX_TIMESTAMP_H__7323D778_3A43_11D5_AB5E_00D0680005D6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CTimeStamp  
{
public:
	LARGE_INTEGER m_liPC0;
	double m_fTimeReset;
	void SetOutputFileName(char* sFileName);
	char m_sFileName[256];
	void WriteToFile();
	void Reset();
	int m_iNStamps;
	double m_fTime[8192];
	char m_sStamps[8192][40];
	void StampTime(char* sLabel);
	CTimeStamp();
	virtual ~CTimeStamp();

};

#endif // !defined(AFX_TIMESTAMP_H__7323D778_3A43_11D5_AB5E_00D0680005D6__INCLUDED_)
