// TimeStamp.cpp: implementation of the CTimeStamp class.
//
//////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#include "stdafx.h"
#include "TimeStamp.h"

#include <stdio.h>
#include <sys/timeb.h>
#include <time.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTimeStamp::CTimeStamp()
{
	Reset();
	sprintf(m_sFileName, "TimeStamp.txt");
	QueryPerformanceCounter(&m_liPC0);

}

CTimeStamp::~CTimeStamp()
{

}

//LARGE_INTEGER liPCnow[8192];

void CTimeStamp::StampTime(char* sLabel)
{
//	struct _timeb tbuf;
//	_ftime( &tbuf );
//	m_fTime[m_iNStamps] = (double)tbuf.time + (double)tbuf.millitm / 1000.0;

//	LARGE_INTEGER liPC;
//	QueryPerformanceCounter(&liPC);
//	m_fTime[m_iNStamps] = (double)(liPC.QuadPart - m_liPC0.QuadPart) / 1000000000.0;

	m_fTime[m_iNStamps] = (float)GetTickCount() / (float)1000.0;
	sprintf(m_sStamps[m_iNStamps], "%s", sLabel);
	m_iNStamps++;

	if(m_iNStamps > 8192) { WriteToFile(); }
}

void CTimeStamp::Reset()
{
	m_iNStamps = 0;
}

void CTimeStamp::WriteToFile()
{

	FILE *filep;
	int i;

	filep = fopen(m_sFileName, "a");
	for(i=0; i<m_iNStamps; i++) {
		if(i == 0) {
			fprintf(filep, "%40s , %20.4f\n", m_sStamps[i], m_fTime[i]);
		} else {
			fprintf(filep, "%40s , %20.4f  %10f\n", m_sStamps[i], m_fTime[i], m_fTime[i]-m_fTime[i-1]);
		}
	}
	fclose(filep);

	m_iNStamps = 0;
}

void CTimeStamp::SetOutputFileName(char *sFileName)
{
	sprintf(m_sFileName, "%s", sFileName);
}
