// InteractiveDisplayQaulity.cpp : implementation file
//
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#include "stdafx.h"
#include "hvr_mfc.h"
#include "InteractiveDisplayQaulity.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInteractiveDisplayQaulity dialog


CInteractiveDisplayQaulity::CInteractiveDisplayQaulity(CWnd* pParent /*=NULL*/)
	: CDialog(CInteractiveDisplayQaulity::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInteractiveDisplayQaulity)
	m_fAngleTolerance = 0.0f;
	m_iNPlanes = 0;
	m_iValueTolerance = 0;
	m_fVoxelSize = 0.0f;
	m_fPresentationAngleTolerance = 0.0f;
	m_iNPresentationPlanes = 0;
	m_fPresentationVoxelSize = 0.0f;
	m_iPresentationValueTolerance = 0;
	//}}AFX_DATA_INIT
}


void CInteractiveDisplayQaulity::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInteractiveDisplayQaulity)
	DDX_Text(pDX, IDC_IDQ_EDIT_ANGLE, m_fAngleTolerance);
	DDX_Text(pDX, IDC_IDQ_EDIT_NPLANES, m_iNPlanes);
	DDX_Text(pDX, IDC_IDQ_EDIT_VALUE, m_iValueTolerance);
	DDX_Text(pDX, IDC_IDQ_EDIT_VOXEL_SIZE, m_fVoxelSize);
	DDX_Text(pDX, IDC_IDQ_EDIT_ANGLEP, m_fPresentationAngleTolerance);
	DDX_Text(pDX, IDC_IDQ_EDIT_NPLANESP, m_iNPresentationPlanes);
	DDX_Text(pDX, IDC_IDQ_EDIT_VOXEL_SIZEP, m_fPresentationVoxelSize);
	DDX_Text(pDX, IDC_IDQ_EDIT_VALUEP, m_iPresentationValueTolerance);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInteractiveDisplayQaulity, CDialog)
	//{{AFX_MSG_MAP(CInteractiveDisplayQaulity)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInteractiveDisplayQaulity message handlers

void CInteractiveDisplayQaulity::Initialize()
{
	m_fAngleTolerance = (float)0.02;
	m_iValueTolerance = 5;
	m_fVoxelSize      = (float)8.0;
	m_iNPlanes        = 1;

	m_fPresentationAngleTolerance = (float)0.0001;
	m_iPresentationValueTolerance = 0;
	m_fPresentationVoxelSize      = (float)1.0;
	m_iNPresentationPlanes        = 1;
}
