// HvrViewDlg.cpp : implementation file
//
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#include "stdafx.h"
#include "hvr_mfc.h"
#include "hvr_mfcDlg.h"
#include "HvrViewDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static CHvr_mfcDlg *pMainDlg;

// static Ihvr_work *pChvrMainPort[100];

/////////////////////////////////////////////////////////////////////////////
// CHvrViewDlg dialog


CHvrViewDlg::CHvrViewDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHvrViewDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHvrViewDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_iLMouseDown = 0;
	m_iRMouseDown = 0;
	m_iMouseMode  = 0;
}


void CHvrViewDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHvrViewDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHvrViewDlg, CDialog)
	//{{AFX_MSG_MAP(CHvrViewDlg)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHvrViewDlg message handlers

void CHvrViewDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// 1st, stop any QH renderings and wait for Rendering Quality parameters to be reset
	pMainDlg->m_iStop = 1;
	pMainDlg->StopRendering();
	while(pMainDlg->m_iAmRendering == 1) { _sleep(10); }

	// 2nd, set the mouse coords and start rendering again
	m_iMouseX = (int)point.x;
	m_iMouseY = (int)point.y;
	pMainDlg->XferLocalKeyInfoToCluster();
	pMainDlg->ClusterRender(1);
	m_iLMouseDown = 1;

	CDialog::OnLButtonDown(nFlags, point);
}

void CHvrViewDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	m_iLMouseDown = 0;
	pMainDlg->DoQualityFrame();

	CDialog::OnLButtonUp(nFlags, point);
}

void CHvrViewDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	int delx, dely;

	if(m_iLMouseDown == 1) {
		delx = (int)point.x - m_iMouseX;
		dely = (int)point.y - m_iMouseY;
		m_iMouseX = (int)point.x;
		m_iMouseY = (int)point.y;
		pMainDlg->ClusterEyePoint(delx, dely, m_iMouseMode, 1);
		pMainDlg->ClusterRender(1);
	}
	if(m_iRMouseDown == 1) {
		delx = m_iMouseX - (int)point.x;
		dely = m_iMouseY - (int)point.y;
		m_iMouseX = (int)point.x;
		m_iMouseY = (int)point.y;
		pMainDlg->ClusterEyePoint(delx, dely, m_iMouseMode, 0);
//		if(m_iMouseMode != 2) {
//			pMainDlg->CalculateAndSetNearFarClipping();
//		}
		pMainDlg->ClusterRender(1);
	}

	CDialog::OnMouseMove(nFlags, point);
}

void CHvrViewDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// 1st, stop any QH renderings and wait for Rendering Quality parameters to be reset
	pMainDlg->m_iStop = 1;
	pMainDlg->StopRendering();
	while(pMainDlg->m_iAmRendering == 1) { _sleep(10); }

	// 2nd, set the mouse coords and start rendering again
	m_iMouseX = (int)point.x;
	m_iMouseY = (int)point.y;
	pMainDlg->XferLocalKeyInfoToCluster();
	pMainDlg->ClusterRender(1);
	m_iRMouseDown = 1;

	CDialog::OnRButtonDown(nFlags, point);
}

void CHvrViewDlg::OnRButtonUp(UINT nFlags, CPoint point) 
{
	m_iRMouseDown = 0;
	pMainDlg->DoQualityFrame();

	CDialog::OnRButtonUp(nFlags, point);
}

void CHvrViewDlg::SetHVRport(Ihvr_work *p_hvr_work)
{
	pChvrMainPort[0] = p_hvr_work;
}

void CHvrViewDlg::SetPP(CHvr_mfcDlg *pp)
{
	pMainDlg = pp;
}

void CHvrViewDlg::OnOK()
{

}
