////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/
#if !defined(AFX_GETBOBS_H__0BF102B0_1E07_11D5_AB4C_00D0680005D6__INCLUDED_)
#define AFX_GETBOBS_H__0BF102B0_1E07_11D5_AB4C_00D0680005D6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// GetBobs.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CGetBobs dialog

class CGetBobs : public CDialog
{
// Construction
public:
	int m_iBuildFromHVs;
	int m_iNBobFiles;
	CGetBobs(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CGetBobs)
	enum { IDD = IDD_DIALOG_GET_BOBS };
	CListBox	m_lbDirList;
	CListBox	m_lbBobList;
	CString	m_csBobFilter;
	CString	m_csBobDirectory;
	int		m_iNx;
	int		m_iNy;
	int		m_iNz;
	CString	m_csProjectDirectory;
	CString	m_csProjectFile;
	CString	m_csFieldName;
	CString	m_csLUTFile;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGetBobs)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CGetBobs)
	afx_msg void OnVbButtonFindBobs();
	afx_msg void OnVbButtonGetBobs();
	afx_msg void OnVbButtonSelectProj();
	virtual void OnOK();
	afx_msg void OnVbButtonLutFile();
	afx_msg void OnVbButtonAddDirToList();
	afx_msg void OnVbButtonDeleteDir();
	afx_msg void OnVbButtonSaveDirs();
	afx_msg void OnVbButtonLoadDirs();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GETBOBS_H__0BF102B0_1E07_11D5_AB4C_00D0680005D6__INCLUDED_)
