// GetBobs.cpp : implementation file
//
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#include "stdafx.h"
#include "hvr_mfc.h"
#include "GetBobs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGetBobs dialog


CGetBobs::CGetBobs(CWnd* pParent /*=NULL*/)
	: CDialog(CGetBobs::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetBobs)
	m_csBobFilter = _T("");
	m_csBobDirectory = _T("");
	m_iNx = 0;
	m_iNy = 0;
	m_iNz = 0;
	m_csProjectDirectory = _T("");
	m_csProjectFile = _T("");
	m_csFieldName = _T("");
	m_csLUTFile = _T("");
	//}}AFX_DATA_INIT
}


void CGetBobs::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetBobs)
	DDX_Control(pDX, IDC_VB_LIST_DIRECTORY_LIST, m_lbDirList);
	DDX_Control(pDX, IDC_VB_LIST_BOBS, m_lbBobList);
	DDX_Text(pDX, IDC_VB_EDIT_FILTER, m_csBobFilter);
	DDX_Text(pDX, IDC_VB_EDIT_DIR, m_csBobDirectory);
	DDX_Text(pDX, IDC_VB_EDIT_NX, m_iNx);
	DDX_Text(pDX, IDC_VB_EDIT_NY, m_iNy);
	DDX_Text(pDX, IDC_VB_EDIT_NZ, m_iNz);
	DDX_Text(pDX, IDC_VB_EDIT_PROJDIR, m_csProjectDirectory);
	DDX_Text(pDX, IDC_VB_EDIT_PROJFILE, m_csProjectFile);
	DDX_Text(pDX, IDC_VB_EDIT_FIELD_NAME, m_csFieldName);
	DDX_Text(pDX, IDC_VB_EDIT_LUT_FILE, m_csLUTFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGetBobs, CDialog)
	//{{AFX_MSG_MAP(CGetBobs)
	ON_BN_CLICKED(IDC_VB_BUTTON_FIND_BOBS, OnVbButtonFindBobs)
	ON_BN_CLICKED(IDC_VB_BUTTON_GET_BOBS, OnVbButtonGetBobs)
	ON_BN_CLICKED(IDC_VB_BUTTON_SELECT_PROJ, OnVbButtonSelectProj)
	ON_BN_CLICKED(IDC_VB_BUTTON_LUT_FILE, OnVbButtonLutFile)
	ON_BN_CLICKED(IDC_VB_BUTTON_ADD_DIR_TO_LIST, OnVbButtonAddDirToList)
	ON_BN_CLICKED(IDC_VB_BUTTON_DELETE_DIR, OnVbButtonDeleteDir)
	ON_BN_CLICKED(IDC_VB_BUTTON_SAVE_DIRS, OnVbButtonSaveDirs)
	ON_BN_CLICKED(IDC_VB_BUTTON_LOAD_DIRS, OnVbButtonLoadDirs)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetBobs message handlers

void CGetBobs::OnVbButtonFindBobs() 
{
	CFileDialog dlgFile(TRUE);
	char cDir[256];

	UpdateData(TRUE);

	dlgFile.m_ofn.lpstrTitle = "Browse For A Directory & File\0";
	dlgFile.m_ofn.lpstrFilter = "HV Files (*.hv)\0*.hv\0BOB Files (*)\0*\0";
	if(dlgFile.DoModal() == IDOK) {
		GetCurrentDirectory(256, cDir);
		m_csBobDirectory = cDir;
		m_csBobFilter = dlgFile.GetFileName();
		m_csProjectDirectory = cDir;
		m_csLUTFile = "GrayRamp";
		UpdateData(FALSE);
	}
}

void CGetBobs::OnVbButtonGetBobs() 
{
	char str[256], str1[256], cDir[256];
	WIN32_FIND_DATA FindFileData;
	HANDLE hFind;
	char cFilter[256], cName[256];
	int i, j, ic, n, iDir;

	UpdateData(TRUE);

/**********************************************************************
 *  Automatically Generate Default field & project names & files      *
 **********************************************************************/
	strcpy(cFilter, (LPCSTR)m_csBobFilter);
	j = 0;
	for(i=0; i<256; i++) {
		ic = (int)cFilter[i];
		if(	((int)'a' <= ic   &&   ic <= (int)'z')   ||
			((int)'A' <= ic   &&   ic <= (int)'Z')   ||   ic == (int)'\0'   ||
			((int)'1' <= ic   &&   ic <= (int)'9')   ||   ic == (int)'0') { cName[j] = cFilter[i]; j++; }
	}
	cName[j] = '\0';
	m_csProjectFile.Format("%s.hvp\0", cName);
	m_csFieldName.Format("%s\0", cName);
	UpdateData(FALSE);

	n = strlen(cFilter);
	if(	(int)cFilter[n-3] == (int)'.' &&
		(int)cFilter[n-2] == (int)'h' &&
		(int)cFilter[n-1] == (int)'v'     ) { m_iBuildFromHVs = 1; }
	else                                    { m_iBuildFromHVs = 0; }

/**********************************************************************
 *  Generate a list of BOB or .hv files                               *
 **********************************************************************/
	m_iNBobFiles = 0;
	m_lbBobList.ResetContent();

	for(iDir=0; iDir<m_lbDirList.GetCount(); iDir++) {
		m_lbDirList.GetText(iDir, cDir);
		sprintf(str, "%s\\%s\0", cDir, (LPCSTR)m_csBobFilter);

		hFind = FindFirstFile(str, &FindFileData);
		if (hFind == INVALID_HANDLE_VALUE) {
			sprintf (str1, "No files of the form %s found in %s.", (LPCSTR)m_csBobFilter, cDir);
			MessageBox(str1);
		} else {
			sprintf (str1, "%s    %s", FindFileData.cFileName, cDir);
			m_lbBobList.AddString(str1);
			m_iNBobFiles++;
			while(FindNextFile(hFind, &FindFileData) != 0) {
				sprintf (str1, "%s    %s", FindFileData.cFileName, cDir);
				m_lbBobList.AddString(str1);
				m_iNBobFiles++;
			}
		}
	}
}

void CGetBobs::OnVbButtonSelectProj() 
{
	CFileDialog dlgFile(FALSE);
	char cDir[256];

	UpdateData(TRUE);

	dlgFile.m_ofn.lpstrFilter = "HV Project Files (*.hvp)\0*.hvp\0\0";
	if(dlgFile.DoModal() == IDOK) {
		GetCurrentDirectory(256, cDir);
		m_csProjectDirectory = cDir;
		m_csProjectFile = dlgFile.GetFileName();
		UpdateData(FALSE);
	}
}

void CGetBobs::OnOK() 
{
	char cFileDir[256], cBOB[256], cHV[256], str[256], cFieldFile[256];
	int i, j, jDirBegin;
	WIN32_FIND_DATA FindFileData;
	HANDLE hFind;
	FILE *fp, *fpField, *fpProject;

	UpdateData(TRUE);

	if(m_iBuildFromHVs == 0) {
		if(m_iNx == 0  ||  m_iNy == 0  ||  m_iNz == 0) {
			MessageBox("Please specify:  Voxel Resolution of BOB(s)");
			return;
		}
	}

/********************************************************************
 *	Generate .hv files for BOBs as needed and a field file for them *
 ********************************************************************/

	SetCurrentDirectory((LPCSTR)m_csProjectDirectory);
	sprintf(cFieldFile, "%s\\%s.fld", (LPCSTR)m_csProjectDirectory, (LPCSTR)m_csFieldName);
	fpField = fopen(cFieldFile, "w");

	if(m_iBuildFromHVs == 0) {
		for(i=0; i<m_iNBobFiles; i++) {
			m_lbBobList.GetText(i, cFileDir);
			j = 0;
			while((int)cFileDir[j] != (int)' '  &&  j < 256) { cBOB[j] = cFileDir[j]; j++; }
			cBOB[j] = '\0';
			jDirBegin = j;
			sprintf(cHV, "%s.hv", cBOB);

			hFind = FindFirstFile(cHV, &FindFileData);
			if (hFind == INVALID_HANDLE_VALUE) {
				// *.hv file does NOT exist so make one assuming a simple monolithic bob file
				fp = fopen(cHV, "w");
				fprintf(fp, "%s   0   1   %d %d %d    0 0 0   -1 0\n", cBOB, m_iNx, m_iNy, m_iNz);
				fprintf(fp, "\n");
				fclose(fp);
			} else {
				// DO NOT overwrite existing .hv file
				sprintf(str, "%s already exists", cHV);
	//			MessageBox(str);
			}
			fprintf(fpField, "HVfile   %s %s/\n", cHV, &cFileDir[jDirBegin]);
		}
	} else {
		for(i=0; i<m_iNBobFiles; i++) {
			m_lbBobList.GetText(i, cFileDir);
			j = 0;
			while((int)cFileDir[j] != (int)' '  &&  j < 256) { cHV[j] = cFileDir[j]; j++; }
			cHV[j] = '\0';
			jDirBegin = j;

			fprintf(fpField, "HVfile   %s %s/\n", cHV, &cFileDir[jDirBegin]);
		}
	}
	fclose(fpField);

/**************************************************************************
 *	Generate A Project file for this set of BOBs (= a field)              *
 **************************************************************************/
	fpProject = fopen((LPCSTR)m_csProjectFile, "w");
	fprintf(fpProject, "FIELDfile    %s\n", cFieldFile);
	fprintf(fpProject, "LUTfile      %s\n", (LPCSTR)m_csLUTFile);
	fprintf(fpProject, "FIELDname    %s\n", (LPCSTR)m_csFieldName);
	fclose(fpProject);

	CDialog::OnOK();
}

void CGetBobs::OnVbButtonLutFile() 
{
	CFileDialog dlgFile(TRUE);

	UpdateData(TRUE);

	dlgFile.m_ofn.lpstrFilter = "Color RGBA LUT Files (*.lut)\0*.lut\0\0";
	if(dlgFile.DoModal() == IDOK) {
		m_csLUTFile = dlgFile.GetPathName();
		UpdateData(FALSE);
	}
}

void CGetBobs::OnVbButtonAddDirToList() 
{
	UpdateData(TRUE);
	m_lbDirList.AddString((LPCSTR)m_csBobDirectory);
}

void CGetBobs::OnVbButtonDeleteDir() 
{
	int iDir, iLeft;
	for(iDir = m_lbDirList.GetCount()-1; iDir >= 0; iDir--) {
		if(m_lbDirList.GetSel(iDir) > 0) { iLeft = m_lbDirList.DeleteString(iDir); }
	}
}

void CGetBobs::OnVbButtonSaveDirs() 
{
	CFileDialog dlgFile(FALSE);
	CString csFile;
	char cDir[256];
	int iDir;
	FILE *fp;

	UpdateData(TRUE);

	dlgFile.m_ofn.lpstrFilter = "Directory List Files (*.dlf)\0*.dlf\0\0";
	if(dlgFile.DoModal() == IDOK) {
		csFile = dlgFile.GetPathName();
		fp = fopen((LPCSTR)csFile, "w");
		for(iDir=0; iDir < m_lbDirList.GetCount(); iDir++) {
			m_lbDirList.GetText(iDir, cDir);
			fprintf(fp, "%s\n", cDir);
		}
		fclose(fp);
	}
	
}

void CGetBobs::OnVbButtonLoadDirs() 
{
	CFileDialog dlgFile(TRUE);
	CString csFile;
	char cDir[256];
	FILE *fp;

	dlgFile.m_ofn.lpstrFilter = "Directory List Files (*.dlf)\0*.dlf\0\0";
	if(dlgFile.DoModal() == IDOK) {
		m_lbDirList.ResetContent();
		csFile = dlgFile.GetPathName();
		fp = fopen((LPCSTR)csFile, "r");
		while(fscanf(fp, "%s", cDir) > 0) { m_lbDirList.AddString(cDir); }
		fclose(fp);

		GetCurrentDirectory(256, cDir);
		m_csBobDirectory = cDir;
		m_csProjectDirectory = cDir;
		m_csLUTFile = "GrayRamp";
		UpdateData(FALSE);
	}
}
