////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/
#if !defined(AFX_EDIT_VIEW_H__16B5BAD1_63E8_11D5_AB6C_00D0680005D6__INCLUDED_)
#define AFX_EDIT_VIEW_H__16B5BAD1_63E8_11D5_AB6C_00D0680005D6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Edit_View.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CEdit_View dialog

class CEdit_View : public CDialog
{
// Construction
public:
	void SetPP(CHvr_mfcDlg *pp);
	struct Renderparams m_srpKeyInfo;
	void GetViewFromServer();
	CEdit_View(CWnd* pParent = NULL);   // standard constructor
	Ihvr_work *pChvrMainPort[100];

// Dialog Data
	//{{AFX_DATA(CEdit_View)
	enum { IDD = IDD_DIALOG_EDIT_VIEW };
	float	m_fCenX;
	float	m_fCenY;
	float	m_fCenZ;
	float	m_fEyeX;
	float	m_fEyeY;
	float	m_fEyeZ;
	float	m_fUpX;
	float	m_fUpY;
	float	m_fUpZ;
	float	m_fNearFar;
	float	m_fNearLim;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEdit_View)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CEdit_View)
	afx_msg void OnEvButtonEyeX();
	afx_msg void OnEvButtonEyeY();
	afx_msg void OnEvButtonEyeZ();
	afx_msg void OnEvButtonUpX();
	afx_msg void OnEvButtonUpY();
	afx_msg void OnEvButtonUpZ();
	afx_msg void OnEvButtonZeroCent();
	afx_msg void OnEvButtonApply();
	afx_msg void OnEvButtonSave();
	afx_msg void OnEvButtonLoad();
	virtual void OnOK();
	afx_msg void OnEvButtonReset();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	bool m_bWasApplied;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EDIT_VIEW_H__16B5BAD1_63E8_11D5_AB6C_00D0680005D6__INCLUDED_)
