////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/
#if !defined(AFX_EDITSUBREGION_H__59DCA95F_208A_11D6_ABB3_00D0680005D6__INCLUDED_)
#define AFX_EDITSUBREGION_H__59DCA95F_208A_11D6_ABB3_00D0680005D6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// EditSubregion.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CEditSubregion dialog

class CEditSubregion : public CDialog
{
// Construction
public:
	void ApplyLimits();
	void SetPP(CHvr_mfcDlg *pp);
	CEditSubregion(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CEditSubregion)
	enum { IDD = IDD_DIALOG_EDIT_SUBREGION };
	BOOL	m_bUseAuxClips;
	float	m_fXmax;
	float	m_fXmin;
	float	m_fYmax;
	float	m_fYmin;
	float	m_fZmax;
	float	m_fZmin;
	int		m_iXcenter;
	int		m_iXsize;
	int		m_iYcenter;
	int		m_iYsize;
	int		m_iZcenter;
	int		m_iZsize;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEditSubregion)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CEditSubregion)
	afx_msg void OnButtonApply();
	afx_msg void OnReleasedcaptureSliderXCent(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderYCent(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderZCent(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderXSize(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderYSize(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderZSize(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnButtonResetLimits();
	afx_msg void OnButtonCenterEyeLimits();
	afx_msg void OnCheckUseAuxClips();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EDITSUBREGION_H__59DCA95F_208A_11D6_ABB3_00D0680005D6__INCLUDED_)
