////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/
#if !defined(AFX_EDITPROJECT_H__5B3A64D4_1C94_11D5_AB4C_00D0680005D6__INCLUDED_)
#define AFX_EDITPROJECT_H__5B3A64D4_1C94_11D5_AB4C_00D0680005D6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// EditProject.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// EditProject dialog

class EditProject : public CDialog
{
// Construction
public:
	void DisplayProject();
	CString m_csMoviePathFile;
	CString m_csKeyFrameFile;
	void SaveProjectToFile();
	void LoadProjectFromFile();
	EditProject(CWnd* pParent = NULL);   // standard constructor
	int m_iNFields;
	CString m_csFieldNames[64];
	CString m_csFieldFiles[64];
	CString m_csLUTFiles[64];
	CString m_csTickFiles[64];

// Dialog Data
	//{{AFX_DATA(EditProject)
	enum { IDD = IDD_DIALOG_EDIT_PROJECT };
	CListBox	m_lbPairs;
	CString	m_csProjectFile;
	CString	m_csFieldFile;
	CString	m_csLUTFile;
	CString	m_csFieldName;
	CString	m_csTickFile;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(EditProject)
	public:
	virtual int DoModal();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(EditProject)
	virtual void OnOK();
	afx_msg void OnEpButtonDir();
	afx_msg void OnEpButtonColor();
	afx_msg void OnEpButtonField();
	afx_msg void OnEpButtonAdd();
	afx_msg void OnEpButtonLoad();
	afx_msg void OnEpButtonTick();
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeEpListPairs();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EDITPROJECT_H__5B3A64D4_1C94_11D5_AB4C_00D0680005D6__INCLUDED_)
