// EditProject.cpp : implementation file
//
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#include "stdafx.h"
#include "hvr_mfc.h"
#include "EditProject.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// EditProject dialog


EditProject::EditProject(CWnd* pParent /*=NULL*/)
	: CDialog(EditProject::IDD, pParent)
{
	//{{AFX_DATA_INIT(EditProject)
	m_csProjectFile = _T("");
	m_csFieldFile = _T("");
	m_csLUTFile = _T("");
	m_csFieldName = _T("");
	m_csTickFile = _T("");
	//}}AFX_DATA_INIT
}


void EditProject::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(EditProject)
	DDX_Control(pDX, IDC_EP_LIST_PAIRS, m_lbPairs);
	DDX_Text(pDX, IDC_EP_EDIT_DIR, m_csProjectFile);
	DDX_Text(pDX, IDC_EP_EDIT_FIELD, m_csFieldFile);
	DDX_Text(pDX, IDC_EP_EDIT_COLOR, m_csLUTFile);
	DDX_Text(pDX, IDC_EP_EDIT_NAME, m_csFieldName);
	DDX_Text(pDX, IDC_EP_EDIT_TICK, m_csTickFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(EditProject, CDialog)
	//{{AFX_MSG_MAP(EditProject)
	ON_BN_CLICKED(IDC_EP_BUTTON_DIR, OnEpButtonDir)
	ON_BN_CLICKED(IDC_EP_BUTTON_COLOR, OnEpButtonColor)
	ON_BN_CLICKED(IDC_EP_BUTTON_FIELD, OnEpButtonField)
	ON_BN_CLICKED(IDC_EP_BUTTON_ADD, OnEpButtonAdd)
	ON_BN_CLICKED(IDC_EP_BUTTON_LOAD, OnEpButtonLoad)
	ON_BN_CLICKED(IDC_EP_BUTTON_TICK, OnEpButtonTick)
	ON_LBN_SELCHANGE(IDC_EP_LIST_PAIRS, OnSelchangeEpListPairs)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// EditProject message handlers

void EditProject::OnOK() 
{

	if(m_iNFields ==  0) { OnEpButtonAdd(); }

	UpdateData(TRUE);

	SaveProjectToFile();

	CDialog::OnOK();
}

void EditProject::OnEpButtonDir() 
{
	CFileDialog dlgFileOut(FALSE);
//	FILE *fp;
	UpdateData(TRUE);

	dlgFileOut.m_ofn.lpstrFilter = "HV Project Field Files (*.hvp)\0*.hvp\0\0";
	dlgFileOut.m_ofn.lpstrTitle = "Select Project Directory and Name\0";
	if(dlgFileOut.DoModal() == IDOK) {
		m_csProjectFile = dlgFileOut.GetPathName();
		UpdateData(FALSE);
	}
	
}

void EditProject::OnEpButtonColor() 
{
	UpdateData(TRUE);

	CFileDialog dlgFile(TRUE);
	dlgFile.m_ofn.lpstrFilter = "Color LUT Files (*.lut)\0*.lut\0\0";
	dlgFile.m_ofn.lpstrTitle = "Select a Color LUT file to go with field\0";
	if(dlgFile.DoModal() == IDOK) {	
		m_csLUTFile = dlgFile.GetPathName();
		UpdateData(FALSE);
	}
}

void EditProject::OnEpButtonField() 
{
	UpdateData(TRUE);
	
	CFileDialog dlgFile(TRUE);
	dlgFile.m_ofn.lpstrFilter = "Field Files (*.fld)\0*.fld\0\0";
	dlgFile.m_ofn.lpstrTitle = "Select one Field File to start with\0";
	if(dlgFile.DoModal() == IDOK) {	
		m_csFieldFile = dlgFile.GetPathName();
		m_csFieldName = dlgFile.GetFileName();
		UpdateData(FALSE);
	}
}

void EditProject::OnEpButtonAdd() 
{
	CString csTMP;

	UpdateData(TRUE);

	m_csFieldNames[m_iNFields] = m_csFieldName;
	m_csFieldFiles[m_iNFields] = m_csFieldFile;
	m_csLUTFiles[m_iNFields]   = m_csLUTFile;
	m_csTickFiles[m_iNFields]  = m_csTickFile;
	m_iNFields++;

//	int i;
//	m_lbPairs.ResetContent();
//	for(i=0; i<m_iNFields; i++) {
//		csTMP.Format("%s   /   %s   /   %s   /   %s",
//			m_csFieldNames[i], m_csFieldFiles[i], m_csLUTFiles[i], m_csTickFiles[i]);
//		m_lbPairs.AddString((LPCTSTR)csTMP);
//	}
//	m_csFieldName.Format(" ");
//	m_csFieldFile.Format(" ");
//	m_csLUTFile.Format("GrayRamp");
//	m_csTickFile.Format("none");

	DisplayProject();
	UpdateData(FALSE);
}

void EditProject::OnEpButtonLoad() 
{
	UpdateData(TRUE);

	CFileDialog dlgFile(TRUE);
	dlgFile.m_ofn.lpstrFilter = "HV Project Field Files (*.hvp)\0*.hvp\0\0";
	dlgFile.m_ofn.lpstrTitle = "Select A Project To Load\0";
	if(dlgFile.DoModal() == IDOK) {
		m_csProjectFile = dlgFile.GetPathName();
		LoadProjectFromFile();
		DisplayProject();
		UpdateData(FALSE);
	}
}

void EditProject::LoadProjectFromFile()
{
	FILE *fp;
	char line[256];
	char *keyword;
	static char *seps = " ,;\t\n";
	char file[256];
	int nc;

	int match( char *, char *, int );

	m_csMoviePathFile.Format("none");
	m_csKeyFrameFile.Format("none");
//	m_iNFields = 0;
	m_csLUTFiles[m_iNFields].Format("GrayRamp");
	m_csTickFiles[m_iNFields].Format("none");
	fp = fopen((LPCSTR)m_csProjectFile, "r");
	while ( fgets(line,256,fp) != NULL ) {
		if ( line[0] == '#' ) continue;
		nc = strlen(line);
		keyword = strtok( line,seps );
		nc = strlen(keyword);
		if (!nc) continue;

			if      ( match(keyword,"LUTfile",nc) ) {
				strncpy( file, strtok(NULL,seps),80 );
				m_csLUTFiles[m_iNFields].Format("%s", file);
				m_csLUTFile = m_csLUTFiles[m_iNFields];

			}

			else if ( match(keyword,"FIELDfile", nc) ) {
				strncpy( file, strtok(NULL,seps),80 );
				m_csFieldFiles[m_iNFields].Format("%s", file);
				m_csFieldFile = m_csFieldFiles[m_iNFields];
			}

			else if ( match(keyword,"TICKfile",nc) ) {
				strncpy( file, strtok(NULL,seps),80 );
				m_csTickFiles[m_iNFields].Format("%s", file);
				m_csTickFile = m_csTickFiles[m_iNFields];
			}

			else if ( match(keyword,"FIELDname",nc) ) {
				strncpy( file, strtok(NULL,seps),80 );
				m_csFieldNames[m_iNFields].Format("%s", file);
				m_csFieldName = m_csFieldNames[m_iNFields];
				m_iNFields++;

				m_csLUTFiles[m_iNFields].Format("GrayRamp");
				m_csTickFiles[m_iNFields].Format("none");
			}

			else if ( match(keyword,"MoviePathFile",nc) ) {
				strncpy( file, strtok(NULL,seps),80 );
				m_csMoviePathFile.Format("%s", file);
			}

			else if ( match(keyword,"KeyFrameFile",nc) ) {
				strncpy( file, strtok(NULL,seps),80 );
				m_csKeyFrameFile.Format("%s", file);
			}

		}
		fclose(fp); 
}

void EditProject::OnEpButtonTick() 
{
	UpdateData(TRUE);

	CFileDialog dlgFile(TRUE);
	dlgFile.m_ofn.lpstrFilter = "Scaling Tick Files (*.tick)\0*.tick\0\0";
	dlgFile.m_ofn.lpstrTitle = "Select a tick scaling file to go with field\0";
	if(dlgFile.DoModal() == IDOK) {	
		m_csTickFile = dlgFile.GetPathName();
		UpdateData(FALSE);
	}
}

void EditProject::SaveProjectToFile()
{
	FILE *fp;
	int i;
	fp = fopen((LPCSTR)m_csProjectFile, "w");
	for(i=0; i<m_iNFields; i++) {
		fprintf(fp, "FIELDfile       %s\n", (LPCSTR)m_csFieldFiles[i]);
		fprintf(fp, "LUTfile         %s\n", (LPCSTR)m_csLUTFiles[i]);
		fprintf(fp, "TICKfile        %s\n", (LPCSTR)m_csTickFiles[i]);
		fprintf(fp, "FIELDname       %s\n", (LPCSTR)m_csFieldNames[i]);
	}
	if(m_csMoviePathFile.Compare("none") != 0) { fprintf(fp, "MoviePathFile   %s\n", (LPCSTR)m_csMoviePathFile); }
	if(m_csKeyFrameFile.Compare("none")  != 0) { fprintf(fp, "KeyFrameFile    %s\n", (LPCSTR)m_csKeyFrameFile ); }

	fclose(fp);
}

void EditProject::DisplayProject()
{
	int i;
	CString csTMP;

	m_lbPairs.ResetContent();
	for(i=0; i<m_iNFields; i++) {
		csTMP.Format("%s   /   %s   /   %s   /   %s",
			m_csFieldNames[i], m_csFieldFiles[i], m_csLUTFiles[i], m_csTickFiles[i]);
		m_lbPairs.AddString((LPCTSTR)csTMP);
	}
}

int EditProject::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class
	return CDialog::DoModal();
}

BOOL EditProject::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	DisplayProject();
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void EditProject::OnSelchangeEpListPairs() 
{
	int iPopup, iList, i;
	CPoint point;
	RECT rList, rItem;

	CMenu menu;
	menu.CreatePopupMenu();
	menu.AppendMenu(MF_STRING, 1, "Copy this set to edit fields below");
	menu.AppendMenu(MF_STRING, 2, "Copy edit fields below to this set");
	menu.AppendMenu(MF_STRING, 3, "Delete this set");
	menu.AppendMenu(MF_STRING, 4, "Delete ALL sets");

	iList = m_lbPairs.GetCurSel();
	m_lbPairs.GetWindowRect(&rList);			// Get screen ccords of list box
	m_lbPairs.GetItemRect(iList, &rItem);		// Get offset to item in list box
	point.x = rItem.left + rList.left;
	point.y = rItem.top  + rList.top;

	iPopup = menu.TrackPopupMenu(TPM_RETURNCMD | TPM_RIGHTALIGN,
		 point.x, point.y, this);

	if(iPopup == 1) {
		m_csFieldName = m_csFieldNames[iList];
		m_csFieldFile = m_csFieldFiles[iList];
		m_csLUTFile   = m_csLUTFiles[iList];
		m_csTickFile  = m_csTickFiles[iList];
		UpdateData(FALSE);
	}
	if(iPopup == 2) {
		UpdateData(TRUE);
		m_csFieldNames[iList] = m_csFieldName;
		m_csFieldFiles[iList] = m_csFieldFile;
		m_csLUTFiles[iList]   = m_csLUTFile;
		m_csTickFiles[iList]  = m_csTickFile;
		DisplayProject();
		UpdateData(FALSE);
	}
	if(iPopup == 3) {
		for(i=iList+1; i<m_iNFields; i++) {
			m_csFieldNames[i-1] = m_csFieldNames[i];
			m_csFieldFiles[i-1] = m_csFieldFiles[i];
			m_csLUTFiles[i-1]   = m_csLUTFiles[i];
			m_csTickFiles[i-1]  = m_csTickFiles[i];
		}
		m_iNFields--;
		DisplayProject();
		UpdateData(FALSE);
	}
	if(iPopup == 4) {
		m_iNFields = 0;
		DisplayProject();
		UpdateData(FALSE);
	}
}
