////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/
#if !defined(AFX_EDITLUT_H__40AAF70B_1883_11D5_AB49_00D0680005D6__INCLUDED_)
#define AFX_EDITLUT_H__40AAF70B_1883_11D5_AB49_00D0680005D6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// EditLUT.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CEditLUT dialog

class CEditLUT : public CDialog
{
// Construction
public:
	void RenderIt();
	void SetPP(CHvr_mfcDlg *pp);
	int m_iKnotIndexRGB;
	int m_iKnotIndexALP;
	void SetLUTtoGrayScale();
/*
	struct SLutNots {
		int iNCnots;
		int iNAnots;
		int iCind[32];
		int iAind[32];
		float fRed[32];
		float fGrn[32];
		float fBlu[32];
		float fAlp[32];
	};
*/
	int SetLUTfromHVRwork(SLutNots Slut);
	void ReadLUTfile(const char *cFile);
	void SetLUTirgba();
	void SetHVRport(Ihvr_work *p_hvr_work);
	void DumpLUTcols();
	void Insert_alpNotAfter(int i0);
	void Insert_rgbNotAfter(int i0);
	void DrawPlots();
	void InitPlots();
	long m_iXrgb;
	long m_iYrgb;
	long m_iXalp;
	long m_iYalp;
	long m_iXsize;
	long m_iYsize;
	CRect m_crRGB;
	CRect m_crALP;
	int m_iChosenNot;
	int m_iAlpChosenNot;
	int m_iAlpValCosenNot;
	struct SIRGB {
		long ind;
		long red;
		long grn;
		long blu;
	};
	struct SIALP {
		long ind;
		long alp;
	};
	int m_iNrgbNots;
	int m_iNalpNots;
	SIRGB m_rgbNots[32];
	SIALP m_alpNots[32];
	int m_iAmCreated;
	void CreateOnce();
	CEditLUT(CWnd* pParent = NULL);   // standard constructor
	Ihvr_work *pChvrMainPort[100];

// Dialog Data
	//{{AFX_DATA(CEditLUT)
	enum { IDD = IDD_DIALOG_EDiT_LUT };
	CString	m_csKnotIndex;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEditLUT)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CEditLUT)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLutButtonSave();
	afx_msg void OnLutButtonLoad();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnPaint();
	afx_msg void OnLutDeleteKnot();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EDITLUT_H__40AAF70B_1883_11D5_AB49_00D0680005D6__INCLUDED_)
