////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/
#if !defined(AFX_DISPLAYHOSTS_H__CC2A7B33_333F_11D5_AB52_00D0680005D6__INCLUDED_)
#define AFX_DISPLAYHOSTS_H__CC2A7B33_333F_11D5_AB52_00D0680005D6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DisplayHosts.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDisplayHosts dialog

class CDisplayHosts : public CDialog
{
// Construction
public:
	char m_cRemoteDirectories[100][256];
	int m_iHostIsUp[100];
	void ShowClusterList();
	wchar_t m_wcClusterHosts[100][256];
	void SetPP(CHvr_mfcDlg *pp);
	void InitializeHostList();
	int m_iNCols;
	int m_iNRows;
	struct Frustum {
		float fCent[3];
		float fUp[3];
		float fNorm[3];
		int iWidth;
		int iHeight;
		float fWidth;
	};
	int m_iNFrusta;
	Frustum m_SFrusta[1000];
	CDisplayHosts(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CDisplayHosts)
	enum { IDD = IDD_DIALOG_DISPLAY_HOSTS };
	CListBox	m_lbHosts;
	CString	m_csNewHost;
	CString	m_csQueueHost;
	CString	m_csRenderServer;
	CString	m_csRemoteDirectory;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDisplayHosts)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDisplayHosts)
	afx_msg void OnButtonAddHost();
	afx_msg void OnButtonClearHosts();
	afx_msg void OnButtonStartCluster();
	afx_msg void OnButtonStopCluster();
	afx_msg void OnButtonClusterStatus();
	afx_msg void OnButtonSaveHl();
	afx_msg void OnButtonLoadHl();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DISPLAYHOSTS_H__CC2A7B33_333F_11D5_AB52_00D0680005D6__INCLUDED_)
