// DisplayHosts.cpp : implementation file
//
////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#include "stdafx.h"
#include "hvr_mfc.h"
#include "hvr_mfcDlg.h"
#include "DisplayControl.h"
#include "DisplayHosts.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static CHvr_mfcDlg *pMainDlg;

/////////////////////////////////////////////////////////////////////////////
// CDisplayHosts dialog


CDisplayHosts::CDisplayHosts(CWnd* pParent /*=NULL*/)
	: CDialog(CDisplayHosts::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDisplayHosts)
	m_csNewHost = _T("");
	m_csQueueHost = _T("");
	m_csRenderServer = _T("");
	m_csRemoteDirectory = _T("");
	//}}AFX_DATA_INIT
}


void CDisplayHosts::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDisplayHosts)
	DDX_Control(pDX, IDC_LIST_HOSTS, m_lbHosts);
	DDX_Text(pDX, IDC_EDIT_NEW_HOST, m_csNewHost);
	DDX_Text(pDX, IDC_DISP_HOSTS_EDIT_QUEUE, m_csQueueHost);
	DDX_Text(pDX, IDC_DISP_HOSTS_EDIT_SERVER, m_csRenderServer);
	DDX_Text(pDX, IDC_EDIT_REMOTE_DIR, m_csRemoteDirectory);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDisplayHosts, CDialog)
	//{{AFX_MSG_MAP(CDisplayHosts)
	ON_BN_CLICKED(IDC_BUTTON_ADD_HOST, OnButtonAddHost)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR_HOSTS, OnButtonClearHosts)
	ON_BN_CLICKED(IDC_BUTTON_START_CLUSTER, OnButtonStartCluster)
	ON_BN_CLICKED(IDC_BUTTON_STOP_CLUSTER, OnButtonStopCluster)
	ON_BN_CLICKED(IDC_BUTTON_CLUSTER_STATUS, OnButtonClusterStatus)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_HL, OnButtonSaveHl)
	ON_BN_CLICKED(IDC_BUTTON_LOAD_HL, OnButtonLoadHl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDisplayHosts message handlers

void CDisplayHosts::OnButtonAddHost() 
{
	int iHost;

	UpdateData(TRUE);
	iHost = 1 + m_lbHosts.GetCurSel();
	if(iHost < 1) { iHost = 1; }
	swprintf(m_wcClusterHosts[iHost], L"%hs", (LPCSTR)m_csNewHost);
	sprintf(m_cRemoteDirectories[iHost], "%s", (LPCSTR)m_csRemoteDirectory);
	m_iHostIsUp[iHost] = 0;
	ShowClusterList();
	iHost++;
	if(iHost <= m_iNCols*m_iNRows) {  m_lbHosts.SetCurSel(iHost-1); }
	UpdateData(FALSE);
}

void CDisplayHosts::OnButtonClearHosts() 
{
	int iHost;

	for(iHost=1; iHost <= m_iNCols*m_iNRows; iHost++) { if(m_iHostIsUp[iHost] != 1) {
		swprintf(m_wcClusterHosts[iHost], L"none");
		m_iHostIsUp[iHost] = -2;
	}}
	ShowClusterList();
	m_lbHosts.SetCurSel(0);
	UpdateData(FALSE);
}

void CDisplayHosts::InitializeHostList()
{
	int iHost;
	for(iHost=1; iHost <= m_iNRows*m_iNCols; iHost++) {
		if(m_iHostIsUp[iHost] == -2) { swprintf(m_wcClusterHosts[iHost], L"none"); }
	}
}

void CDisplayHosts::SetPP(CHvr_mfcDlg *pp)
{
	pMainDlg = pp;
}

void CDisplayHosts::ShowClusterList()
{
	int iRow, iCol, iHost;
	char str[256], cStatus[256];
	CString csRowCol;

	m_lbHosts.ResetContent();
	iHost = 1;
	for(iRow=0; iRow<m_iNRows; iRow++) {
	for(iCol=0; iCol<m_iNCols; iCol++) {
		swscanf(m_wcClusterHosts[iHost], L"%hs", str);
		if(m_iHostIsUp[iHost] == -2) { sprintf(cStatus, "NOT SET"); }
		if(m_iHostIsUp[iHost] == -1) { sprintf(cStatus, "FAIL   "); }
		if(m_iHostIsUp[iHost] ==  0) { sprintf(cStatus, "OFF    "); }
		if(m_iHostIsUp[iHost] ==  1) { sprintf(cStatus, "ON     "); }
		csRowCol.Format("%2d  %2d   %s   %s   %s",
			iRow+1, iCol+1, str, m_cRemoteDirectories[iHost], cStatus);
		m_lbHosts.AddString((LPCSTR)csRowCol);
		iHost++;
	}}
	UpdateData(FALSE);
	UpdateWindow();
}

//DEL void CDisplayHosts::StartCluster()
//DEL {
//DEL 
//DEL }

void CDisplayHosts::OnButtonStartCluster() 
{

	HRESULT hr;
	int i;

	for(i=1; i <= m_iNRows*m_iNCols; i++) { if(m_iHostIsUp[i] == 0) {
		MULTI_QI mqi[] = { {&IID_Ihvr_work, NULL, S_OK} };
		COSERVERINFO csi = {0, NULL, NULL, 0};

		csi.pwszName = (LPWSTR)m_wcClusterHosts[i];
		hr = CoCreateInstanceEx(CLSID_hvr_work, NULL, CLSCTX_SERVER, &csi, 
									   sizeof(mqi)/sizeof(mqi[0]), mqi);
		if(FAILED(hr)) {
			m_iHostIsUp[i] = -1;
			ShowClusterList();
		} else {
			pMainDlg->pChvrMainPort[i] = (Ihvr_work *)(mqi[0].pItf);

			// Set Viewing Frustum on remote server
			pMainDlg->pChvrMainPort[i]->SetFrustum(m_SFrusta[i].fCent,
													 m_SFrusta[i].fUp,
													 m_SFrusta[i].fNorm,
													 m_SFrusta[i].iWidth,
													 m_SFrusta[i].iHeight,
													 m_SFrusta[i].fWidth);

			// Initialize openGL window on remote server
			pMainDlg->pChvrMainPort[i]->StartUp();

			// Set Cluster Server to double buffer and do NON-block on rendering
			pMainDlg->pChvrMainPort[i]->SetOption(L"NRenderingBuffers", L"2");
			pMainDlg->pChvrMainPort[i]->SetOption(L"BlockOnRender", L"0");

			// Set only rends to use palletted textures
			if(m_wcClusterHosts[i][0] == L'r' &&
			   m_wcClusterHosts[i][1] == L'e' &&
			   m_wcClusterHosts[i][2] == L'n' &&
			   m_wcClusterHosts[i][3] == L'd'    ) {
				pMainDlg->pChvrMainPort[i]->SetOption(L"UsePalet", L"TRUE");
			}

			m_iHostIsUp[i] = 1;
			ShowClusterList();
		}
	}}
}

void CDisplayHosts::OnButtonStopCluster() 
{
	int i;

	pMainDlg->StopRendering();

	for(i=1; i <= m_iNCols*m_iNRows; i++) { if(m_iHostIsUp[i] == 1) {
		pMainDlg->pChvrMainPort[i]->ClearIt();
		pMainDlg->pChvrMainPort[i]->Release();
		m_iHostIsUp[i] = 0;
		ShowClusterList();
	}}
}

void CDisplayHosts::OnButtonClusterStatus() 
{
	ShowClusterList();
	UpdateData(FALSE);
}

void CDisplayHosts::OnButtonSaveHl() 
{
	int iRow, iCol, iHost;
	FILE *fp;
	CFileDialog dlgFile(FALSE);
	char str[256];

	dlgFile.m_ofn.lpstrFilter = "Cluster Host List (*.chl)\0*.chl\0\0";
	if(dlgFile.DoModal() == IDOK) {
		fp = fopen((LPCSTR)dlgFile.GetPathName(), "w");
		iHost = 1;
		for(iRow=0; iRow<m_iNRows; iRow++) {
		for(iCol=0; iCol<m_iNCols; iCol++) {
			swscanf(m_wcClusterHosts[iHost], L"%hs", str);
			fprintf(fp,"%s %s\n", str, m_cRemoteDirectories[iHost]);
			iHost++;
		}}
		fclose(fp);
	}
}

void CDisplayHosts::OnButtonLoadHl() 
{
	int iRow, iCol, iHost;
	FILE *fp;
	CFileDialog dlgFile(TRUE);
	char str[256];

	dlgFile.m_ofn.lpstrFilter = "Cluster Host List (*.chl)\0*.chl\0\0";
	if(dlgFile.DoModal() == IDOK) {
		fp = fopen((LPCSTR)dlgFile.GetPathName(), "r");
		iHost = 1;
		for(iRow=0; iRow<m_iNRows; iRow++) {
		for(iCol=0; iCol<m_iNCols; iCol++) {
			swscanf(m_wcClusterHosts[iHost], L"%hs", str);
			fscanf(fp,"%s %s\n", str, m_cRemoteDirectories[iHost]);
			swprintf(m_wcClusterHosts[iHost], L"%hs", str);
			m_iHostIsUp[iHost] = 0;
			iHost++;
		}}
		fclose(fp);

		ShowClusterList();
	}
}

BOOL CDisplayHosts::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	ShowClusterList();
	m_lbHosts.SetCurSel(0);
	m_csRemoteDirectory.Format("%s", m_cRemoteDirectories[1]);
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
