////////////////////////////////////////////////////////////////////////////////
//
// Author:   David H. Porter
//           Laboratory for Computational Science & Engineering
//           University of Minnesota
//
////////////////////////////////////////////////////////////////////////////////
/***************************************************************************************
Program:  HVR_SERVER  --  Hierarchical Volume Rendering Component Object Moduel
Copyright (C) 2002  David H. Porter

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
***************************************************************************************/

#if !defined(AFX_DISPLAYCONTROL_H__6BB529A1_1274_11D5_AB47_00D0680005D6__INCLUDED_)
#define AFX_DISPLAYCONTROL_H__6BB529A1_1274_11D5_AB47_00D0680005D6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DisplayControl.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDisplayControl dialog

class CDisplayControl : public CDialog
{
// Construction
public:
	void GenerateMovieFrusta();
	CDisplayControl(CWnd* pParent = NULL);   // standard constructor
	struct Frustum {
		float fCent[3];
		float fUp[3];
		float fNorm[3];
		int iWidth;
		int iHeight;
		float fWidth;
	};
	int m_iNMovieFrusta;
	Frustum m_SMovieFrusta[1000];
	Frustum m_SDiplayFrustum;


// Dialog Data
	//{{AFX_DATA(CDisplayControl)
	enum { IDD = IDD_DISPLAY_CONTROL };
	int		m_iDisplayWidth;
	int		m_iDisplayHeight;
	float	m_fDisplayFOV;
	int		m_iPanelWidth;
	int		m_iPanelHeight;
	int		m_iNPanelHoriz;
	int		m_iNPanelVert;
	float	m_fFullFOV;
	float	m_fSeamAngle;
	float	m_fStereoEyeDisp;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDisplayControl)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDisplayControl)
	virtual void OnOK();
	afx_msg void OnButtonAutoSetInteractive();
	afx_msg void OnDcButtonSave();
	afx_msg void OnButtonLoad();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DISPLAYCONTROL_H__6BB529A1_1274_11D5_AB47_00D0680005D6__INCLUDED_)
