/*
 * oft - frame timer for OpenGL, compile using:
 *        cc -O -o oft oft.c -lGL -lX11
 * Joe Habermann July 19, 1996
 * Thomas M. Ruwart June 8, 1998
 * Jon Kappler April, 26, 1999  - port to Win32
 *
 */
#include "stdafx.h"

#include <windows.h>         /* must include this before GL/gl.h */
#include <sys/types.h>
#include <time.h>
#include <sys/timeb.h>
#include <GL/gl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define YES 1
#define NO  0


static HDC hDC;				/* device context */
static HPALETTE hPalette = 0;			/* custom palette (if needed) */
static GLboolean animate = GL_TRUE;		/* animation flag */

/* win32 didn't have gettimeofday, so I added one, jk */
static void gettimeofday( struct _timeb *tv, struct _timeb *t2 )
{
	struct _timeb tbuf;

	_ftime( &tbuf );
	tv->time = tbuf.time;
	tv->millitm = tbuf.millitm;
	return;
}

static double timediff(struct _timeb *tim1, struct _timeb *tim2)
{
    int  sec, usec;
	double t;

    sec = tim2->time - tim1->time;
    usec = tim2->millitm - tim1->millitm;
    if (usec < 0) {
        sec--;
        usec = tim2->millitm + 1000 - tim1->millitm;
    }
//    return(((double)(sec * 1000000 + usec))/1000000);
//	sec = sec + (usec / 1000.0);
	t = usec;
	t = t / 1000.0;
	t = t + (double) sec;
    return t;
}

LONG WINAPI
WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{ 
    static PAINTSTRUCT ps;

    switch(uMsg) {
    case WM_PAINT: 
//	display();
	BeginPaint(hWnd, &ps);
	EndPaint(hWnd, &ps);
	return 0;

    case WM_SIZE:
	glViewport(0, 0, LOWORD(lParam), HIWORD(lParam));
	PostMessage(hWnd, WM_PAINT, 0, 0);
	return 0;

    case WM_CHAR:
	switch (wParam) {
	case 27:			/* ESC key */
	    PostQuitMessage(0);
	    break;
	case ' ':
	    animate = !animate;
	    break;
	}
	return 0;

    case WM_ACTIVATE:
	if (IsIconic(hWnd))
	    animate = GL_FALSE;
	else
	    animate = GL_TRUE;
	return 0;

    case WM_PALETTECHANGED:
	if (hWnd == (HWND)wParam)
	    break;
	/* fall through to WM_QUERYNEWPALETTE */

    case WM_QUERYNEWPALETTE:
	if (hPalette) {
	    UnrealizeObject(hPalette);
	    SelectPalette(hDC, hPalette, FALSE);
	    RealizePalette(hDC);
	    return TRUE;
	}
	return FALSE;

    case WM_CLOSE:
	PostQuitMessage(0);
	return 0;
    }

    return DefWindowProc(hWnd, uMsg, wParam, lParam); 
} 

HWND
CreateOpenGLWindow(char* title, int x, int y, int width, int height, 
		   BYTE type, DWORD flags, int depth)
{
    int         n, pf;
    HWND        hWnd;
    WNDCLASS    wc;
    LOGPALETTE* lpPal;
    PIXELFORMATDESCRIPTOR pfd;
    static HINSTANCE hInstance = 0;

    /* only register the window class once - use hInstance as a flag. */
    if (!hInstance) {
	hInstance = GetModuleHandle(NULL);
	wc.style         = CS_OWNDC;
	wc.lpfnWndProc   = (WNDPROC)WindowProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = LoadIcon(NULL, IDI_WINLOGO);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = NULL;
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = "OpenGL";

	if (!RegisterClass(&wc)) {
	    MessageBox(NULL, "RegisterClass() failed:  "
		       "Cannot register window class.", "Error", MB_OK);
	    return NULL;
	}
    }

    hWnd = CreateWindow("OpenGL", title, WS_OVERLAPPEDWINDOW |
			WS_CLIPSIBLINGS | WS_CLIPCHILDREN,
			x, y, width, height, NULL, NULL, hInstance, NULL);

    if (hWnd == NULL) {
	MessageBox(NULL, "CreateWindow() failed:  Cannot create a window.",
		   "Error", MB_OK);
	return NULL;
    }

    hDC = GetDC(hWnd);

    /* there is no guarantee that the contents of the stack that become
       the pfd are zeroed, therefore _make sure_ to clear these bits. */
    memset(&pfd, 0, sizeof(pfd));
    pfd.nSize        = sizeof(pfd);
    pfd.nVersion     = 1;
    pfd.dwFlags      = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | flags;
    pfd.iPixelType   = type;
    pfd.cColorBits   = depth; // 32 is probably the best choice

    pf = ChoosePixelFormat(hDC, &pfd);
    if (pf == 0) {
	MessageBox(NULL, "ChoosePixelFormat() failed:  "
		   "Cannot find a suitable pixel format.", "Error", MB_OK); 
	return 0;
    } 
 
    if (SetPixelFormat(hDC, pf, &pfd) == FALSE) {
	MessageBox(NULL, "SetPixelFormat() failed:  "
		   "Cannot set format specified.", "Error", MB_OK);
	return 0;
    } 

    DescribePixelFormat(hDC, pf, sizeof(PIXELFORMATDESCRIPTOR), &pfd);

    if (pfd.dwFlags & PFD_NEED_PALETTE ||
	pfd.iPixelType == PFD_TYPE_COLORINDEX) {

	n = 1 << pfd.cColorBits;
	if (n > 256) n = 256;

	lpPal = (LOGPALETTE*)malloc(sizeof(LOGPALETTE) +
				    sizeof(PALETTEENTRY) * n);
	if (lpPal == NULL)
	{
		MessageBox(NULL, "Cannot allocate palette memory.", 
			"malloc error", MB_OK);
		return NULL;
	}
	memset(lpPal, 0, sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * n);
	lpPal->palVersion = 0x300;
	lpPal->palNumEntries = n;

	GetSystemPaletteEntries(hDC, 0, n, &lpPal->palPalEntry[0]);
    
	/* if the pixel type is RGBA, then we want to make an RGB ramp,
	   otherwise (color index) set individual colors. */
	if (pfd.iPixelType == PFD_TYPE_RGBA) {
	    int redMask = (1 << pfd.cRedBits) - 1;
	    int greenMask = (1 << pfd.cGreenBits) - 1;
	    int blueMask = (1 << pfd.cBlueBits) - 1;
	    int i;

	    /* fill in the entries with an RGB color ramp. */
	    for (i = 0; i < n; ++i) {
		lpPal->palPalEntry[i].peRed = 
		    (((i >> pfd.cRedShift)   & redMask)   * 255) / redMask;
		lpPal->palPalEntry[i].peGreen = 
		    (((i >> pfd.cGreenShift) & greenMask) * 255) / greenMask;
		lpPal->palPalEntry[i].peBlue = 
		    (((i >> pfd.cBlueShift)  & blueMask)  * 255) / blueMask;
		lpPal->palPalEntry[i].peFlags = 0;
	    }
	} else {
	    lpPal->palPalEntry[0].peRed = 0;
	    lpPal->palPalEntry[0].peGreen = 0;
	    lpPal->palPalEntry[0].peBlue = 0;
	    lpPal->palPalEntry[0].peFlags = PC_NOCOLLAPSE;
	    lpPal->palPalEntry[1].peRed = 255;
	    lpPal->palPalEntry[1].peGreen = 0;
	    lpPal->palPalEntry[1].peBlue = 0;
	    lpPal->palPalEntry[1].peFlags = PC_NOCOLLAPSE;
	    lpPal->palPalEntry[2].peRed = 0;
	    lpPal->palPalEntry[2].peGreen = 255;
	    lpPal->palPalEntry[2].peBlue = 0;
	    lpPal->palPalEntry[2].peFlags = PC_NOCOLLAPSE;
	    lpPal->palPalEntry[3].peRed = 0;
	    lpPal->palPalEntry[3].peGreen = 0;
	    lpPal->palPalEntry[3].peBlue = 255;
	    lpPal->palPalEntry[3].peFlags = PC_NOCOLLAPSE;
	}

	hPalette = CreatePalette(lpPal);
	if (hPalette) {
	    SelectPalette(hDC, hPalette, FALSE);
	    RealizePalette(hDC);
	}

	free(lpPal);
    }

    ReleaseDC(hWnd, hDC);
//ReleaseDC(hDC, hWnd);

    return hWnd;
}    

#if 0

static    HDC hDC;				/* device context */
static    HGLRC hRC;				/* opengl context */
static    HWND  hWnd;				/* window */
static    MSG   msg;				/* message */


    int depth = 0;
    int sizex = 0, sizey = 0; 
	BYTE  colortype;
	DWORD buffertype;
	char s[4096];

/************************************************************
 *  Here's how to create an OpenGL window using wgl         *
 ************************************************************/
	*s = '\0';
	strcat(s,"DHPs Stupid Test");
	sizex = 512;
	sizey = 512;
	colortype = PFD_TYPE_RGBA;
//	buffertype = PFD_DOUBLEBUFFER;
	buffertype = 0;
	depth = 24;
    hWnd = CreateOpenGLWindow(s, 0, 0, sizex, sizey, colortype, buffertype, depth);
    if (hWnd == NULL) { exit(1); }
	hDC = GetDC(hWnd);
	hRC = wglCreateContext(hDC);
	wglMakeCurrent(hDC, hRC);

	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
/*
    glViewport(0, 0, sizex, sizey);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho (0, sizex, 0, sizey, -1.0, 1.0);
    glMatrixMode(GL_MODELVIEW);
    glDisable(GL_TEXTURE_1D);
    glDisable(GL_TEXTURE_2D);
    glDisable(GL_DEPTH_TEST);
*/
/************************************************************
 *  Here's how to bring it down cleanly                     *
 ************************************************************/
	wglMakeCurrent(hDC, NULL);
	wglDeleteContext(hRC);
	DestroyWindow(hWnd);
	ReleaseDC(hWnd, hDC);
	if (hPalette) { DeleteObject(hPalette); }

#endif